/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.food;

import com.github.teamfossilsarcheology.fossil.food.FoodType;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public abstract class FoodValueProvider
implements class_2405 {
    protected final class_7784 output;
    private final Path basePath;
    protected Map<FoodType, FoodAppender> builders;

    protected FoodValueProvider(class_7784 output) {
        this.output = output;
        this.basePath = output.method_45971().resolve("data/fossil/food");
        this.builders = Arrays.stream(FoodType.values()).collect(Collectors.toMap(Function.identity(), type -> new FoodAppender()));
    }

    private Path getPath(FoodType type) {
        return this.basePath.resolve(type.name().toLowerCase(Locale.ENGLISH) + ".json");
    }

    @NotNull
    public CompletableFuture<?> method_10319(class_7403 output) {
        this.buildFoodValues();
        ArrayList list = new ArrayList();
        this.builders.forEach((type, foodAppender) -> {
            if (foodAppender.items.isEmpty() && foodAppender.entities.isEmpty()) {
                return;
            }
            JsonObject jsonobject = foodAppender.serializeToJson();
            list.add(class_2405.method_10320((class_7403)output, (JsonElement)jsonobject, (Path)this.getPath((FoodType)((Object)type))));
        });
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    protected abstract void buildFoodValues();

    protected FoodAppender type(FoodType type) {
        return this.builders.get((Object)type);
    }

    protected static class FoodAppender {
        private final List<Entry> items = new ObjectArrayList();
        private final List<Entry> entities = new ObjectArrayList();

        public void itemTag(class_6862<class_1792> tag) {
            this.items.add(new Entry(tag.comp_327(), -1, "tag"));
        }

        public void item(class_1935 item) {
            this.item(item, -1);
        }

        public void item(class_1935 item, int value) {
            this.items.add(new Entry(class_7923.field_41178.method_10221((Object)item.method_8389()), value, "item"));
        }

        public void entityTag(class_6862<class_1299<?>> tag) {
            this.entities.add(new Entry(tag.comp_327(), -1, "tag"));
        }

        public void entity(class_1299<?> entityType) {
            this.entity(entityType, -1);
        }

        public void entity(class_1299<?> entityType, int value) {
            this.entity(class_7923.field_41177.method_10221(entityType), value);
        }

        public void entity(class_2960 location, int value) {
            this.entities.add(new Entry(location, value, "entity"));
        }

        public JsonObject serializeToJson() {
            JsonObject root = new JsonObject();
            JsonArray itemArray = new JsonArray();
            JsonArray entityArray = new JsonArray();
            root.add("items", (JsonElement)itemArray);
            root.add("entities", (JsonElement)entityArray);
            this.items.stream().sorted(FoodAppender::compare).forEach(entry -> itemArray.add((JsonElement)entry.serialize()));
            this.entities.stream().sorted(FoodAppender::compare).forEach(entry -> entityArray.add((JsonElement)entry.serialize()));
            return root;
        }

        private static int compare(Entry one, Entry other) {
            int i = one.id.method_12836().compareTo(other.id.method_12836());
            if (i == 0) {
                i = one.id.method_12832().compareTo(other.id.method_12832());
            }
            return i;
        }

        private record Entry(class_2960 id, int value, String key) {
            public JsonObject serialize() {
                JsonObject object = new JsonObject();
                object.addProperty(this.key, this.id.toString());
                if (this.value >= 0) {
                    object.addProperty("value", (Number)this.value);
                }
                return object;
            }
        }
    }
}

