/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.structures;

import com.github.teamfossilsarcheology.fossil.FossilMod;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModStructureType;
import com.github.teamfossilsarcheology.fossil.world.feature.structures.ModTemplatePools;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3780;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_5455;
import net.minecraft.class_5468;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_7151;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class AnuCastleStructure
extends class_3195 {
    public static final Codec<AnuCastleStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)AnuCastleStructure.method_42697((RecordCodecBuilder.Instance)instance)).apply((Applicative)instance, AnuCastleStructure::new));

    public AnuCastleStructure(class_3195.class_7302 settings) {
        super(settings);
    }

    @NotNull
    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        class_1923 chunkPos = context.comp_568();
        class_2338 blockPos = new class_2338(chunkPos.method_8326(), 63, chunkPos.method_8328());
        return AnuCastleStructure.addPieces(context, blockPos);
    }

    private static Optional<class_3195.class_7150> addPieces(class_3195.class_7149 context, class_2338 blockPos) {
        class_5455 registryAccess = context.comp_561();
        class_3485 structureTemplateManager = context.comp_565();
        class_2919 worldgenRandom = context.comp_566();
        class_2378 templatePools = registryAccess.method_30530(class_7924.field_41249);
        class_2470 rotation = class_2470.field_11467;
        class_3785 structureTemplatePool = (class_3785)templatePools.method_29107(ModTemplatePools.ANU_CASTLE_START);
        class_3784 structurePoolElement = structureTemplatePool.method_16631((class_5819)worldgenRandom);
        class_3790 poolElementStructurePiece = new class_3790(structureTemplateManager, structurePoolElement, blockPos, structurePoolElement.method_19308(), rotation, structurePoolElement.method_16628(structureTemplateManager, blockPos, rotation));
        class_3341 boundingBox = poolElementStructurePiece.method_14935();
        int posY = blockPos.method_10264();
        int delta = boundingBox.method_35416() + poolElementStructurePiece.method_16646();
        poolElementStructurePiece.method_14922(0, posY - delta, 0);
        return Optional.of(new class_3195.class_7150(blockPos, builder -> {
            ArrayList pieces = Lists.newArrayList();
            pieces.add(poolElementStructurePiece);
            Placer placer = new Placer((class_2378<class_3785>)templatePools, 4, structureTemplateManager, pieces, (class_5819)worldgenRandom);
            placer.placing.addLast(new PieceState(poolElementStructurePiece, 0));
            while (!placer.placing.isEmpty()) {
                PieceState pieceState = placer.placing.removeFirst();
                placer.tryPlacingChildren(pieceState.piece, pieceState.depth);
            }
            pieces.forEach(arg_0 -> ((class_6626)builder).method_35462(arg_0));
        }));
    }

    @NotNull
    public class_7151<?> method_41618() {
        return ModStructureType.ANU_CASTLE;
    }

    private static final class Placer {
        private final class_2378<class_3785> pools;
        private final int maxDepth;
        private final class_3485 structureTemplateManager;
        private final List<? super class_3790> pieces;
        private final class_5819 random;
        private final Deque<PieceState> placing = Queues.newArrayDeque();

        public Placer(class_2378<class_3785> pools, int maxDepth, class_3485 structureTemplateManager, List<? super class_3790> list, class_5819 random) {
            this.pools = pools;
            this.maxDepth = maxDepth;
            this.structureTemplateManager = structureTemplateManager;
            this.pieces = list;
            this.random = random;
        }

        private void tryPlacingChildren(class_3790 baseStructurePiece, int depth) {
            class_3784 structurePoolElement = baseStructurePiece.method_16644();
            class_2338 baseStructurePosition = baseStructurePiece.method_16648();
            class_2470 baseStructureRotation = baseStructurePiece.method_16888();
            class_3785.class_3786 projection = structurePoolElement.method_16624();
            class_3341 baseStructureBoundingBox = baseStructurePiece.method_14935();
            block0: for (class_3499.class_3501 baseStructureJigSaw : structurePoolElement.method_16627(this.structureTemplateManager, baseStructurePosition, baseStructureRotation, this.random)) {
                class_2960 poolLocation = new class_2960(baseStructureJigSaw.field_15595.method_10558("pool"));
                Optional baseTargetPool = this.pools.method_17966(poolLocation);
                if (baseTargetPool.isEmpty() || ((class_3785)baseTargetPool.get()).method_16632() == 0 && !Objects.equals(poolLocation, class_5468.field_26254.method_29177())) {
                    FossilMod.LOGGER.warn("Empty or non-existent pool: {}", (Object)poolLocation);
                    continue;
                }
                ArrayList targetPoolElements = Lists.newArrayList();
                if (depth != this.maxDepth) {
                    targetPoolElements.addAll(((class_3785)baseTargetPool.get()).method_16633(this.random));
                }
                if (targetPoolElements.isEmpty()) continue;
                class_2338 baseJigsawPosition = baseStructureJigSaw.field_15597;
                class_2350 baseJigsawDirection = class_3748.method_26378((class_2680)baseStructureJigSaw.field_15596);
                class_2338 expectedJigsawPosition = baseJigsawPosition.method_10093(baseJigsawDirection);
                int baseMinY = baseStructureBoundingBox.method_35416();
                int baseJigsawOffset = baseJigsawPosition.method_10264() - baseMinY;
                class_3784 targetElement = (class_3784)targetPoolElements.get(0);
                List allTargetJigsaws = targetElement.method_16627(this.structureTemplateManager, class_2338.field_10980, baseStructureRotation, this.random);
                for (class_3499.class_3501 targetJigsaw : allTargetJigsaws) {
                    int groundLevelDelta = baseStructurePiece.method_16646();
                    if (!class_3748.method_16546((class_3499.class_3501)baseStructureJigSaw, (class_3499.class_3501)targetJigsaw)) continue;
                    class_2338 targetJigsawPosition = targetJigsaw.field_15597;
                    class_2338 vecToTargetJigsaw = expectedJigsawPosition.method_10059((class_2382)targetJigsawPosition);
                    class_3341 targetBoundingBox = targetElement.method_16628(this.structureTemplateManager, vecToTargetJigsaw, baseStructureRotation);
                    class_3790 poolElementStructurePiece2 = new class_3790(this.structureTemplateManager, targetElement, vecToTargetJigsaw, groundLevelDelta, baseStructureRotation, targetBoundingBox);
                    baseStructurePiece.method_16647(new class_3780(expectedJigsawPosition.method_10263(), baseMinY + groundLevelDelta, expectedJigsawPosition.method_10260(), 0, targetElement.method_16624()));
                    poolElementStructurePiece2.method_16647(new class_3780(baseJigsawPosition.method_10263(), baseMinY + baseJigsawOffset - targetJigsawPosition.method_10264() + groundLevelDelta, baseJigsawPosition.method_10260(), 0, projection));
                    this.pieces.add((class_3790)poolElementStructurePiece2);
                    if (depth + 1 > this.maxDepth) continue block0;
                    this.placing.addLast(new PieceState(poolElementStructurePiece2, depth + 1));
                    continue block0;
                }
            }
        }
    }

    private static final class PieceState {
        private final class_3790 piece;
        private final int depth;

        public PieceState(class_3790 poolElementStructurePiece, int i) {
            this.piece = poolElementStructurePiece;
            this.depth = i;
        }
    }
}

