/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.TreeBranchLayouts;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5821;

public class CalamitesTreeFeature
extends CustomTreeFeature {
    boolean placeLargeVariant(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_2680 log = ((class_2465)ModBlocks.CALAMITES_LOG.get()).method_9564();
        class_2680 leaves = ((class_2397)ModBlocks.CALAMITES_LEAVES.get()).method_9564();
        int treeHeight = 24 + context.method_33654().method_43048(16) - 8;
        int m = this.getMaxFreeTreeHeight((class_3746)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        int thickHeight = (int)Math.floor((double)treeHeight * 0.4);
        for (int i = 0; i < treeHeight; ++i) {
            class_2338 northPos;
            Object stateNorth;
            class_2338 southPos;
            class_2680 stateSouth;
            class_2338 westPos;
            class_2680 stateWest;
            level.method_8652(pos.method_10086(i), log, 19);
            if (i >= thickHeight) continue;
            class_2338 eastPos = pos.method_10069(1, i, 0);
            class_2680 stateEast = level.method_8320(eastPos);
            if (stateEast.method_26207().method_15800()) {
                level.method_8652(eastPos, log, 19);
            }
            if ((stateWest = level.method_8320(westPos = pos.method_10069(-1, i, 0))).method_26207().method_15800()) {
                level.method_8652(westPos, log, 19);
            }
            if ((stateSouth = level.method_8320(southPos = pos.method_10069(0, i, 1))).method_26207().method_15800()) {
                level.method_8652(southPos, log, 19);
            }
            if (!(stateNorth = level.method_8320(northPos = pos.method_10069(0, i, -1))).method_26207().method_15800()) continue;
            level.method_8652(northPos, log, 19);
        }
        int startY = 3 + context.method_33654().method_43048(2);
        int sectionSpacing = 5;
        int availableHeight = treeHeight - startY;
        int sectionCount = Math.max(1, availableHeight / sectionSpacing);
        List<Object> sectionLayout = new ArrayList();
        for (int i = 0; i < sectionCount; ++i) {
            int sectionBaseY = startY + i * sectionSpacing;
            float heightFraction = 1.0f - (float)sectionBaseY / (float)treeHeight;
            if (i == 0) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_2, TreeBranchLayouts.CALAMITES_LARGE_SECTION_3);
            } else if (heightFraction < 0.35f) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_0, TreeBranchLayouts.CALAMITES_LARGE_SECTION_1);
            } else if (heightFraction < 0.6f) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_2, TreeBranchLayouts.CALAMITES_LARGE_SECTION_3);
                for (class_2350 dir : List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039)) {
                    for (int d = 1; d <= 2; ++d) {
                        logPos = pos.method_10069(dir.method_10148() * d, sectionBaseY, dir.method_10165() * d);
                        stateAt = level.method_8320(logPos);
                        if (!stateAt.method_26207().method_15800()) continue;
                        level.method_8652(logPos, (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)(dir == class_2350.field_11043 || dir == class_2350.field_11035 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048)), 19);
                    }
                }
            } else if (heightFraction < 0.85f) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_LARGE_SECTION_4, TreeBranchLayouts.CALAMITES_LARGE_SECTION_5);
                for (class_2350 dir : List.of(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039)) {
                    for (int d = 1; d <= 4; ++d) {
                        logPos = pos.method_10069(dir.method_10148() * d, sectionBaseY, dir.method_10165() * d);
                        stateAt = level.method_8320(logPos);
                        if (!stateAt.method_26207().method_15800()) continue;
                        level.method_8652(logPos, (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)(dir == class_2350.field_11043 || dir == class_2350.field_11035 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048)), 19);
                    }
                }
            } else {
                sectionLayout = TreeBranchLayouts.CALAMITES_LARGE_SECTION_0;
            }
            if (Math.abs(sectionBaseY - treeHeight) <= 2) {
                sectionLayout = List.of();
            }
            for (class_2338 relPos : sectionLayout) {
                class_2338 leafPos = pos.method_10069(relPos.method_10263(), sectionBaseY + relPos.method_10264(), relPos.method_10260());
                class_2680 stateAtPos = level.method_8320(leafPos);
                if (!stateAtPos.method_26207().method_15800()) continue;
                this.placeLeaf(level, leafPos, leaves);
            }
        }
        for (class_2338 relPos : TreeBranchLayouts.CALAMITES_LARGE_SECTION_0) {
            class_2338 leafPos = pos.method_10069(relPos.method_10263(), treeHeight + relPos.method_10264() - 1, relPos.method_10260());
            class_2680 stateAtPos = level.method_8320(leafPos);
            if (!stateAtPos.method_26207().method_15800()) continue;
            this.placeLeaf(level, leafPos, leaves);
        }
        if (context.method_33654().method_43056()) {
            class_2338 leafPos = pos.method_10086(treeHeight);
            class_2680 stateAtPos = level.method_8320(leafPos);
            if (stateAtPos.method_26207().method_15800()) {
                this.placeLeaf(level, leafPos, leaves);
            }
            if (context.method_33654().method_43056() && (stateAtPos = level.method_8320(leafPos = pos.method_10086(treeHeight + 1))).method_26207().method_15800()) {
                this.placeLeaf(level, leafPos, leaves);
            }
        }
        return true;
    }

    boolean placeMediumVariant(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_2680 log = ((class_2465)ModBlocks.CALAMITES_LOG.get()).method_9564();
        class_2680 leaves = ((class_2397)ModBlocks.CALAMITES_LEAVES.get()).method_9564();
        int treeHeight = 12 + context.method_33654().method_43048(9) - 4;
        int m = this.getMaxFreeTreeHeight((class_3746)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.method_8652(pos.method_10086(i), log, 19);
        }
        int startY = 2 + context.method_33654().method_43048(2);
        int sectionSpacing = 3;
        int availableHeight = treeHeight - startY;
        int sectionCount = Math.max(1, availableHeight / sectionSpacing);
        int lastSectionType = -1;
        int lastSectionBaseY = -1;
        for (int i = 0; i < sectionCount; ++i) {
            List<Object> sectionLayout;
            int sectionBaseY = startY + i * sectionSpacing;
            if (i == 0) {
                sectionLayout = this.randomChoice(context, TreeBranchLayouts.CALAMITES_MED_SECTION_1, TreeBranchLayouts.CALAMITES_MED_SECTION_2);
            } else {
                float heightFraction;
                if (lastSectionType == 2 || lastSectionType == 3) {
                    sectionBaseY = lastSectionBaseY + sectionSpacing + 1;
                }
                if ((heightFraction = (float)sectionBaseY / (float)treeHeight) <= 0.5f) {
                    choice = context.method_33654().method_43048(8);
                    switch (choice) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_3;
                            lastSectionType = 3;
                            break;
                        }
                        default: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_2;
                            lastSectionType = 2;
                            break;
                        }
                    }
                } else if (heightFraction <= 0.7f) {
                    choice = context.method_33654().method_43048(8);
                    switch (choice) {
                        case 0: 
                        case 1: 
                        case 2: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_2;
                            lastSectionType = 2;
                            break;
                        }
                        default: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_1;
                            lastSectionType = 1;
                            break;
                        }
                    }
                } else {
                    choice = context.method_33654().method_43048(8);
                    switch (choice) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_1;
                            lastSectionType = 1;
                            break;
                        }
                        default: {
                            sectionLayout = TreeBranchLayouts.CALAMITES_MED_SECTION_2;
                            lastSectionType = 2;
                        }
                    }
                }
            }
            if (Math.abs(sectionBaseY - treeHeight) <= 1) {
                sectionLayout = List.of();
            }
            for (class_2338 relPos : sectionLayout) {
                class_2338 leafPos = pos.method_10069(relPos.method_10263(), sectionBaseY + relPos.method_10264(), relPos.method_10260());
                class_2680 stateAtPos = level.method_8320(leafPos);
                if (!stateAtPos.method_26207().method_15800()) continue;
                this.placeLeaf(level, leafPos, leaves);
            }
            lastSectionBaseY = sectionBaseY;
        }
        for (class_2338 relPos : TreeBranchLayouts.CALAMITES_MED_SECTION_0) {
            class_2338 leafPos = pos.method_10069(relPos.method_10263(), treeHeight + relPos.method_10264(), relPos.method_10260());
            class_2680 stateAtPos = level.method_8320(leafPos);
            if (!stateAtPos.method_26207().method_15800()) continue;
            this.placeLeaf(level, leafPos, leaves);
        }
        if (context.method_33654().method_43056()) {
            class_2338 leafPos = pos.method_10086(treeHeight + 1);
            class_2680 stateAtPos = level.method_8320(leafPos);
            if (stateAtPos.method_26207().method_15800()) {
                this.placeLeaf(level, leafPos, leaves);
            }
            if (context.method_33654().method_43056() && (stateAtPos = level.method_8320(leafPos = pos.method_10086(treeHeight + 2))).method_26207().method_15800()) {
                this.placeLeaf(level, leafPos, leaves);
            }
        }
        return true;
    }

    boolean placeSmallVariant(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        class_2680 log = ((class_2465)ModBlocks.CALAMITES_LOG.get()).method_9564();
        class_2680 leaves = ((class_2397)ModBlocks.CALAMITES_LEAVES.get()).method_9564();
        int treeHeight = 8 + context.method_33654().method_43048(3) - 1;
        int m = this.getMaxFreeTreeHeight((class_3746)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        for (int i = 0; i < treeHeight; ++i) {
            level.method_8652(pos.method_10086(i), log, 19);
        }
        ArrayList<class_2338> leafPositions = new ArrayList<class_2338>();
        int variant = context.method_33654().method_43048(3);
        switch (variant) {
            case 0: {
                leafPositions.addAll(TreeBranchLayouts.CALAMITES_SMALL_VARIANT_A);
                break;
            }
            case 1: {
                leafPositions.addAll(TreeBranchLayouts.CALAMITES_SMALL_VARIANT_B);
                break;
            }
            case 2: {
                leafPositions.addAll(TreeBranchLayouts.CALAMITES_SMALL_VARIANT_C);
            }
        }
        if (context.method_33654().method_43056()) {
            leafPositions.add(new class_2338(0, 0, 0));
            if (context.method_33654().method_43056()) {
                leafPositions.add(new class_2338(0, 1, 0));
            }
        }
        for (int i = 0; i < leafPositions.size(); ++i) {
            class_2338 leafPos = (class_2338)leafPositions.get(i);
            class_2338 worldPos = pos.method_10086(treeHeight).method_10081((class_2382)leafPos);
            class_2680 stateAtPos = level.method_8320(worldPos);
            if (!stateAtPos.method_26207().method_15800()) continue;
            this.placeLeaf(level, pos.method_10086(treeHeight).method_10081((class_2382)leafPos), leaves);
        }
        return true;
    }

    @Override
    protected boolean placeTree(class_5821<class_3111> context) {
        switch (context.method_33654().method_43048(8)) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.placeSmallVariant(context);
            }
            case 5: 
            case 6: {
                return this.placeMediumVariant(context);
            }
            case 7: {
                return this.placeLargeVariant(context);
            }
        }
        return true;
    }

    private List<class_2338> randomChoice(class_5821<class_3111> context, List<class_2338> a, List<class_2338> b) {
        return context.method_33654().method_43056() ? a : b;
    }
}

