/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfossilsarcheology.fossil.world.feature.tree;

import com.github.teamfossilsarcheology.fossil.block.ModBlocks;
import com.github.teamfossilsarcheology.fossil.world.feature.tree.CustomTreeFeature;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2397;
import net.minecraft.class_2465;
import net.minecraft.class_2541;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3111;
import net.minecraft.class_3532;
import net.minecraft.class_3746;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class MutantTreeFeature
extends CustomTreeFeature {
    @Override
    protected boolean placeTree(class_5821<class_3111> context) {
        class_5281 level = context.method_33652();
        class_2338 pos = context.method_33655();
        int treeHeight = context.method_33654().method_43048(3) + 8;
        int foliageHeight = 4;
        int m = this.getMaxFreeTreeHeight((class_3746)level, treeHeight, pos);
        if (m < treeHeight) {
            return false;
        }
        class_2680 log = ((class_2465)ModBlocks.MUTANT_TREE_LOG.get()).method_9564();
        class_2680 leaves = ((class_2397)ModBlocks.MUTANT_TREE_LEAVES.get()).method_9564();
        class_2680 vine = ((class_2248)ModBlocks.MUTANT_TREE_VINE.get()).method_9564();
        for (int i = 0; i < treeHeight - 1; ++i) {
            level.method_8652(pos.method_10086(i), log, 19);
        }
        int trunk = treeHeight - foliageHeight;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        ArrayList<class_2338> vinePositions = new ArrayList<class_2338>();
        for (int i = 0; i < foliageHeight; ++i) {
            int offset = i == 0 ? 3 : 3 - i + 1;
            for (int x = -offset; x <= offset; ++x) {
                for (int z = -offset; z <= offset; ++z) {
                    if (!level.method_22347((class_2338)mutable.method_25504((class_2382)pos, x, trunk + i, z))) continue;
                    this.placeLeaf(level, (class_2338)mutable, leaves);
                    if (i != 0 || Math.abs(x) != 3 && Math.abs(z) != 3) continue;
                    vinePositions.add(mutable.method_10062());
                }
            }
        }
        class_2338 belowFoliage = pos.method_10086(trunk - 1);
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                int absX = Math.abs(x);
                int absZ = Math.abs(z);
                if (level.method_8409().method_43048(6) == 0 && (absX == 2 && absZ <= 2 || absX <= 2 && absZ == 2)) {
                    mutable.method_25504((class_2382)belowFoliage, x, 1, z);
                    class_2338 diff = mutable.method_10069(-belowFoliage.method_10263(), -belowFoliage.method_10264(), -belowFoliage.method_10260());
                    float steps = Math.max(class_3532.method_15382((int)diff.method_10263()), Math.max(class_3532.method_15382((int)diff.method_10264()), class_3532.method_15382((int)diff.method_10260())));
                    float dX = (float)diff.method_10263() / steps;
                    float dY = (float)diff.method_10264() / steps;
                    float dZ = (float)diff.method_10260() / steps;
                    int i = 1;
                    while ((float)i <= steps) {
                        level.method_8652((class_2338)mutable.method_25504((class_2382)belowFoliage, (int)(0.5 + (double)(dX * (float)i)), (int)(dY * (float)i), (int)(0.5 + (double)(dZ * (float)i))), (class_2680)log.method_11657((class_2769)class_2465.field_11459, (Comparable)this.getLogAxis(belowFoliage, (class_2338)mutable)), 19);
                        ++i;
                    }
                    continue;
                }
                if (level.method_8409().method_43048(5) == 0 && (x != 0 || z != 0)) {
                    if (!level.method_8320((class_2338)mutable.method_25504((class_2382)belowFoliage, x, 1, z)).method_27852(leaves.method_26204())) continue;
                    this.removeLeaf(level, (class_2338)mutable);
                    if (absX != 3 && absZ != 3) continue;
                    vinePositions.remove(mutable.method_10062());
                    continue;
                }
                if (level.method_8409().method_43048(2) != 0 || absX != 3 && absZ != 3) continue;
                this.placeLeaf(level, (class_2338)mutable.method_25504((class_2382)belowFoliage, x, 0, z), leaves);
                vinePositions.remove(mutable.method_10084());
                vinePositions.add(mutable.method_10062());
            }
        }
        this.placeVine(level, vine, vinePositions);
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            mutable.method_25505((class_2382)belowFoliage, direction);
            for (int i = 0; !(i >= trunk || level.method_22347((class_2338)mutable) && level.method_22347(mutable.method_10074()) && level.method_8409().method_43048(9) == 0); ++i) {
                mutable.method_10098(class_2350.field_11033);
            }
        }
        return true;
    }

    private class_2350.class_2351 getLogAxis(class_2338 pos, class_2338 otherPos) {
        class_2350.class_2351 axis = class_2350.class_2351.field_11052;
        int xDiff = Math.abs(otherPos.method_10263() - pos.method_10263());
        int diff = Math.max(xDiff, Math.abs(otherPos.method_10260() - pos.method_10260()));
        if (diff > 0) {
            axis = xDiff == diff ? class_2350.class_2351.field_11048 : class_2350.class_2351.field_11051;
        }
        return axis;
    }

    private void placeVine(class_5281 level, class_2680 state, List<class_2338> leafPositions) {
        class_5819 random = level.method_8409();
        leafPositions.forEach(blockPos -> {
            class_2338 pos;
            if (random.method_43048(4) == 0 && this.isAir(level, pos = blockPos.method_10067())) {
                this.placeHangingVine(level, pos, class_2541.field_11702, state);
            }
            if (random.method_43048(4) == 0 && this.isAir(level, pos = blockPos.method_10078())) {
                this.placeHangingVine(level, pos, class_2541.field_11696, state);
            }
            if (random.method_43048(4) == 0 && this.isAir(level, pos = blockPos.method_10095())) {
                this.placeHangingVine(level, pos, class_2541.field_11699, state);
            }
            if (random.method_43048(4) == 0 && this.isAir(level, pos = blockPos.method_10072())) {
                this.placeHangingVine(level, pos, class_2541.field_11706, state);
            }
        });
    }

    private void placeHangingVine(class_5281 level, class_2338 pos, class_2746 sideProperty, class_2680 state) {
        level.method_8652(pos, (class_2680)state.method_11657((class_2769)sideProperty, (Comparable)Boolean.valueOf(true)), 19);
        pos = pos.method_10074();
        for (int i = 4; this.isAir(level, pos) && i > 0; --i) {
            level.method_8652(pos, (class_2680)state.method_11657((class_2769)sideProperty, (Comparable)Boolean.valueOf(true)), 19);
            pos = pos.method_10074();
        }
    }
}

