/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.tool_trinkets.forge;

import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.zelythia.tool_trinkets.ToolTrinkets;
import net.zelythia.tool_trinkets.forge.network.Networking;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod(value="tool_trinkets")
public final class ToolTrinketsForge {
    public static final TagKey<Item> TOOLS = ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"tools"));
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolTrinketsForge.class);
    private static final String ATTRIBUTE_NAME = "tool_trinkets_add_slot";

    public ToolTrinketsForge(FMLJavaModLoadingContext context) {
        ToolTrinkets.init();
        context.getModEventBus().addListener(this::clientSetup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        Networking.register();
    }

    public void clientSetup(FMLCommonSetupEvent event) {
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        final ItemStack stack = (ItemStack)evt.getObject();
        evt.addCapability(CuriosCapability.ID_ITEM, CuriosApi.createCurioProvider((ICurio)new ICurio(){
            final /* synthetic */ ToolTrinketsForge this$0;
            {
                this.this$0 = this$0;
            }

            public ItemStack getStack() {
                return stack;
            }

            public void onEquip(SlotContext slotContext, ItemStack prevStack) {
                super.onEquip(slotContext, prevStack);
                LazyOptional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity());
                curiosInventory.ifPresent(inv -> {
                    int slots = ((ICurioStacksHandler)inv.getStacksHandler("tools").get()).getSlots();
                    IDynamicStackHandler tools = ((ICurioStacksHandler)inv.getStacksHandler("tools").get()).getStacks();
                    int count = 0;
                    for (int i = 0; i < slots; ++i) {
                        if (tools.getStackInSlot(i) == ItemStack.f_41583_) continue;
                        ++count;
                    }
                    if (count == slots) {
                        UUID uuid = UUID.randomUUID();
                        inv.addPermanentSlotModifier("tools", uuid, ToolTrinketsForge.ATTRIBUTE_NAME, 1.0, AttributeModifier.Operation.ADDITION);
                    }
                });
            }

            public void onUnequip(SlotContext slotContext, ItemStack newStack) {
                super.onUnequip(slotContext, newStack);
                LazyOptional curiosInventory = CuriosApi.getCuriosInventory((LivingEntity)slotContext.entity());
                curiosInventory.ifPresent(inv -> inv.getModifiers().get((Object)"tools").stream().filter(attributeModifier -> attributeModifier.m_22214_().equals(ToolTrinketsForge.ATTRIBUTE_NAME)).findFirst().ifPresent(attributeModifier -> inv.removeSlotModifier("tools", attributeModifier.m_22209_())));
            }
        }));
    }
}

