/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.tool_trinkets.forge.mixins;

import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import net.zelythia.autotools.AutoTools;
import net.zelythia.tool_trinkets.forge.network.CMoveCurioPacket;
import net.zelythia.tool_trinkets.forge.network.Networking;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

@Mixin(value={AutoTools.class})
public class AutoToolsMixin {
    @Redirect(method={"getCorrectTool(Lnet/minecraft/world/phys/HitResult;Lnet/minecraft/client/Minecraft;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;getContainerSize()I"))
    private static int onGetContainerSize(Inventory inventory) {
        int i = 0;
        Optional curiosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player);
        if (curiosItemHandler.isPresent()) {
            i = ((ICurioStacksHandler)((ICuriosItemHandler)curiosItemHandler.get()).getStacksHandler("tools").get()).getStacks().getSlots();
        }
        return inventory.getContainerSize() + i;
    }

    @Redirect(method={"getCorrectTool(Lnet/minecraft/world/phys/HitResult;Lnet/minecraft/client/Minecraft;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Inventory;getItem(I)Lnet/minecraft/world/item/ItemStack;"))
    private static ItemStack onGetItem(Inventory inventory, int slot) {
        if (slot >= inventory.getContainerSize()) {
            Optional curiosItemHandler = CuriosApi.getCuriosInventory((LivingEntity)Minecraft.getInstance().player);
            if (curiosItemHandler.isPresent()) {
                int size = inventory.getContainerSize();
                return ((ICurioStacksHandler)((ICuriosItemHandler)curiosItemHandler.get()).getStacksHandler("tools").get()).getStacks().getStackInSlot(slot - size);
            }
            return ItemStack.EMPTY;
        }
        return inventory.getItem(slot);
    }

    @Redirect(method={"selectItem(Lnet/minecraft/client/Minecraft;Lnet/minecraft/world/entity/player/Inventory;I)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;handleInventoryMouseClick(IIILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V"))
    private static void onSelectItem(MultiPlayerGameMode instance, int id, int sourceSlot, int destSlot, ClickType clickType, Player player) {
        if (sourceSlot >= player.getInventory().getContainerSize()) {
            Networking.CHANNEL.send((Object)new CMoveCurioPacket(sourceSlot - player.getInventory().getContainerSize(), destSlot), PacketDistributor.SERVER.noArg());
        } else {
            instance.handleInventoryMouseClick(id, sourceSlot, destSlot, ClickType.SWAP, player);
        }
    }

    @Redirect(method={"switchBack()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;handleInventoryMouseClick(IIILnet/minecraft/world/inventory/ClickType;Lnet/minecraft/world/entity/player/Player;)V", ordinal=1))
    private static void onSwitchBack(MultiPlayerGameMode instance, int id, int sourceSlot, int destSlot, ClickType clickType, Player player) {
        if (sourceSlot >= player.getInventory().getContainerSize()) {
            Networking.CHANNEL.send((Object)new CMoveCurioPacket(sourceSlot - player.getInventory().getContainerSize(), destSlot), PacketDistributor.SERVER.noArg());
        } else {
            instance.handleInventoryMouseClick(id, sourceSlot, destSlot, ClickType.SWAP, player);
        }
    }
}

