/*
 * Decompiled with CFR 0.152.
 */
package net.zelythia.tool_trinkets.forge.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;

public class CMoveCurioPacket {
    private final int curioSlot;
    private final int invSlot;

    public CMoveCurioPacket(int curioSlot, int invSlot) {
        this.curioSlot = curioSlot;
        this.invSlot = invSlot;
    }

    public static void encode(CMoveCurioPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.curioSlot);
        buf.writeInt(pkt.invSlot);
    }

    public static CMoveCurioPacket decode(FriendlyByteBuf buf) {
        int from = buf.readInt();
        int to = buf.readInt();
        return new CMoveCurioPacket(from, to);
    }

    public static void handle(CMoveCurioPacket pkt, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.enqueueWork(() -> {
            if (ctx.getSender() == null) {
                return;
            }
            ServerPlayer player = ctx.getSender();
            if (pkt.curioSlot < 0 || pkt.invSlot < 0) {
                return;
            }
            if (pkt.invSlot >= player.f_36096_.f_38839_.size()) {
                return;
            }
            CuriosApi.getCuriosInventory((LivingEntity)player).ifPresent(curiosItemHandler -> {
                int curioSlot = pkt.curioSlot;
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curiosItemHandler.getStacksHandler("tools").orElseGet(null);
                if (stacksHandler == null || curioSlot >= stacksHandler.getSlots()) {
                    curioSlot = stacksHandler.getSlots() - 1;
                }
                ItemStack fromStack = stacksHandler.getStacks().getStackInSlot(curioSlot).m_41777_();
                ItemStack toStack = player.m_150109_().m_8020_(pkt.invSlot).m_41777_();
                player.m_150109_().m_6836_(pkt.invSlot, fromStack);
                stacksHandler.getStacks().setStackInSlot(curioSlot, toStack);
                player.f_36096_.m_38946_();
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SPacketSyncCurios(player.m_19879_(), curiosItemHandler.getCurios()));
            });
        });
        ctx.setPacketHandled(true);
    }
}

