/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.api;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.id.paradiselost.entities.util.PostTickEntity;
import net.minecraft.class_1282;
import net.minecraft.class_129;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2292;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2604;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2968;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_7871;
import net.minecraft.class_7887;
import net.minecraft.class_7924;

public abstract class BlockLikeEntity
extends class_1297
implements PostTickEntity {
    private static final class_2940<class_2338> ORIGIN = class_2945.method_12791(BlockLikeEntity.class, (class_2941)class_2943.field_13324);
    public int moveTime = 0;
    public boolean dropItem = true;
    protected class_2487 blockEntityData;
    protected class_2680 blockState = class_2246.field_10340.method_9564();
    protected boolean canSetBlock = true;
    protected boolean hurtEntities = false;
    protected int fallHurtMax = 40;
    protected float fallHurtAmount = 2.0f;
    protected boolean collides;
    protected boolean partOfSet = false;

    public BlockLikeEntity(class_1299<? extends BlockLikeEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public BlockLikeEntity(class_1299<? extends BlockLikeEntity> entityType, class_1937 world, double x, double y, double z, class_2680 blockState) {
        this(entityType, world);
        this.blockState = blockState;
        this.field_23807 = true;
        this.method_5814(x, y, z);
        this.method_18799(class_243.field_1353);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.setOrigin(this.method_24515());
    }

    public BlockLikeEntity(class_1299<? extends BlockLikeEntity> entityType, class_1937 world, class_2338 pos, class_2680 blockState, boolean partOfSet) {
        this(entityType, world, (double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5, blockState);
        this.partOfSet = partOfSet;
    }

    protected class_238 method_33332() {
        if (this.field_6011 == null || this.blockState == null) {
            return super.method_33332();
        }
        class_2338 origin = (class_2338)this.field_6011.method_12789(ORIGIN);
        class_265 shape = this.blockState.method_26220((class_1922)this.method_37908(), origin);
        if (shape.method_1110()) {
            this.collides = false;
            shape = this.blockState.method_26218((class_1922)this.method_37908(), origin);
            if (shape.method_1110()) {
                return super.method_33332();
            }
        } else {
            this.collides = true;
        }
        class_238 box = shape.method_1107();
        return box.method_997(this.method_19538().method_1020(new class_243(0.5, 0.0, 0.5)));
    }

    public void method_5773() {
        if (this.hurtEntities) {
            double verticalSpeed = Math.abs(this.method_18798().method_10214());
            this.fallHurtAmount = this.blockState.method_26204().method_36555() * (float)verticalSpeed;
            this.fallHurtMax = Math.max(Math.round(this.fallHurtAmount), this.fallHurtMax);
        }
    }

    public abstract void postTickMovement();

    public void postTickEntityCollision(class_1297 entity) {
        block3: {
            block2: {
                if (!(entity instanceof BlockLikeEntity)) break block2;
                BlockLikeEntity ble = (BlockLikeEntity)entity;
                if (ble.partOfSet) break block3;
            }
            this.blockState.method_26178(this.method_37908(), this.method_24515(), entity);
        }
    }

    public boolean shouldCease() {
        class_3965 blockHitResult;
        if (this.method_37908().field_9236) {
            return false;
        }
        class_2338 blockPos = this.method_24515();
        boolean isConcrete = this.blockState.method_26204() instanceof class_2292;
        if (isConcrete && this.method_37908().method_8316(blockPos).method_15767(class_3486.field_15517)) {
            return true;
        }
        double speed = this.method_18798().method_1027();
        if (isConcrete && speed > 1.0 && (blockHitResult = this.method_37908().method_17742(new class_3959(new class_243(this.field_6014, this.field_6036, this.field_5969), new class_243(this.method_23317(), this.method_23318(), this.method_23321()), class_3959.class_3960.field_17558, class_3959.class_242.field_1345, (class_1297)this))).method_17783() != class_239.class_240.field_1333 && this.method_37908().method_8316(blockHitResult.method_17777()).method_15767(class_3486.field_15517)) {
            return true;
        }
        return this.moveTime > 100 && (blockPos.method_10264() < this.method_37908().method_31607() || blockPos.method_10264() > this.method_37908().method_31600());
    }

    @Override
    public void incubus_Concern$postTick() {
        if (this.blockState.method_26215()) {
            this.method_31472();
            return;
        }
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        if (this.moveTime++ == 0) {
            class_2338 blockPos = this.method_24515();
            class_2248 block = this.blockState.method_26204();
            if (this.method_37908().method_8320(blockPos).method_27852(block)) {
                this.method_37908().method_8650(blockPos, false);
            } else if (!this.method_37908().field_9236 && !this.partOfSet) {
                this.method_31472();
                return;
            }
        }
        this.postTickMovement();
        this.postTickMoveEntities();
        if (this.shouldCease()) {
            this.cease();
        }
    }

    public void postTickMoveEntities() {
        if (class_2346.method_10128((class_2680)this.blockState)) {
            return;
        }
        List otherEntities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_991(this.method_5829().method_989(0.0, 0.5, 0.0)));
        for (class_1297 entity : otherEntities) {
            if (!(entity instanceof BlockLikeEntity) && !entity.field_5960 && this.collides) {
                entity.method_5784(class_1313.field_6306, this.method_18798());
                entity.method_24830(true);
                if (!entity.method_5829().method_997(entity.method_18798().method_1021(2.0)).method_994(this.method_5829().method_997(this.method_18798().method_1021(2.0)))) {
                    entity.method_18799(entity.method_18798().method_1019(this.method_18798()));
                }
            }
            this.postTickEntityCollision(entity);
        }
    }

    public boolean method_5747(float distance, float multiplier, class_1282 damageSource) {
        int i = class_3532.method_15386((float)(distance - 1.0f));
        if (!this.hurtEntities || i <= 0) {
            return false;
        }
        boolean flag = this.blockState.method_26164(class_3481.field_15486);
        class_1282 damageSource2 = flag ? this.method_37908().method_48963().method_48810((class_1297)this) : this.method_37908().method_48963().method_48798((class_1297)this);
        float f = Math.min(class_3532.method_15375((float)((float)i * this.fallHurtAmount)), this.fallHurtMax);
        this.method_37908().method_8335((class_1297)this, this.method_5829().method_991(this.method_5829().method_989(0.0, 1.0 + -2.0 * this.method_18798().method_10214(), 0.0))).forEach(entity -> entity.method_5643(damageSource2, f));
        if (flag && f > 0.0f && this.field_5974.method_43057() < 0.05f + (float)i * 0.05f) {
            class_2680 blockstate = class_2199.method_9346((class_2680)this.blockState);
            if (blockstate == null) {
                this.canSetBlock = false;
            } else {
                this.blockState = blockstate;
            }
        }
        return false;
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10566("BlockState", (class_2520)class_2512.method_10686((class_2680)this.blockState));
        compound.method_10569("Time", this.moveTime);
        compound.method_10556("DropItem", this.dropItem);
        compound.method_10556("HurtEntities", this.hurtEntities);
        compound.method_10548("FallHurtAmount", this.fallHurtAmount);
        compound.method_10569("FallHurtMax", this.fallHurtMax);
        if (this.blockEntityData != null) {
            compound.method_10566("TileEntityData", (class_2520)this.blockEntityData);
        }
    }

    protected void method_5749(class_2487 compound) {
        this.blockState = class_2512.method_10681((class_7871)class_7887.method_46817().method_46762(class_7924.field_41254), (class_2487)compound.method_10562("BlockState"));
        this.moveTime = compound.method_10550("Time");
        if (compound.method_10573("HurtEntities", 99)) {
            this.hurtEntities = compound.method_10577("HurtEntities");
            this.fallHurtAmount = compound.method_10583("FallHurtAmount");
            this.fallHurtMax = compound.method_10550("FallHurtMax");
        } else if (this.blockState.method_26164(class_3481.field_15486)) {
            this.hurtEntities = true;
        }
        if (compound.method_10573("DropItem", 99)) {
            this.dropItem = compound.method_10577("DropItem");
        }
        if (compound.method_10573("TileEntityData", 10)) {
            this.blockEntityData = compound.method_10562("TileEntityData");
        }
        if (this.blockState.method_26215()) {
            this.blockState = class_2246.field_10340.method_9564();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_1937 getWorldObj() {
        return this.method_37908();
    }

    public boolean method_5862() {
        return false;
    }

    public void method_5819(class_129 section) {
        super.method_5819(section);
        section.method_578("Imitating BlockState", (Object)this.blockState.toString());
    }

    public class_2680 getBlockState() {
        return this.blockState;
    }

    public void setHurtEntities(boolean hurtEntities) {
        this.hurtEntities = hurtEntities;
    }

    public void cease() {
        if (this.method_31481()) {
            return;
        }
        class_2338 pos = this.method_24515();
        class_2680 state = this.method_37908().method_8320(pos);
        if (state.method_27852(class_2246.field_10008)) {
            this.method_18799(this.method_18798().method_18805(0.7, 0.5, 0.7));
            return;
        }
        if (!this.trySetBlock()) {
            this.breakApart();
        }
    }

    public boolean trySetBlock() {
        class_2338 blockPos = this.method_24515();
        class_2680 blockState = this.method_37908().method_8320(blockPos);
        boolean canReplace = blockState.method_26166((class_1750)new class_2968(this.method_37908(), blockPos, class_2350.field_11036, class_1799.field_8037, class_2350.field_11033));
        boolean canPlace = this.blockState.method_26184((class_4538)this.method_37908(), blockPos);
        if (!(this.canSetBlock && canPlace && canReplace)) {
            return false;
        }
        if (this.blockState.method_28498((class_2769)class_2741.field_12508) && this.method_37908().method_8316(blockPos).method_15772() == class_3612.field_15910) {
            this.blockState = (class_2680)this.blockState.method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(true));
        }
        if (this.method_37908().method_8652(blockPos, this.blockState, 3)) {
            class_2586 blockEntity;
            this.method_31472();
            if (this.blockEntityData != null && this.blockState.method_31709() && (blockEntity = this.method_37908().method_8321(blockPos)) != null) {
                class_2487 compoundTag = blockEntity.method_38244();
                for (String keyName : this.blockEntityData.method_10541()) {
                    class_2520 tag = this.blockEntityData.method_10580(keyName);
                    if (tag == null || "x".equals(keyName) || "y".equals(keyName) || "z".equals(keyName)) continue;
                    compoundTag.method_10566(keyName, tag.method_10707());
                }
                blockEntity.method_11014(compoundTag);
                blockEntity.method_5431();
            }
            for (class_2350 dir : class_2350.method_42013().toList()) {
                class_2680 newState = this.blockState.method_26191(dir, this.method_37908().method_8320(blockPos.method_10093(dir)), (class_1936)this.method_37908(), blockPos, blockPos.method_10093(dir));
                this.method_37908().method_8501(blockPos, newState);
                this.blockState = newState;
            }
            this.method_37908().method_39279(blockPos, this.blockState.method_26204(), 1);
            this.postTickMoveEntities();
            return true;
        }
        return false;
    }

    public void breakApart() {
        if (this.method_31481()) {
            return;
        }
        this.method_31472();
        if (this.dropItem && this.method_37908().method_8450().method_8355(class_1928.field_19393)) {
            class_2248.method_9497((class_2680)this.blockState, (class_1937)this.method_37908(), (class_2338)this.method_24515());
        }
        this.method_37908().method_8444(null, 2001, this.method_24515(), class_2248.method_9507((class_2680)this.blockState));
    }

    public boolean method_5833() {
        return true;
    }

    public class_2604 createSpawnPacket() {
        return new class_2604((class_1297)this, class_2248.method_9507((class_2680)this.getBlockState()) * (this.partOfSet ? -1 : 1));
    }

    public void method_31471(class_2604 packet) {
        super.method_31471(packet);
        int data = packet.method_11166();
        this.partOfSet = data < 0;
        this.blockState = class_2248.method_9531((int)(packet.method_11166() * (this.partOfSet ? -1 : 1)));
        this.field_23807 = true;
        double d = packet.method_11175();
        double e = packet.method_11174();
        double f = packet.method_11176();
        this.method_5814(d, e + (double)((1.0f - this.method_17682()) / 2.0f), f);
        this.setOrigin(this.method_24515());
    }

    public void alignWith(BlockLikeEntity other, class_2382 offset) {
        if (this == other) {
            return;
        }
        class_243 newPos = other.method_19538().method_1019(class_243.method_24954((class_2382)offset));
        this.method_23327(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        this.method_18799(other.method_18798());
    }

    public boolean method_5732() {
        return false;
    }

    @Environment(value=EnvType.CLIENT)
    public class_2338 getOrigin() {
        return (class_2338)this.field_6011.method_12789(ORIGIN);
    }

    public void setOrigin(class_2338 origin) {
        this.field_6011.method_12778(ORIGIN, (Object)origin);
        this.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
    }

    public void markPartOfSet() {
        this.partOfSet = true;
    }

    protected void method_5693() {
        this.field_6011.method_12784(ORIGIN, (Object)class_2338.field_10980);
    }

    public boolean method_30948() {
        return this.collides;
    }

    public boolean method_30949(class_1297 other) {
        return !(other instanceof BlockLikeEntity) && super.method_30949(other);
    }
}

