/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.api;

import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.id.paradiselost.api.BlockLikeEntity;
import net.id.paradiselost.api.BlockLikeSet;
import net.id.paradiselost.entities.block.FloatingBlockEntity;
import net.id.paradiselost.entities.util.FloatingBlockHelperImpls;
import net.id.paradiselost.items.tools.base_tools.GravityWandItem;
import net.id.paradiselost.tag.ParadiseLostBlockTags;
import net.minecraft.class_1792;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public interface FloatingBlockHelper {
    public static final int MAX_MOVABLE_BLOCKS = 12;
    public static final FloatingBlockHelperImpls.Any ANY = FloatingBlockHelperImpls.Any.getInstance();
    public static final FloatingBlockHelperImpls.Standard STANDARD = FloatingBlockHelperImpls.Standard.getInstance();
    public static final FloatingBlockHelperImpls.Double DOUBLE = FloatingBlockHelperImpls.Double.getInstance();
    public static final FloatingBlockHelperImpls.Pusher PUSHER = FloatingBlockHelperImpls.Pusher.getInstance();
    public static final Function<FloatingBlockEntity, Boolean> DEFAULT_DROP_STATE = entity -> {
        class_1937 world = entity.method_37908();
        class_2338 pos = entity.method_24515();
        int distFromTop = world.method_31600() - pos.method_10264();
        return !entity.isInTag(ParadiseLostBlockTags.DECAYING_FLOATERS) && distFromTop <= 50;
    };

    default public boolean tryCreate(class_1937 world, class_2338 pos) {
        return this.tryCreate(world, pos, false);
    }

    public boolean tryCreate(class_1937 var1, class_2338 var2, boolean var3);

    public boolean isSuitableFor(class_2680 var1);

    public boolean isBlocked(boolean var1, class_1937 var2, class_2338 var3);

    public static boolean isBlockBlacklisted(class_1937 world, class_2338 pos, class_2680 state) {
        return state.method_26164(ParadiseLostBlockTags.NON_FLOATERS) || !class_2665.method_11484((class_2680)state, (class_1937)world, (class_2338)pos, (class_2350)class_2350.field_11036, (boolean)true, (class_2350)class_2350.field_11036);
    }

    public static boolean isBlockBlacklisted(class_1937 world, class_2338 pos) {
        return FloatingBlockHelper.isBlockBlacklisted(world, pos, world.method_8320(pos));
    }

    public static boolean willBlockDrop(class_1937 world, class_2338 pos, class_2680 state, boolean partOfStructure) {
        FloatingBlockEntity entity = new FloatingBlockEntity(world, pos, state, partOfStructure);
        boolean willDrop = entity.getDropState().get();
        entity.method_31472();
        return willDrop;
    }

    public static boolean isToolAdequate(class_1838 context) {
        class_2338 pos = context.method_8037();
        class_1937 world = context.method_8045();
        class_2680 state = world.method_8320(pos);
        class_1792 heldItem = context.method_8041().method_7909();
        return world.method_8321(pos) == null && state.method_26214((class_1922)world, pos) != -1.0f && (!state.method_29291() || heldItem.method_7856(state) || heldItem instanceof GravityWandItem && FloatingBlockHelper.validForWand(state)) && !state.method_26164(ParadiseLostBlockTags.NON_FLOATERS);
    }

    public static boolean validForWand(class_2680 bs) {
        return !bs.method_26164(class_3481.field_33717);
    }

    public static class SetBuilder
    extends BlockLikeSet.Builder {
        private final class_1937 world;

        public SetBuilder(class_1937 world, class_2338 initial) {
            super(initial);
            this.world = world;
            this.add(initial);
        }

        public SetBuilder add(class_2338 pos) {
            FloatingBlockEntity entity = new FloatingBlockEntity(this.world, pos, this.world.method_8320(pos), true);
            this.entries.put(pos.method_10059((class_2382)this.origin), entity);
            return this;
        }

        public SetBuilder addif(class_2338 pos, Predicate<Map<class_2382, BlockLikeEntity>> predicate) {
            if (predicate.test(Map.copyOf(this.entries))) {
                return this.add(pos);
            }
            return this;
        }
    }
}

