/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.api;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.id.paradiselost.ParadiseLost;
import net.id.paradiselost.component.MoaGenes;
import net.id.paradiselost.entities.passive.moa.MoaAttributes;
import net.id.paradiselost.world.dimension.ParadiseLostBiomes;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class MoaAPI {
    private static final Map<class_2960, MoaRace> MOA_RACE_REGISTRY = new Object2ObjectOpenHashMap();
    private static final Map<class_5321<class_1959>, SpawnBucket> MOA_SPAWN_REGISTRY = new Object2ObjectOpenHashMap();
    private static final Set<MatingEntry> MOA_BREEDING_REGISTRY = new ObjectOpenHashSet();
    public static final MoaRace FALLBACK_MOA = new MoaRace(MoaAttributes.GROUND_SPEED, SpawnStatWeighting.TANK);

    public static MoaRace register(class_2960 name, MoaRace race) {
        MOA_RACE_REGISTRY.put(name, race);
        return race;
    }

    public static void registerBreeding(MoaRace child, float chance, MoaRace parentA, MoaRace parentB) {
        MoaAPI.registerBreeding(child, MoaAPI.createChanceCheck(chance), parentA, parentB);
    }

    public static void registerBreeding(MoaRace child, Predicate<MoaBreedingContext> predicate, MoaRace parentA, MoaRace parentB) {
        MoaAPI.registerBreeding(child, predicate.and(MoaAPI.createIdentityCheck(parentA, parentB)));
    }

    public static void registerBreeding(MoaRace child, Predicate<MoaBreedingContext> predicate) {
        MoaAPI.registerBreeding(new MatingEntry(child, predicate));
    }

    private static void registerBreeding(MatingEntry entry) {
        MOA_BREEDING_REGISTRY.add(entry);
    }

    public static void registerSpawning(MoaRace race, int weight, class_5321<class_1959> spawnBiome) {
        MOA_SPAWN_REGISTRY.computeIfAbsent(spawnBiome, key -> new SpawnBucket()).put(race, weight);
    }

    public static MoaRace getRace(class_2960 raceId) {
        return MOA_RACE_REGISTRY.getOrDefault(raceId, FALLBACK_MOA);
    }

    public static Iterator<MoaRace> getRegisteredRaces() {
        return MOA_RACE_REGISTRY.values().iterator();
    }

    private static Optional<SpawnBucket> getSpawnBucket(class_5321<class_1959> biome) {
        return Optional.ofNullable(MOA_SPAWN_REGISTRY.get(biome));
    }

    @NotNull
    public static MoaRace getMoaFromSpawning(class_5321<class_1959> biome, class_5819 random) {
        return MoaAPI.getSpawnBucket(biome).map(bucket -> bucket.get(random)).orElse(MOA_SPAWN_REGISTRY.get(ParadiseLostBiomes.HIGHLANDS_PLAINS_KEY).get(random));
    }

    public static MoaRace getMoaFromBreeding(MoaBreedingContext ctx) {
        Optional<MatingEntry> childRace = MOA_BREEDING_REGISTRY.stream().filter(matingEntry -> matingEntry.breedingRequirements.test(ctx)).findAny();
        return childRace.map(MatingEntry::race).orElseGet(() -> {
            if (ctx.parentA.getRace() == FALLBACK_MOA) {
                return ctx.parentB.getRace();
            }
            if (ctx.parentB.getRace() == FALLBACK_MOA) {
                return ctx.parentA.getRace();
            }
            return ctx.world().method_8409().method_43056() ? ctx.parentA.getRace() : ctx.parentB.getRace();
        });
    }

    public static MoaRace getMoaFromBreeding(MoaGenes parentA, MoaGenes parentB, class_1937 world, class_2338 pos) {
        MoaBreedingContext context = new MoaBreedingContext(parentA, parentB, world, pos);
        return MoaAPI.getMoaFromBreeding(context);
    }

    private static Predicate<MoaBreedingContext> createIdentityCheck(MoaRace raceA, MoaRace raceB) {
        return ctx -> raceA == ctx.parentA.getRace() && raceB == ctx.parentB.getRace() || raceB == ctx.parentA.getRace() && raceA == ctx.parentB.getRace();
    }

    private static Predicate<MoaBreedingContext> createChanceCheck(float chance) {
        return ctx -> ctx.world.method_8409().method_43057() < chance;
    }

    static {
        MoaAPI.register(ParadiseLost.locate("fallback"), FALLBACK_MOA);
    }

    public record MoaRace(MoaAttributes defaultAffinity, SpawnStatWeighting statWeighting, boolean glowing, boolean legendary, class_2396<?> particles) {
        public MoaRace(MoaAttributes defaultAffinity, SpawnStatWeighting statWeighting) {
            this(defaultAffinity, statWeighting, false, false, (class_2396<?>)class_2398.field_11215);
        }

        public class_2960 getId() {
            for (Map.Entry<class_2960, MoaRace> entry : MOA_RACE_REGISTRY.entrySet()) {
                if (entry.getValue() != this) continue;
                return entry.getKey();
            }
            ParadiseLost.LOG.error("MoaAPI.MoaRace.getId() called before race was registered. Report this to somebody.");
            return FALLBACK_MOA.getId();
        }

        public String getTranslationKey() {
            class_2960 id = this.getId();
            return "moa.race." + id.method_12836() + "." + id.method_12832();
        }
    }

    private record MatingEntry(MoaRace race, Predicate<MoaBreedingContext> breedingRequirements) {
    }

    private static class SpawnBucket {
        private final Map<MoaRace, Integer> weights = new HashMap<MoaRace, Integer>();
        private MoaRace heaviest = FALLBACK_MOA;
        private int totalWeight = 0;

        private SpawnBucket() {
        }

        private void put(MoaRace race, int weight) {
            if (weight < 1) {
                throw new IllegalArgumentException(race.getId().toString() + " has an invalid weight, must be 1 or higher!");
            }
            if (weight > this.weights.getOrDefault(this.heaviest, 0)) {
                this.heaviest = race;
            }
            this.weights.put(race, weight);
            this.totalWeight += weight;
        }

        private MoaRace get(class_5819 random) {
            Optional<Map.Entry> entryOptional = this.weights.entrySet().stream().filter(entry -> random.method_43048(this.totalWeight) < (Integer)entry.getValue()).findAny();
            return entryOptional.map(Map.Entry::getKey).orElse(this.heaviest);
        }
    }

    public record MoaBreedingContext(MoaGenes parentA, MoaGenes parentB, class_1937 world, class_2338 pos) {
    }

    public static enum SpawnStatWeighting {
        SPEED(0.08f, 0.1f, 0.02f, 0.03f, 0.0f, -0.1f, 0.0f, -0.01f, 0.0f, 8.0f),
        GLIDE(0.013f, 0.08f, 0.035f, 0.039f, -0.04f, -0.08f, 0.0f, -0.01f, 0.0f, 6.0f),
        ENDURANCE(0.023f, 0.06f, 0.02f, 0.02f, -0.085f, -0.08f, -0.01f, -0.02f, 2.0f, 8.0f),
        TANK(0.0f, 0.07f, 0.01f, 0.02f, -0.025f, -0.05f, -0.02f, -0.01f, 6.0f, 6.0f),
        MYTHICAL_SPEED(0.31f, 0.17f, 0.082f, 0.0375f, 0.0f, -0.1f, 0.0f, -0.01f, 0.0f, 8.0f),
        MYTHICAL_GLIDE(0.013f, 0.08f, 0.035f, 0.039f, -0.085f, -0.085f, 0.0f, -0.01f, 0.0f, 6.0f),
        MYTHICAL_TANK(0.0f, 0.07f, 0.01f, 0.02f, -0.025f, -0.05f, -0.03f, -0.01f, 14.0f, 6.0f),
        MYTHICAL_ALL(0.31f, 0.17f, 0.035f, 0.039f, -0.085f, -0.085f, -0.03f, -0.01f, 14.0f, 6.0f);

        private final ImmutableMap<MoaAttributes, Weighting> data;

        private SpawnStatWeighting(float baseGroundSpeed, float groundSpeedVariance, float baseGlidingSpeed, float glidingSpeedVariance, float baseGlidingDecay, float glidingDecayVariance, float baseJumpStrength, float jumpStrengthVariance, float baseMaxHealth, float maxHealthVariance) {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            builder.put((Object)MoaAttributes.GROUND_SPEED, (Object)new Weighting(baseGroundSpeed, groundSpeedVariance));
            builder.put((Object)MoaAttributes.GLIDING_SPEED, (Object)new Weighting(baseGlidingSpeed, glidingSpeedVariance));
            builder.put((Object)MoaAttributes.GLIDING_DECAY, (Object)new Weighting(baseGlidingDecay, glidingDecayVariance));
            builder.put((Object)MoaAttributes.JUMPING_STRENGTH, (Object)new Weighting(baseJumpStrength, jumpStrengthVariance));
            builder.put((Object)MoaAttributes.MAX_HEALTH, (Object)new Weighting(baseMaxHealth, maxHealthVariance));
            builder.put((Object)MoaAttributes.DROP_MULTIPLIER, (Object)new Weighting(0.0f, 0.0f));
            this.data = builder.build();
        }

        public float configure(MoaAttributes attribute, MoaRace race, class_5819 random) {
            Weighting statData = (Weighting)this.data.get((Object)attribute);
            return Math.min(attribute.max, attribute.min + (statData.base + random.method_43057() * statData.variance * (race.defaultAffinity == attribute ? (attribute == MoaAttributes.DROP_MULTIPLIER ? 2.0f : 1.05f) : 1.0f)));
        }

        private record Weighting(float base, float variance) {
        }
    }
}

