/*
 * Decompiled with CFR 0.152.
 */
package net.id.paradiselost.component;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Arrays;
import java.util.UUID;
import net.id.paradiselost.api.MoaAPI;
import net.id.paradiselost.component.ParadiseLostComponents;
import net.id.paradiselost.entities.ParadiseLostEntityTypes;
import net.id.paradiselost.entities.passive.moa.MoaAttributes;
import net.id.paradiselost.entities.passive.moa.MoaEntity;
import net.id.paradiselost.items.ParadiseLostItems;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public class MoaGenes
implements AutoSyncedComponent {
    private final Object2FloatOpenHashMap<MoaAttributes> attributeMap = new Object2FloatOpenHashMap();
    private MoaAPI.MoaRace race = MoaAPI.FALLBACK_MOA;
    private MoaAttributes affinity;
    private boolean legendary;
    private boolean initialized;
    private UUID owner;
    private float hunger = 100.0f;

    public static class_1799 getEggForCommand(MoaAPI.MoaRace race, class_1937 world, boolean baby) {
        class_1799 stack = new class_1799((class_1935)ParadiseLostItems.MOA_EGG);
        class_2487 nbt = stack.method_7911("genes");
        class_5819 random = world.method_8409();
        MoaGenes genes = new MoaGenes();
        for (MoaAttributes attribute : MoaAttributes.values()) {
            genes.attributeMap.addTo((Object)attribute, race.statWeighting().configure(attribute, race, random));
        }
        genes.race = race;
        genes.affinity = race.defaultAffinity();
        genes.initialized = true;
        genes.writeToNbt(nbt);
        nbt.method_10556("baby", baby);
        return stack;
    }

    public static MoaEntity getMoaFromEgg(class_1937 world, class_1799 stack, UUID owner) {
        MoaEntity moa = (MoaEntity)ParadiseLostEntityTypes.MOA.method_5883(world);
        MoaGenes genes = moa.getGenes();
        if (stack.method_31574((class_1792)ParadiseLostItems.MOA_EGG)) {
            genes.readFromNbt(stack.method_7911("genes"));
            genes.owner = owner == null ? UUID.randomUUID() : owner;
        }
        moa.method_5614(-43200);
        return moa;
    }

    public static MoaGenes get(@NotNull MoaEntity moa) {
        return (MoaGenes)ParadiseLostComponents.MOA_GENETICS_KEY.get((Object)moa);
    }

    public void initMoa(@NotNull MoaEntity moa) {
        class_1937 world = moa.method_37908();
        class_5819 random = moa.method_6051();
        this.race = MoaAPI.getMoaFromSpawning((class_5321<class_1959>)((class_5321)world.method_23753(moa.method_24515()).method_40230().get()), random);
        this.affinity = this.race.defaultAffinity();
        for (MoaAttributes attribute : MoaAttributes.values()) {
            this.attributeMap.addTo((Object)attribute, this.race.statWeighting().configure(attribute, this.race, random));
        }
        this.initialized = true;
    }

    public class_1799 getEggForBreeding(MoaGenes otherParent, class_1937 world, class_2338 pos) {
        MoaAPI.MoaRace childRace = MoaAPI.getMoaFromBreeding(this, otherParent, world, pos);
        class_1799 stack = new class_1799((class_1935)ParadiseLostItems.MOA_EGG);
        class_2487 nbt = stack.method_7911("genes");
        class_5819 random = world.method_8409();
        MoaGenes genes = new MoaGenes();
        float increaseChance = 1.0f;
        for (MoaAttributes attribute : MoaAttributes.values()) {
            boolean increase = random.method_43057() <= increaseChance;
            genes.attributeMap.addTo((Object)attribute, attribute.fromBreeding(this, otherParent, increase));
            if (!increase) continue;
            increaseChance /= 2.0f;
        }
        genes.race = childRace;
        genes.affinity = random.method_43056() ? this.affinity : otherParent.affinity;
        genes.owner = random.method_43056() ? this.owner : otherParent.owner;
        genes.initialized = true;
        genes.writeToNbt(nbt);
        nbt.method_10556("baby", true);
        return stack;
    }

    public float getAttribute(MoaAttributes attribute) {
        return this.attributeMap.getOrDefault((Object)attribute, attribute.min);
    }

    public void setAttribute(MoaAttributes attribute, float value) {
        this.attributeMap.put((Object)attribute, value);
    }

    public MoaAttributes getAffinity() {
        return this.affinity;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public MoaAPI.MoaRace getRace() {
        return this.race;
    }

    public class_2960 getTexture() {
        class_2960 id = this.race.getId();
        String name = id.method_12832();
        String namespace = id.method_12836();
        return new class_2960(namespace, "textures/entity/moa/" + name + ".png");
    }

    public float getHunger() {
        return this.hunger;
    }

    public void setHunger(float hunger) {
        this.hunger = Math.max(Math.min(hunger, 100.0f), 0.0f);
    }

    public boolean isTamed() {
        return this.owner != null;
    }

    public void tame(UUID newOwner) {
        this.owner = newOwner;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void readFromNbt(class_2487 tag) {
        this.initialized = tag.method_10577("initialized");
        if (this.initialized) {
            this.race = MoaAPI.getRace(class_2960.method_12829((String)tag.method_10558("raceId")));
            String affinityStr = tag.method_10558("affinity");
            this.affinity = affinityStr.isEmpty() ? this.race.defaultAffinity() : MoaAttributes.valueOf(affinityStr);
            this.legendary = tag.method_10577("legendary");
            if (tag.method_10573("hunger", 5)) {
                this.hunger = tag.method_10583("hunger");
            }
            if (tag.method_10577("tamed")) {
                this.owner = tag.method_25926("owner");
            }
            Arrays.stream(MoaAttributes.values()).forEach(attribute -> {
                if (tag.method_10573(attribute.name(), 5)) {
                    this.attributeMap.put((Object)attribute, tag.method_10583(attribute.name()));
                } else if (attribute.equals((Object)MoaAttributes.JUMPING_STRENGTH)) {
                    this.attributeMap.put((Object)attribute, attribute.max);
                } else {
                    this.attributeMap.put((Object)attribute, attribute.min);
                }
            });
        }
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("initialized", this.initialized);
        if (this.initialized) {
            tag.method_10582("raceId", this.race.getId().toString());
            tag.method_10582("affinity", this.affinity.name());
            tag.method_10556("legendary", this.legendary);
            tag.method_10548("hunger", this.hunger);
            tag.method_10556("tamed", this.isTamed());
            if (this.isTamed()) {
                tag.method_25927("owner", this.owner);
            }
            Arrays.stream(MoaAttributes.values()).forEach(attribute -> tag.method_10548(attribute.name(), this.attributeMap.getFloat((Object)attribute)));
        }
    }
}

