/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="zeromod", value={Dist.CLIENT})
public class SwapOverlay {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean isActive = false;
    private static final ResourceLocation[] OVERLAY_TEXTURES = new ResourceLocation[80];
    private static final int FRAME_DURATION = 15;
    private static final int TOTAL_FRAMES = 80;
    private static long startTime = -1L;

    public static void setActive(boolean active) {
        if (active && !isActive) {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91073_ == null) {
                LOGGER.warn("Cannot activate overlay: No level loaded");
                return;
            }
            isActive = true;
            startTime = minecraft.f_91073_.m_46467_();
            LOGGER.info("SiuuDodgeOverlay activated at game time {}", (Object)startTime);
        } else if (!active && isActive) {
            isActive = false;
            startTime = -1L;
            LOGGER.info("SiuuDodgeOverlay deactivated");
        }
    }

    @SubscribeEvent
    public static void onRenderGuiOverlay(RenderGuiOverlayEvent.Pre event) {
        if (!isActive) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || !minecraft.f_91074_.m_6084_() || minecraft.f_91073_ == null) {
            SwapOverlay.setActive(false);
            return;
        }
        long gameTime = minecraft.f_91073_.m_46467_();
        int elapsedTicks = (int)(gameTime - startTime);
        int frameIndex = elapsedTicks / 15;
        if (frameIndex >= 80) {
            SwapOverlay.setActive(false);
            return;
        }
        ResourceLocation currentTexture = OVERLAY_TEXTURES[frameIndex];
        if (currentTexture == null) {
            LOGGER.error("Texture at frame index {} is null!", (Object)frameIndex);
            SwapOverlay.setActive(false);
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        int width = minecraft.m_91268_().m_85445_();
        int height = minecraft.m_91268_().m_85446_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        try {
            guiGraphics.m_280163_(currentTexture, 0, 0, 0.0f, 0.0f, width, height, width, height);
            LOGGER.debug("Rendered frame {} with texture: {}", (Object)(frameIndex + 1), (Object)currentTexture);
        }
        catch (Exception e) {
            LOGGER.error("Failed to render overlay texture at frame {}: {}", (Object)(frameIndex + 1), (Object)currentTexture, (Object)e);
            SwapOverlay.setActive(false);
        }
        RenderSystem.disableBlend();
    }

    static {
        LOGGER.info("Initializing OVERLAY_TEXTURES for {} frames", (Object)80);
        for (int i = 0; i < 80; ++i) {
            SwapOverlay.OVERLAY_TEXTURES[i] = new ResourceLocation("zeromod", "textures/gui/overlay" + (i + 1) + ".png");
            LOGGER.debug("Registered texture: zeromod:textures/gui/overlay{}", (Object)(i + 1));
        }
    }
}

