/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.LinkedBlockingDeque;
import net.com.zeromod.network.ModNetwork;
import net.com.zeromod.network.OverlayPacket;
import net.com.zeromod.sound.ModSounds;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReZeroData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReZeroData.class);
    private static final int HISTORY_SIZE = 80;
    private static final int EFFECT_DURATION = 100;
    private static final int POSITION_SAVE_INTERVAL = 10;
    private static final Map<UUID, Integer> cooldownMap = new HashMap<UUID, Integer>();
    private static final Map<UUID, LinkedBlockingDeque<Vec3>> positionHistory = new HashMap<UUID, LinkedBlockingDeque<Vec3>>();
    public static final Map<UUID, Boolean> overlayStates = new HashMap<UUID, Boolean>();
    private static final Map<UUID, Integer> overlayTimers = new HashMap<UUID, Integer>();
    private static final Map<UUID, Float> savedHealthMap = new HashMap<UUID, Float>();
    private static final Map<UUID, Integer> positionTickCounter = new HashMap<UUID, Integer>();

    public static int getCooldown(UUID uuid) {
        return cooldownMap.getOrDefault(uuid, 0);
    }

    public static void setCooldown(UUID uuid, int ticks) {
        cooldownMap.put(uuid, ticks);
    }

    public static void tickCooldown(UUID uuid) {
        cooldownMap.computeIfPresent(uuid, (u, t) -> t > 0 ? Integer.valueOf(t - 1) : null);
    }

    public static boolean isOnCooldown(UUID uuid) {
        return cooldownMap.getOrDefault(uuid, 0) > 0;
    }

    public static void savePosition(ServerPlayer player) {
        UUID uuid = player.m_20148_();
        int tickCount = positionTickCounter.getOrDefault(uuid, 0);
        if (++tickCount >= 10) {
            positionHistory.computeIfAbsent(uuid, k -> new LinkedBlockingDeque(80));
            LinkedBlockingDeque<Vec3> history = positionHistory.get(uuid);
            if (history.size() >= 80) {
                history.pollFirst();
            }
            history.addLast(player.m_20182_());
            tickCount = 0;
        }
        positionTickCounter.put(uuid, tickCount);
    }

    public static Vec3 getSavedPosition(UUID uuid) {
        LinkedBlockingDeque<Vec3> history = positionHistory.get(uuid);
        return history != null && !history.isEmpty() ? history.peekFirst() : null;
    }

    public static void triggerOverlay(ServerPlayer player) {
        UUID uuid = player.m_20148_();
        overlayStates.put(uuid, true);
        overlayTimers.put(uuid, 100);
        savedHealthMap.put(uuid, Float.valueOf(player.m_21223_()));
        player.m_9236_().m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.REWIND.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 100, 0, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 255, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 120, 0, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 4, false, false));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 100, 0, false, false));
        player.m_20282_(true);
        ModNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OverlayPacket(uuid, true));
    }

    public static void stopOverlay(ServerPlayer player) {
        UUID uuid = player.m_20148_();
        overlayStates.put(uuid, false);
        overlayTimers.remove(uuid);
        player.m_20282_(false);
        Float oldHealth = savedHealthMap.remove(uuid);
        if (oldHealth != null) {
            float healAmount = Math.max(oldHealth.floatValue(), player.m_21223_() + 8.0f);
            player.m_21153_(Math.min(healAmount, player.m_21233_()));
        }
        ModNetwork.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new OverlayPacket(uuid, false));
    }

    public static void tickOverlay(ServerPlayer player) {
        UUID uuid = player.m_20148_();
        if (overlayStates.getOrDefault(uuid, false).booleanValue()) {
            int time = overlayTimers.getOrDefault(uuid, 0);
            if (time > 0) {
                overlayTimers.put(uuid, time - 1);
            } else {
                ReZeroData.stopOverlay(player);
            }
        }
    }

    public static boolean isOverlayTriggered(Player player) {
        return overlayStates.getOrDefault(player.m_20148_(), false);
    }
}

