/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.event;

import net.com.zeromod.data.ReZeroData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod.EventBusSubscriber(modid="zeromod", value={Dist.CLIENT})
public class OverlayHandlerReZero {
    private static final Logger LOGGER = LoggerFactory.getLogger(OverlayHandlerReZero.class);
    private static final ResourceLocation[] FRAMES = new ResourceLocation[37];
    private static int frameTick = 0;
    private static final int TOTAL_TICKS = 100;
    private static final int TOTAL_FRAMES = 37;
    private static final float TICKS_PER_FRAME = 2.7027028f;

    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        boolean isTriggered;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && (isTriggered = ReZeroData.isOverlayTriggered((Player)player)) && frameTick < 100) {
            int frameIndex = (int)((float)frameTick / 2.7027028f);
            if (frameIndex >= 37) {
                frameIndex = 36;
            }
            GuiGraphics guiGraphics = event.getGuiGraphics();
            int width = mc.m_91268_().m_85445_();
            int height = mc.m_91268_().m_85446_();
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 0.7f);
            guiGraphics.m_280163_(FRAMES[frameIndex], 0, 0, 0.0f, 0.0f, width, height, width, height);
            guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.END && mc.f_91074_ != null) {
            if (ReZeroData.isOverlayTriggered((Player)mc.f_91074_)) {
                if (frameTick < 100) {
                    ++frameTick;
                }
            } else {
                frameTick = 0;
            }
        }
    }

    static {
        for (int i = 0; i < 37; ++i) {
            OverlayHandlerReZero.FRAMES[i] = new ResourceLocation("zeromod", "textures/gui/time" + (i + 1) + ".png");
        }
    }
}

