/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.event;

import java.util.UUID;
import net.com.zeromod.data.ReZeroData;
import net.com.zeromod.item.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class PlayerEventHandler {
    private static final int COOLDOWN_REZERO = 12000;
    private static final int COOLDOWN_ETERNAL = 4800;
    private static final int MAX_USES_REZERO = 4;
    private static final float MAX_HEALTH_AFTER_REZERO = 1.0f;

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.player;
        UUID uuid = player.m_20148_();
        if (ReZeroData.isOnCooldown(uuid)) {
            ReZeroData.tickCooldown(uuid);
        }
        ReZeroData.savePosition(player);
        ReZeroData.tickOverlay(player);
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        int usesRemaining;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        ItemStack stack = PlayerEventHandler.findReZeroStack(player);
        if (stack.m_41619_()) {
            return;
        }
        float resultHealth = player.m_21223_() - event.getAmount();
        if (resultHealth > 0.0f) {
            return;
        }
        UUID playerUuid = player.m_20148_();
        Item item = stack.m_41720_();
        if (ReZeroData.isOnCooldown(playerUuid)) {
            return;
        }
        CompoundTag tag = stack.m_41784_();
        int n = usesRemaining = tag.m_128441_("UsesRemaining") ? tag.m_128451_("UsesRemaining") : 4;
        if (item == ModItems.REZERO.get() && usesRemaining <= 0) {
            return;
        }
        Vec3 saved = ReZeroData.getSavedPosition(playerUuid);
        if (saved == null) {
            return;
        }
        event.setCanceled(true);
        player.m_6021_(saved.f_82479_, saved.f_82480_, saved.f_82481_);
        float currentHealth = player.m_21223_();
        if (currentHealth > 1.0f) {
            player.m_21153_(1.0f);
        }
        ReZeroData.triggerOverlay(player);
        if (item == ModItems.REZERO.get()) {
            tag.m_128405_("UsesRemaining", --usesRemaining);
            ReZeroData.setCooldown(playerUuid, 12000);
            if (usesRemaining <= 0) {
                stack.m_41774_(1);
                player.m_150109_().m_6596_();
            }
        } else if (item == ModItems.REZERO_ETERNAL.get()) {
            ReZeroData.setCooldown(playerUuid, 4800);
        }
    }

    private static ItemStack findReZeroStack(ServerPlayer player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item item = stack.m_41720_();
            if (item != ModItems.REZERO.get() && item != ModItems.REZERO_ETERNAL.get()) continue;
            CompoundTag tag = stack.m_41784_();
            if (!tag.m_128441_("UsesRemaining") && item == ModItems.REZERO.get()) {
                tag.m_128405_("UsesRemaining", 4);
            }
            return stack;
        }
        return ItemStack.f_41583_;
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        if (player == null || stack.m_41619_()) {
            return;
        }
        if (stack.m_41720_() == ModItems.REZERO.get() && player.m_21205_() == stack) {
            CompoundTag tag = stack.m_41784_();
            int usesRemaining = tag.m_128441_("UsesRemaining") ? tag.m_128451_("UsesRemaining") : 4;
            event.getToolTip().add(Component.m_237113_((String)("Uses Remaining: " + usesRemaining)));
        }
    }
}

