/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.com.zeromod.item.ModItems;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
class TimeDisperserHandler {
    private static final Map<UUID, Integer> deathCountdownMap = new HashMap<UUID, Integer>();
    private static final int COUNTDOWN_TICKS = 200;

    TimeDisperserHandler() {
    }

    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        UUID id;
        float currentHealth;
        Player player;
        block7: {
            block6: {
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block6;
                player = (Player)livingEntity;
                if (!player.m_9236_().f_46443_) break block7;
            }
            return;
        }
        boolean hasTimeDisperser = false;
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (stack.m_41720_() != ModItems.TIME_DISPERSER.get()) continue;
            hasTimeDisperser = true;
            break;
        }
        if (!hasTimeDisperser) {
            return;
        }
        float damage = event.getAmount();
        if (damage >= (currentHealth = player.m_21223_()) && !deathCountdownMap.containsKey(id = player.m_20148_())) {
            event.setAmount(0.0f);
            player.m_21153_(1.0f);
            FoodData foodData = player.m_36324_();
            foodData.m_38705_(0);
            deathCountdownMap.put(id, 200);
            player.m_5661_((Component)Component.m_237113_((String)"Death is coming to you slowly"), true);
        }
    }

    public static void onPlayerTick(Player player) {
        if (player.m_9236_().f_46443_ || !player.m_6084_()) {
            return;
        }
        UUID id = player.m_20148_();
        if (!deathCountdownMap.containsKey(id)) {
            return;
        }
        int remainingTicks = deathCountdownMap.get(id);
        int secondsLeft = (remainingTicks + 19) / 20;
        player.m_5661_((Component)Component.m_237113_((String)("The Reaper swings in " + secondsLeft + " and you're the target----(Eat to survive!)")), true);
        FoodData foodData = player.m_36324_();
        if (foodData.m_38702_() >= 20) {
            deathCountdownMap.remove(id);
            player.m_5661_((Component)Component.m_237113_((String)"You escaped death!"), true);
            System.out.println("You survived!");
            player.m_21195_(MobEffects.f_216964_);
            player.m_21195_(MobEffects.f_19597_);
            player.m_21195_(MobEffects.f_19606_);
            return;
        }
        if (remainingTicks == 200) {
            player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 240, 3, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 220, 5, false, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 220, 2, false, false));
        }
        if (remainingTicks % 20 == 0 && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(Holder.m_205709_((Object)SoundEvents.f_215762_), SoundSource.PLAYERS, player.m_20185_(), player.m_20186_(), player.m_20189_(), 1.0f, 1.0f, player.m_9236_().f_46441_.m_188505_()));
        }
        if (--remainingTicks <= 0) {
            player.m_6469_(player.m_269291_().m_269264_(), Float.MAX_VALUE);
            deathCountdownMap.remove(id);
            System.out.println("Death is always with you!");
            player.m_21195_(MobEffects.f_216964_);
            player.m_21195_(MobEffects.f_19597_);
            player.m_21195_(MobEffects.f_19606_);
        } else {
            deathCountdownMap.put(id, remainingTicks);
        }
    }
}

