/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.item;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.event.RenderGuiEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="zeromod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CursedHeart
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final UUID HEALTH_MODIFIER_UUID = UUID.fromString("b7a8e3c1-4f2d-4b9a-9c5e-7d8f6a2b3c4d");
    private static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("c9d7f4a2-5e3c-4c8b-a7d6-8e9f5b3c4d5e");
    private static final String TAG_ACTIVATED = "Activated";
    private static final String TAG_CONFIRM_CLICK = "ConfirmClick";
    private static final String TAG_LEVEL = "Level";
    private static final String TAG_MOB_KILLS = "MobKills";
    private static final String TAG_HEALTH_UPGRADES = "HealthUpgrades";
    private static final String TAG_DAMAGE_UPGRADES = "DamageUpgrades";
    private static final String TAG_TRANSITION_TICKS = "TransitionTicks";
    private static final String PLAYER_USED_TAG = "zeromod:cursed_heart_used";
    private static final String CURSED_HEART_DATA = "zeromod:cursed_heart_data";
    private static final Path DATA_DIR = Paths.get("config/zeromod/cursed_heart", new String[0]);
    private static final Map<UUID, CursedHeartData> PLAYER_DATA_CACHE = new ConcurrentHashMap<UUID, CursedHeartData>();
    private static final int LEVEL_1_HEALTH_MOB_KILLS = 20;
    private static final int LEVEL_2_HEALTH_MOB_KILLS = 40;
    private static final int LEVEL_3_HEALTH_MOB_KILLS = 60;
    private static final int LEVEL_4_HEALTH_MOB_KILLS = 80;
    private static final int LEVEL_5_HEALTH_MOB_KILLS = 100;
    private static final int LEVEL_1_DAMAGE_MOB_KILLS = 40;
    private static final int LEVEL_2_DAMAGE_MOB_KILLS = 60;
    private static final int LEVEL_3_DAMAGE_MOB_KILLS = 80;
    private static final int LEVEL_4_DAMAGE_MOB_KILLS = 150;
    private static final int LEVEL_1_TO_2_HEALTH_UPGRADES = 40;
    private static final int LEVEL_1_TO_2_DAMAGE_UPGRADES = 5;
    private static final int LEVEL_2_TO_3_HEALTH_UPGRADES = 60;
    private static final int LEVEL_2_TO_3_DAMAGE_UPGRADES = 7;
    private static final int LEVEL_3_TO_4_HEALTH_UPGRADES = 100;
    private static final int LEVEL_3_TO_4_DAMAGE_UPGRADES = 10;
    private static final int LEVEL_4_TO_5_HEALTH_UPGRADES = 150;
    private static final int LEVEL_4_TO_5_DAMAGE_UPGRADES = 15;
    private static final float BASE_TRUE_DAMAGE = 0.5f;
    private static final float LEVEL_1_TRUE_DAMAGE = 0.25f;
    private static final float LEVEL_2_TRUE_DAMAGE = 0.25f;
    private static final float LEVEL_3_TRUE_DAMAGE = 0.25f;
    private static final float LEVEL_4_TRUE_DAMAGE = 0.5f;
    private static final float LEVEL_5_TRUE_DAMAGE = 0.75f;
    private static final float LEVEL_5_TRUE_DAMAGE_UPGRADE = 1.0f;
    private static final float LEVEL_5_EXTRA_DAMAGE_PERCENT = 0.05f;
    private static final float LEVEL_4_HEAL_PERCENT = 0.1f;
    private static final float LEVEL_5_HEAL_PERCENT = 0.15f;
    private static final double BASE_HEALTH_REDUCTION = -16.0;
    private static final double HEALTH_UPGRADE_LOW = 1.0;
    private static final double HEALTH_UPGRADE_HIGH = 2.0;
    private static final int TRANSITION_TICKS = 20;
    private static final int MESSAGE_DISPLAY_TICKS = 60;
    private static Component lastMessage = null;
    private static int displayTicks = 0;

    public CursedHeart(Item.Properties properties) {
        super(properties.m_41487_(1));
        try {
            Files.createDirectories(DATA_DIR, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create CursedHeart data directory", (Throwable)e);
        }
    }

    private static Path getPlayerDataPath(Player player) {
        return DATA_DIR.resolve(player.m_20148_().toString() + ".json");
    }

    private static void savePlayerData(Player player, CursedHeartData data) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        Path path = CursedHeart.getPlayerDataPath(player);
        try (FileWriter writer = new FileWriter(path.toFile());){
            gson.toJson((Object)data, (Appendable)writer);
            PLAYER_DATA_CACHE.put(player.m_20148_(), data);
            LOGGER.debug("Saved CursedHeart data for {}: {}", (Object)player.m_7755_().getString(), (Object)data);
        }
        catch (IOException e) {
            LOGGER.error("Failed to save CursedHeart data for {}", (Object)player.m_7755_().getString(), (Object)e);
        }
    }

    private static CursedHeartData loadPlayerData(Player player) {
        UUID playerUUID = player.m_20148_();
        if (PLAYER_DATA_CACHE.containsKey(playerUUID)) {
            return PLAYER_DATA_CACHE.get(playerUUID);
        }
        Gson gson = new Gson();
        Path path = CursedHeart.getPlayerDataPath(player);
        if (Files.exists(path, new LinkOption[0])) {
            CursedHeartData cursedHeartData;
            FileReader reader = new FileReader(path.toFile());
            try {
                CursedHeartData data = (CursedHeartData)gson.fromJson((Reader)reader, CursedHeartData.class);
                PLAYER_DATA_CACHE.put(playerUUID, data);
                LOGGER.debug("Loaded CursedHeart data for {}: {}", (Object)player.m_7755_().getString(), (Object)data);
                cursedHeartData = data;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to load CursedHeart data for {}", (Object)player.m_7755_().getString(), (Object)e);
                }
            }
            ((Reader)reader).close();
            return cursedHeartData;
        }
        CursedHeartData data = new CursedHeartData();
        PLAYER_DATA_CACHE.put(playerUUID, data);
        return data;
    }

    private static CompoundTag dataToTag(CursedHeartData data) {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_(TAG_ACTIVATED, data.activated);
        tag.m_128405_(TAG_LEVEL, data.level);
        tag.m_128405_(TAG_MOB_KILLS, data.mobKills);
        tag.m_128405_(TAG_HEALTH_UPGRADES, data.healthUpgrades);
        tag.m_128405_(TAG_DAMAGE_UPGRADES, data.damageUpgrades);
        tag.m_128405_(TAG_TRANSITION_TICKS, data.transitionTicks);
        return tag;
    }

    private static CursedHeartData tagToData(CompoundTag tag) {
        CursedHeartData data = new CursedHeartData();
        data.activated = tag.m_128471_(TAG_ACTIVATED);
        data.level = tag.m_128451_(TAG_LEVEL);
        data.mobKills = tag.m_128451_(TAG_MOB_KILLS);
        data.healthUpgrades = tag.m_128451_(TAG_HEALTH_UPGRADES);
        data.damageUpgrades = tag.m_128451_(TAG_DAMAGE_UPGRADES);
        data.transitionTicks = tag.m_128451_(TAG_TRANSITION_TICKS);
        return data;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            CompoundTag playerData = player.getPersistentData();
            if (playerData.m_128471_(PLAYER_USED_TAG)) {
                player.m_213846_((Component)Component.m_237113_((String)"You have already used a Cursed Heart!"));
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            CompoundTag tag = stack.m_41784_();
            boolean confirmClick = tag.m_128471_(TAG_CONFIRM_CLICK);
            if (!confirmClick) {
                tag.m_128379_(TAG_CONFIRM_CLICK, true);
                player.m_213846_((Component)Component.m_237113_((String)"Are you sure you want to activate the Cursed Heart? Right-click again to confirm."));
                LOGGER.info("CursedHeart confirmation requested by {}", (Object)player.m_7755_().getString());
                return InteractionResultHolder.m_19090_((Object)stack);
            }
            CursedHeartData data = new CursedHeartData();
            data.activated = true;
            data.level = 1;
            data.mobKills = 0;
            data.healthUpgrades = 0;
            data.damageUpgrades = 0;
            tag = CursedHeart.dataToTag(data);
            playerData.m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
            CursedHeart.savePlayerData(player, data);
            CursedHeart.applyLevelEffects(player, data.level, tag);
            playerData.m_128379_(PLAYER_USED_TAG, true);
            player.m_213846_((Component)Component.m_237113_((String)"Cursed Heart Level 1 activated!"));
            LOGGER.info("CursedHeart activated by {} at Level 1", (Object)player.m_7755_().getString());
            stack.m_41774_(1);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public boolean onDroppedByPlayer(ItemStack stack, Player player) {
        return true;
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        Entity entity = event.getSource().m_7639_();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.getPersistentData().m_128471_(PLAYER_USED_TAG)) {
            return;
        }
        CompoundTag tag = CursedHeart.getPlayerCursedHeartData(player);
        if (tag == null || !tag.m_128471_(TAG_ACTIVATED)) {
            return;
        }
        int level = tag.m_128451_(TAG_LEVEL);
        LivingEntity target = event.getEntity();
        float trueDamage = CursedHeart.getTrueDamage(level, tag.m_128451_(TAG_DAMAGE_UPGRADES));
        target.m_6469_(target.m_9236_().m_269111_().m_269425_(), trueDamage);
        if (level == 5) {
            float extraDamage = target.m_21233_() * 0.05f;
            target.m_6469_(target.m_9236_().m_269111_().m_269425_(), extraDamage);
            trueDamage += extraDamage;
        }
        if (level >= 4) {
            float healPercent = level == 4 ? 0.1f : 0.15f;
            float healAmount = trueDamage * healPercent;
            player.m_5634_(healAmount);
            LOGGER.debug("Player {} healed {} from true damage", (Object)player.m_7755_().getString(), (Object)Float.valueOf(healAmount));
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Entity entity;
        LivingEntity entity2 = event.getEntity();
        if (!(entity2 instanceof Player) && (entity = event.getSource().m_7639_()) instanceof Player) {
            Player player = (Player)entity;
            if (!player.getPersistentData().m_128471_(PLAYER_USED_TAG)) {
                return;
            }
            CursedHeartData data = CursedHeart.loadPlayerData(player);
            if (!data.activated) {
                return;
            }
            ++data.mobKills;
            CompoundTag tag = CursedHeart.dataToTag(data);
            player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Mob killed by {}: Total kills {}", (Object)player.m_7755_().getString(), (Object)data.mobKills);
            CursedHeart.displayStats(player, tag);
            switch (data.level) {
                case 1: {
                    CursedHeart.handleLevel1(player, data);
                    break;
                }
                case 2: {
                    CursedHeart.handleLevel2(player, data);
                    break;
                }
                case 3: {
                    CursedHeart.handleLevel3(player, data);
                    break;
                }
                case 4: {
                    CursedHeart.handleLevel4(player, data);
                    break;
                }
                case 5: {
                    CursedHeart.handleLevelMax(player, data);
                }
            }
        }
    }

    private static void displayStats(Player player, CompoundTag tag) {
        int level = tag.m_128451_(TAG_LEVEL);
        int mobKills = tag.m_128451_(TAG_MOB_KILLS);
        int healthUpgrades = tag.m_128451_(TAG_HEALTH_UPGRADES);
        int damageUpgrades = tag.m_128451_(TAG_DAMAGE_UPGRADES);
        double healthHearts = (double)healthUpgrades * (level <= 3 ? 1.0 : 2.0) / 2.0;
        LOGGER.debug("Displaying stats - Level: {}, Kills: {}, Health Upgrades: {}, Damage Upgrades: {}, Health Hearts: {}", (Object)level, (Object)mobKills, (Object)healthUpgrades, (Object)damageUpgrades, (Object)healthHearts);
        MutableComponent message = Component.m_237113_((String)("\u00a7cCursed Heart Lv." + level + "   \u00a77Kills: \u00a7f" + mobKills + "   \u00a77HP Bonus: \u00a7a+" + String.format("%.1f", healthHearts) + "\u2764   \u00a77DMG Bonus: \u00a7c+" + CursedHeart.getTrueDamage(level, damageUpgrades)));
        player.m_5661_((Component)message, true);
        lastMessage = message;
        displayTicks = 60;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        for (Player player : event.getServer().m_6846_().m_11314_()) {
            int transitionTicks;
            CompoundTag tag;
            if (!player.getPersistentData().m_128471_(PLAYER_USED_TAG) || (tag = CursedHeart.getPlayerCursedHeartData(player)) == null || !tag.m_128471_(TAG_ACTIVATED)) continue;
            if (displayTicks > 0 && --displayTicks == 0 && lastMessage != null) {
                player.m_5661_((Component)Component.m_237119_(), true);
                lastMessage = null;
            }
            if ((transitionTicks = tag.m_128451_(TAG_TRANSITION_TICKS)) > 0) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 20, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 20, 1, false, false));
                CursedHeartData data = CursedHeart.tagToData(tag);
                data.transitionTicks = transitionTicks - 1;
                tag = CursedHeart.dataToTag(data);
                player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
                CursedHeart.savePlayerData(player, data);
            }
            if (!CursedHeart.shouldPlayerBurn(player)) continue;
        }
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || !player.getPersistentData().m_128471_(PLAYER_USED_TAG)) {
            return;
        }
        CompoundTag tag = CursedHeart.getPlayerCursedHeartData((Player)player);
        if (tag == null || !tag.m_128471_(TAG_ACTIVATED)) {
            return;
        }
        int level = tag.m_128451_(TAG_LEVEL);
        int mobKills = tag.m_128451_(TAG_MOB_KILLS);
        int healthUpgrades = tag.m_128451_(TAG_HEALTH_UPGRADES);
        int damageUpgrades = tag.m_128451_(TAG_DAMAGE_UPGRADES);
        double healthHearts = (double)healthUpgrades * (level <= 3 ? 1.0 : 2.0) / 2.0;
        LOGGER.debug("Rendering GUI - Level: {}, Kills: {}, Health Upgrades: {}, Damage Upgrades: {}, Health Hearts: {}", (Object)level, (Object)mobKills, (Object)healthUpgrades, (Object)damageUpgrades, (Object)healthHearts);
        GuiGraphics guiGraphics = event.getGuiGraphics();
        Font font = minecraft.f_91062_;
        int y = 10;
        guiGraphics.m_280488_(font, "Cursed Heart Level: " + level, 10, y, 0xFFFFFF);
        guiGraphics.m_280488_(font, "Mob Kills: " + mobKills, 10, y += 10, 0xFFFFFF);
        guiGraphics.m_280488_(font, "Health Added: " + String.format("%.1f", healthHearts) + " hearts", 10, y += 10, 0xFFFFFF);
        guiGraphics.m_280488_(font, "Damage Upgrades: " + damageUpgrades, 10, y += 10, 0xFFFFFF);
    }

    private static boolean shouldPlayerBurn(Player player) {
        CompoundTag tag = CursedHeart.getPlayerCursedHeartData(player);
        if (tag == null || !tag.m_128471_(TAG_ACTIVATED)) {
            return false;
        }
        int level = tag.m_128451_(TAG_LEVEL);
        if (level >= 5) {
            return false;
        }
        Level levelWorld = player.m_9236_();
        BlockPos pos = player.m_20183_();
        if (player.m_20069_()) {
            return false;
        }
        if (!((ItemStack)player.m_150109_().f_35975_.get(3)).m_41619_()) {
            return false;
        }
        if (!levelWorld.m_45527_(pos)) {
            return false;
        }
        if (!levelWorld.m_46461_()) {
            return false;
        }
        player.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 20, 0, false, false));
        player.m_6469_(player.m_9236_().m_269111_().m_269251_(), 1.0f);
        return true;
    }

    private static void handleLevel1(Player player, CursedHeartData data) {
        if (data.mobKills >= (data.healthUpgrades + 1) * 20) {
            ++data.healthUpgrades;
            CursedHeart.updateHealth(player, data.healthUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Health Upgrades increased to {} for {}", (Object)data.healthUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.mobKills >= (data.damageUpgrades + 1) * 40) {
            ++data.damageUpgrades;
            CursedHeart.updateDamage(player, data.damageUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Damage Upgrades increased to {} for {}", (Object)data.damageUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.healthUpgrades >= 40 && data.damageUpgrades >= 5) {
            data.level = 2;
            data.healthUpgrades = 0;
            data.damageUpgrades = 0;
            data.transitionTicks = 20;
            CompoundTag tag = CursedHeart.dataToTag(data);
            CursedHeart.applyLevelEffects(player, data.level, tag);
            player.m_213846_((Component)Component.m_237113_((String)"Cursed Heart upgraded to Level 2!"));
            LOGGER.info("CursedHeart upgraded to Level 2 for {}", (Object)player.m_7755_().getString());
            player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
            CursedHeart.savePlayerData(player, data);
        }
    }

    private static void handleLevel2(Player player, CursedHeartData data) {
        if (data.mobKills >= (data.healthUpgrades + 1) * 40) {
            ++data.healthUpgrades;
            CursedHeart.updateHealth(player, data.healthUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Health Upgrades increased to {} for {}", (Object)data.healthUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.mobKills >= (data.damageUpgrades + 1) * 60) {
            ++data.damageUpgrades;
            CursedHeart.updateDamage(player, data.damageUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Damage Upgrades increased to {} for {}", (Object)data.damageUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.healthUpgrades >= 60 && data.damageUpgrades >= 7) {
            data.level = 3;
            data.healthUpgrades = 0;
            data.damageUpgrades = 0;
            data.transitionTicks = 20;
            CompoundTag tag = CursedHeart.dataToTag(data);
            CursedHeart.applyLevelEffects(player, data.level, tag);
            player.m_213846_((Component)Component.m_237113_((String)"Cursed Heart upgraded to Level 3!"));
            LOGGER.info("CursedHeart upgraded to Level 3 for {}", (Object)player.m_7755_().getString());
            player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
            CursedHeart.savePlayerData(player, data);
        }
    }

    private static void handleLevel3(Player player, CursedHeartData data) {
        if (data.mobKills >= (data.healthUpgrades + 1) * 60) {
            ++data.healthUpgrades;
            CursedHeart.updateHealth(player, data.healthUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Health Upgrades increased to {} for {}", (Object)data.healthUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.mobKills >= (data.damageUpgrades + 1) * 80) {
            ++data.damageUpgrades;
            CursedHeart.updateDamage(player, data.damageUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Damage Upgrades increased to {} for {}", (Object)data.damageUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.healthUpgrades >= 100 && data.damageUpgrades >= 10) {
            data.level = 4;
            data.healthUpgrades = 0;
            data.damageUpgrades = 0;
            data.transitionTicks = 20;
            CompoundTag tag = CursedHeart.dataToTag(data);
            CursedHeart.applyLevelEffects(player, data.level, tag);
            player.m_213846_((Component)Component.m_237113_((String)"Cursed Heart upgraded to Level 4!"));
            LOGGER.info("CursedHeart upgraded to Level 4 for {}", (Object)player.m_7755_().getString());
            player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
            CursedHeart.savePlayerData(player, data);
        }
    }

    private static void handleLevel4(Player player, CursedHeartData data) {
        if (data.mobKills >= (data.healthUpgrades + 1) * 80) {
            ++data.healthUpgrades;
            CursedHeart.updateHealth(player, data.healthUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Health Upgrades increased to {} for {}", (Object)data.healthUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.mobKills >= (data.damageUpgrades + 1) * 150) {
            ++data.damageUpgrades;
            CursedHeart.updateDamage(player, data.damageUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Damage Upgrades increased to {} for {}", (Object)data.damageUpgrades, (Object)player.m_7755_().getString());
        }
        if (data.healthUpgrades >= 150 && data.damageUpgrades >= 15) {
            data.level = 5;
            data.healthUpgrades = 0;
            data.damageUpgrades = 0;
            data.transitionTicks = 20;
            CompoundTag tag = CursedHeart.dataToTag(data);
            CursedHeart.applyLevelEffects(player, data.level, tag);
            player.m_213846_((Component)Component.m_237113_((String)"Cursed Heart reached Max Level!"));
            LOGGER.info("CursedHeart reached Max Level for {}", (Object)player.m_7755_().getString());
            player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
            CursedHeart.savePlayerData(player, data);
        }
    }

    private static void handleLevelMax(Player player, CursedHeartData data) {
        if (data.mobKills >= (data.healthUpgrades + 1) * 100) {
            ++data.healthUpgrades;
            ++data.damageUpgrades;
            CursedHeart.updateHealth(player, data.healthUpgrades, data.level);
            CursedHeart.updateDamage(player, data.damageUpgrades, data.level);
            CursedHeart.savePlayerData(player, data);
            LOGGER.debug("Max Level - Health Upgrades: {}, Damage Upgrades: {} for {}", (Object)data.healthUpgrades, (Object)data.damageUpgrades, (Object)player.m_7755_().getString());
        }
    }

    private static void applyLevelEffects(Player player, int level, ItemStack stack) {
        CursedHeart.applyLevelEffects(player, level, stack.m_41784_());
    }

    private static void applyLevelEffects(Player player, int level, CompoundTag tag) {
        player.m_21219_();
        AttributeInstance healthAttribute = player.m_21051_(Attributes.f_22276_);
        AttributeInstance damageAttribute = player.m_21051_(Attributes.f_22281_);
        if (healthAttribute != null) {
            healthAttribute.m_22120_(HEALTH_MODIFIER_UUID);
        }
        if (damageAttribute != null) {
            damageAttribute.m_22120_(DAMAGE_MODIFIER_UUID);
        }
        if (healthAttribute != null) {
            healthAttribute.m_22125_(new AttributeModifier(HEALTH_MODIFIER_UUID, "CursedHeartHealth", -16.0, AttributeModifier.Operation.ADDITION));
            player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
        }
        if (damageAttribute != null) {
            damageAttribute.m_22125_(new AttributeModifier(DAMAGE_MODIFIER_UUID, "CursedHeartDamage", 0.5, AttributeModifier.Operation.ADDITION));
        }
        switch (level) {
            case 1: {
                break;
            }
            case 2: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 0, false, false));
                break;
            }
            case 3: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, -1, 0, false, false));
                break;
            }
            case 4: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, -1, 0, false, false));
                break;
            }
            case 5: {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, -1, 0, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, -1, 2, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, -1, 2, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, -1, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, -1, 1, false, false));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19603_, -1, 1, false, false));
            }
        }
        int healthUpgrades = tag.m_128451_(TAG_HEALTH_UPGRADES);
        int damageUpgrades = tag.m_128451_(TAG_DAMAGE_UPGRADES);
        CursedHeart.updateHealth(player, healthUpgrades, level);
        CursedHeart.updateDamage(player, damageUpgrades, level);
        player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
    }

    private static void updateHealth(Player player, int healthUpgrades, int level) {
        AttributeInstance healthAttribute = player.m_21051_(Attributes.f_22276_);
        if (healthAttribute != null) {
            healthAttribute.m_22120_(HEALTH_MODIFIER_UUID);
            double healthModifier = -16.0 + (double)healthUpgrades * (level <= 3 ? 1.0 : 2.0);
            healthAttribute.m_22125_(new AttributeModifier(HEALTH_MODIFIER_UUID, "CursedHeartHealth", healthModifier, AttributeModifier.Operation.ADDITION));
            player.m_21153_(Math.min(player.m_21223_(), player.m_21233_()));
            LOGGER.debug("Updated health for player {}: Upgrades {}, Modifier {}, Max Health {}", (Object)player.m_7755_().getString(), (Object)healthUpgrades, (Object)healthModifier, (Object)Float.valueOf(player.m_21233_()));
        }
    }

    private static void updateDamage(Player player, int damageUpgrades, int level) {
        AttributeInstance damageAttribute = player.m_21051_(Attributes.f_22281_);
        if (damageAttribute != null) {
            damageAttribute.m_22120_(DAMAGE_MODIFIER_UUID);
            double damageModifier = CursedHeart.getTrueDamage(level, damageUpgrades);
            damageAttribute.m_22125_(new AttributeModifier(DAMAGE_MODIFIER_UUID, "CursedHeartDamage", damageModifier, AttributeModifier.Operation.ADDITION));
            LOGGER.debug("Updated damage for player {}: Upgrades {}, Modifier {}", (Object)player.m_7755_().getString(), (Object)damageUpgrades, (Object)damageModifier);
        }
    }

    private static float getTrueDamage(int level, int damageUpgrades) {
        return switch (level) {
            case 1 -> 0.5f + (float)damageUpgrades * 0.25f;
            case 2 -> 0.25f + (float)damageUpgrades * 0.25f;
            case 3 -> 0.25f + (float)damageUpgrades * 0.25f;
            case 4 -> 0.5f + (float)damageUpgrades * 0.25f;
            case 5 -> 0.75f + (float)damageUpgrades * 1.0f;
            default -> 0.5f;
        };
    }

    private static CompoundTag getPlayerCursedHeartData(Player player) {
        CursedHeartData data = CursedHeart.loadPlayerData(player);
        return CursedHeart.dataToTag(data);
    }

    @SubscribeEvent
    public static void onPlayerFallDamage(LivingHurtEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (event.getSource() == player.m_9236_().m_269111_().m_268989_()) {
                int level;
                if (!player.getPersistentData().m_128471_(PLAYER_USED_TAG)) {
                    return;
                }
                CompoundTag tag = CursedHeart.getPlayerCursedHeartData(player);
                if (tag != null && tag.m_128471_(TAG_ACTIVATED) && (level = tag.m_128451_(TAG_LEVEL)) >= 4) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player.getPersistentData().m_128471_(PLAYER_USED_TAG)) {
            CursedHeartData data = CursedHeart.loadPlayerData(player);
            if (data.activated) {
                CompoundTag tag = CursedHeart.dataToTag(data);
                player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
                LOGGER.debug("Applying effects on join for {}: Level {}, Health Upgrades {}, Damage Upgrades {}, Mob Kills {}", (Object)player.m_7755_().getString(), (Object)data.level, (Object)data.healthUpgrades, (Object)data.damageUpgrades, (Object)data.mobKills);
                CursedHeart.applyLevelEffects(player, data.level, tag);
            } else {
                LOGGER.warn("No valid CursedHeart data found for player {} despite PLAYER_USED_TAG being true", (Object)player.m_7755_().getString());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (player.getPersistentData().m_128471_(PLAYER_USED_TAG)) {
            CursedHeartData data = CursedHeart.loadPlayerData(player);
            if (data.activated) {
                CompoundTag tag = CursedHeart.dataToTag(data);
                player.getPersistentData().m_128365_(CURSED_HEART_DATA, (Tag)tag.m_6426_());
                LOGGER.debug("Applying effects on respawn for {}: Level {}, Health Upgrades {}, Damage Upgrades {}, Mob Kills {}", (Object)player.m_7755_().getString(), (Object)data.level, (Object)data.healthUpgrades, (Object)data.damageUpgrades, (Object)data.mobKills);
                CursedHeart.applyLevelEffects(player, data.level, tag);
            } else {
                LOGGER.warn("No valid CursedHeart data found for player {} on respawn", (Object)player.m_7755_().getString());
            }
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.zeromod.cursed_heart.tooltip").m_130938_(style -> style.m_178520_(2003199)));
    }

    public static class CursedHeartData {
        public boolean activated = false;
        public int level = 1;
        public int mobKills = 0;
        public int healthUpgrades = 0;
        public int damageUpgrades = 0;
        public int transitionTicks = 0;
    }
}

