/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.item;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.com.zeromod.network.SwapPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="zeromod", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EyeofChronos
extends Item {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<UUID, PlayerData> playerDataMap = new HashMap<UUID, PlayerData>();
    private static final Set<UUID> processedProjectiles = new HashSet<UUID>();
    private static final int MAX_DURABILITY = 100;
    private static final long COOLDOWN_TICKS = 12000L;
    private static final long EFFECT_DURATION = 1200L;
    private static final double DETECTION_RANGE = 6.0;
    private static final double PROJECTILE_HITBOX_SIZE = 4.0;
    private static final double MOB_HITBOX_SIZE = 1.75;
    private static final int SCAN_FREQUENCY_TICKS = 5;
    private static final double TELEPORT_BOX_XZ = 5.0;
    private static final double TELEPORT_BOX_Y_UP = 5.0;
    private static final double TELEPORT_BOX_Y_DOWN = 2.0;
    private static final double FALLBACK_DISTANCE = 5.0;

    public EyeofChronos(Item.Properties properties) {
        super(properties.m_41503_(100));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!level.m_5776_()) {
            UUID playerUUID = player.m_20148_();
            PlayerData data = playerDataMap.computeIfAbsent(playerUUID, k -> new PlayerData());
            if (data.isOnCooldown(level.m_46467_())) {
                long ticksRemaining = data.cooldownEnd - level.m_46467_();
                int secondsRemaining = (int)(ticksRemaining / 20L);
                player.m_5661_((Component)Component.m_237113_((String)("Item on cooldown for " + secondsRemaining + " seconds!")), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            if (data.isActive) {
                long ticksRemaining = data.effectEndTime - level.m_46467_();
                int secondsRemaining = (int)(ticksRemaining / 20L);
                player.m_5661_((Component)Component.m_237113_((String)("Item already active for " + secondsRemaining + " seconds!")), true);
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            SwapPacket.sendToClient((ServerPlayer)player, true);
            data.activate(level.m_46467_());
            player.m_5661_((Component)Component.m_237113_((String)"Dodge activated for 60 seconds!"), true);
            LOGGER.info("DodgeItem activated by {}", (Object)player.m_7755_().getString());
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_()) {
            return;
        }
        UUID playerUUID = player.m_20148_();
        PlayerData data = playerDataMap.get(playerUUID);
        if (data == null || !data.isActive) {
            return;
        }
        ItemStack stack = EyeofChronos.findSiuuDodgeItem(player);
        if (stack.m_41619_()) {
            return;
        }
        LOGGER.info("LivingAttackEvent triggered for {} from {}", (Object)player.m_7755_().getString(), (Object)event.getSource().m_7639_());
        if (event.getSource().m_7640_() instanceof Projectile) {
            event.setCanceled(true);
            LOGGER.info("Cancelled projectile attack for {} from {}", (Object)player.m_7755_().getString(), (Object)event.getSource().m_7639_());
        }
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel level = event.getServer().m_129783_();
        long currentTime = level.m_46467_();
        if (currentTime % 5L != 0L) {
            return;
        }
        playerDataMap.entrySet().removeIf(entry -> {
            long ticksRemaining;
            UUID playerUUID = (UUID)entry.getKey();
            PlayerData data = (PlayerData)entry.getValue();
            Player player = level.m_46003_(playerUUID);
            if (player == null) {
                return true;
            }
            if (data.isActive && currentTime >= data.effectEndTime) {
                data.deactivate();
                player.m_5661_((Component)Component.m_237113_((String)"Dodge effect has expired"), true);
                SwapPacket.sendToClient((ServerPlayer)player, false);
                LOGGER.info("Dodge effect expired for {}", (Object)player.m_7755_().getString());
                return false;
            }
            if (data.isActive && currentTime % 20L == 0L && (ticksRemaining = data.effectEndTime - currentTime) > 0L) {
                int secondsRemaining = (int)(ticksRemaining / 20L);
                player.m_5661_((Component)Component.m_237113_((String)("Dodge expires in " + secondsRemaining + " seconds")), true);
            }
            if (data.isActive) {
                ItemStack stack = EyeofChronos.findSiuuDodgeItem(player);
                if (stack.m_41619_()) {
                    return false;
                }
                AABB projectileHitbox = new AABB(player.m_20182_().f_82479_ - 4.0, player.m_20182_().f_82480_ - 4.0, player.m_20182_().f_82481_ - 4.0, player.m_20182_().f_82479_ + 4.0, player.m_20182_().f_82480_ + 4.0, player.m_20182_().f_82481_ + 4.0);
                AABB mobHitbox = new AABB(player.m_20182_().f_82479_ - 1.75, player.m_20182_().f_82480_ - 1.75, player.m_20182_().f_82481_ - 1.75, player.m_20182_().f_82479_ + 1.75, player.m_20182_().f_82480_ + 1.75, player.m_20182_().f_82481_ + 1.75);
                AABB detectionBox = new AABB(player.m_20182_().m_82492_(6.0, 6.0, 6.0), player.m_20182_().m_82520_(6.0, 6.0, 6.0));
                for (Creeper creeper : level.m_45976_(Creeper.class, detectionBox)) {
                    if (!creeper.m_32311_() && creeper.m_32310_() <= 0 || !EyeofChronos.tryTeleport(player, stack, level, (Entity)creeper)) continue;
                    LOGGER.info("Teleported {} due to Creeper", (Object)player.m_7755_().getString());
                    return false;
                }
                for (Projectile projectile : level.m_45976_(Projectile.class, projectileHitbox)) {
                    UUID projectileUUID;
                    if (projectile.m_19749_() == player || !projectile.m_6084_() || !(projectile.m_20184_().m_82556_() > 0.1) || processedProjectiles.contains(projectileUUID = projectile.m_20148_())) continue;
                    processedProjectiles.add(projectileUUID);
                    if (!EyeofChronos.tryTeleport(player, stack, level, (Entity)projectile)) continue;
                    LOGGER.info("Teleported {} due to Projectile {}", (Object)player.m_7755_().getString(), (Object)projectile.getClass().getSimpleName());
                    return false;
                }
                for (Mob mob : level.m_45976_(Mob.class, mobHitbox)) {
                    if (mob.m_5448_() != player || !EyeofChronos.tryTeleport(player, stack, level, (Entity)mob)) continue;
                    LOGGER.info("Teleported {} due to Mob {}", (Object)player.m_7755_().getString(), (Object)mob.m_7755_().getString());
                    return false;
                }
            }
            return false;
        });
    }

    private static ItemStack findSiuuDodgeItem(Player player) {
        for (ItemStack stack : player.m_150109_().f_35974_) {
            if (!(stack.m_41720_() instanceof EyeofChronos)) continue;
            return stack;
        }
        if (player.m_21206_().m_41720_() instanceof EyeofChronos) {
            return player.m_21206_();
        }
        return ItemStack.f_41583_;
    }

    private static boolean tryTeleport(Player player, ItemStack stack, ServerLevel level, Entity dangerSource) {
        long currentTime = level.m_46467_();
        PlayerData data = playerDataMap.get(player.m_20148_());
        if (data == null || !data.isActive) {
            return false;
        }
        Vec3 startPos = player.m_20182_();
        Vec3 dangerPos = dangerSource != null ? dangerSource.m_20182_() : startPos;
        double bestDistance = -1.0;
        Vec3 bestPos = null;
        boolean isProjectile = dangerSource instanceof Projectile;
        for (double xOffset = -5.0; xOffset <= 5.0; xOffset += 0.5) {
            for (double yOffset = -2.0; yOffset <= 5.0; yOffset += 0.5) {
                for (double zOffset = -5.0; zOffset <= 5.0; zOffset += 0.5) {
                    double distance;
                    double x = startPos.f_82479_ + xOffset;
                    double y = startPos.f_82480_ + yOffset;
                    double z = startPos.f_82481_ + zOffset;
                    BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
                    BlockState belowState = level.m_8055_(pos.m_7495_());
                    FluidState fluidState = level.m_6425_(pos);
                    BlockState headState = level.m_8055_(pos.m_7494_());
                    BlockState headState2 = level.m_8055_(pos.m_6630_(2));
                    if (!belowState.m_60804_((BlockGetter)level, pos.m_7495_()) || fluidState.m_76170_() || level.m_6425_(pos.m_7494_()).m_76170_() || headState.m_60804_((BlockGetter)level, pos.m_7494_()) || headState2.m_60804_((BlockGetter)level, pos.m_6630_(2)) || !level.m_45756_((Entity)player, player.m_20191_().m_82386_(x - player.m_20185_(), y - player.m_20186_(), z - player.m_20189_())) || !((distance = new Vec3(x, y, z).m_82554_(dangerPos)) > bestDistance)) continue;
                    bestDistance = distance;
                    bestPos = new Vec3(x, y, z);
                }
            }
        }
        if (bestPos == null) {
            Vec3 fallbackPos;
            ++data.failedTeleportCount;
            player.m_5661_((Component)Component.m_237113_((String)"Siuu Dodge failed to find safe location!"), true);
            LOGGER.warn("Failed to teleport {}: No safe location found (Failed attempts: {})", (Object)player.m_7755_().getString(), (Object)data.failedTeleportCount);
            if (data.failedTeleportCount >= 2 && (fallbackPos = EyeofChronos.calculateFallbackPosition(startPos, dangerPos, isProjectile, level, player)) != null) {
                bestPos = fallbackPos;
                data.failedTeleportCount = 0;
                LOGGER.info("Attempting fallback teleport for {} to ({}, {}, {})", (Object)player.m_7755_().getString(), (Object)bestPos.f_82479_, (Object)bestPos.f_82480_, (Object)bestPos.f_82481_);
            }
        } else {
            data.failedTeleportCount = 0;
        }
        if (bestPos != null) {
            int i;
            for (i = 0; i < 16; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, startPos.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.8, startPos.f_82480_ + level.f_46441_.m_188500_() * 2.0, startPos.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.8, (level.f_46441_.m_188500_() - 0.5) * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1);
            }
            player.m_6021_(bestPos.f_82479_, bestPos.f_82480_, bestPos.f_82481_);
            for (i = 0; i < 16; ++i) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123760_, bestPos.f_82479_ + (level.f_46441_.m_188500_() - 0.5) * 0.8, bestPos.f_82480_ + level.f_46441_.m_188500_() * 2.0, bestPos.f_82481_ + (level.f_46441_.m_188500_() - 0.5) * 0.8, (level.f_46441_.m_188500_() - 0.5) * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1);
            }
            level.m_6263_(null, startPos.f_82479_, startPos.f_82480_, startPos.f_82481_, SoundEvents.f_11852_, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
            player.m_5661_((Component)Component.m_237113_((String)"Siuu! Dodged danger!"), true);
            LOGGER.info("Teleported {} to ({}, {}, {})", (Object)player.m_7755_().getString(), (Object)bestPos.f_82479_, (Object)bestPos.f_82480_, (Object)bestPos.f_82481_);
            return true;
        }
        return false;
    }

    private static Vec3 calculateFallbackPosition(Vec3 startPos, Vec3 dangerPos, boolean isProjectile, ServerLevel level, Player player) {
        double z;
        double y;
        double x;
        if (isProjectile) {
            x = startPos.f_82479_ + 5.0;
            y = startPos.f_82480_;
            z = startPos.f_82481_;
        } else {
            Vec3 direction = startPos.m_82546_(dangerPos).m_82541_();
            x = startPos.f_82479_ + direction.f_82479_ * 5.0;
            y = startPos.f_82480_;
            z = startPos.f_82481_ + direction.f_82481_ * 5.0;
        }
        BlockPos pos = new BlockPos((int)x, (int)y, (int)z);
        BlockState belowState = level.m_8055_(pos.m_7495_());
        FluidState fluidState = level.m_6425_(pos);
        BlockState headState = level.m_8055_(pos.m_7494_());
        BlockState headState2 = level.m_8055_(pos.m_6630_(2));
        if (belowState.m_60804_((BlockGetter)level, pos.m_7495_()) && !fluidState.m_76170_() && !level.m_6425_(pos.m_7494_()).m_76170_() && !headState.m_60804_((BlockGetter)level, pos.m_7494_()) && !headState2.m_60804_((BlockGetter)level, pos.m_6630_(2)) && level.m_45756_((Entity)player, player.m_20191_().m_82386_(x - player.m_20185_(), y - player.m_20186_(), z - player.m_20189_()))) {
            return new Vec3(x, y, z);
        }
        for (double yOffset = -2.0; yOffset <= 5.0; yOffset += 0.5) {
            double tryY = startPos.f_82480_ + yOffset;
            pos = new BlockPos((int)x, (int)tryY, (int)z);
            belowState = level.m_8055_(pos.m_7495_());
            fluidState = level.m_6425_(pos);
            headState = level.m_8055_(pos.m_7494_());
            headState2 = level.m_8055_(pos.m_6630_(2));
            if (!belowState.m_60804_((BlockGetter)level, pos.m_7495_()) || fluidState.m_76170_() || level.m_6425_(pos.m_7494_()).m_76170_() || headState.m_60804_((BlockGetter)level, pos.m_7494_()) || headState2.m_60804_((BlockGetter)level, pos.m_6630_(2)) || !level.m_45756_((Entity)player, player.m_20191_().m_82386_(x - player.m_20185_(), tryY - player.m_20186_(), z - player.m_20189_()))) continue;
            return new Vec3(x, tryY, z);
        }
        return null;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.zeromod.eye_of_chronos.tooltip").m_130938_(style -> style.m_178520_(2003199)));
    }

    private static class PlayerData {
        boolean isActive = false;
        long cooldownEnd = 0L;
        long effectEndTime = 0L;
        int failedTeleportCount = 0;

        PlayerData() {
        }

        void activate(long currentTime) {
            this.isActive = true;
            this.effectEndTime = currentTime + 1200L;
            this.cooldownEnd = currentTime + 12000L;
            this.failedTeleportCount = 0;
        }

        void deactivate() {
            this.isActive = false;
            this.effectEndTime = 0L;
            this.failedTeleportCount = 0;
        }

        boolean isOnCooldown(long currentTime) {
            return currentTime < this.cooldownEnd;
        }
    }
}

