/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.com.zeromod.network.DodgePacket;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="zeromod")
public class SwapTimeItem
extends Item {
    private static final Map<UUID, SwapData> pendingSwaps = new HashMap<UUID, SwapData>();
    private static final long SWAP_DURATION = 1200L;
    private static final int AI_DURATION = 60;
    private static final long SWAP_TIME_OFFSET = 40L;
    private static final int SLOW_DURATION = 60;
    private static final int SLOW_LEVEL = 1;
    private static final int WEAKNESS_LEVEL = 1;
    private static final int GENERATION_LEVEL = 10;
    private static final int GENERATION_DURATION = 80;

    public SwapTimeItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (!player.m_9236_().m_5776_() && target instanceof Mob) {
            Mob mobTarget = (Mob)target;
            ServerLevel level = (ServerLevel)player.m_9236_();
            DodgePacket.sendToClient((ServerPlayer)player, true);
            mobTarget.m_21557_(true);
            AttributeInstance pAttr = player.m_21051_(Attributes.f_22276_);
            AttributeInstance mAttr = mobTarget.m_21051_(Attributes.f_22276_);
            double playerOriginalHealth = pAttr != null ? pAttr.m_22115_() : 20.0;
            double mobOriginalHealth = mAttr != null ? mAttr.m_22115_() : 20.0;
            pendingSwaps.put(target.m_20148_(), new SwapData(player.m_20148_(), mobTarget.m_20148_(), level.m_46467_() + 1200L, level.m_46467_() + 40L, level.m_46467_() + 60L, playerOriginalHealth, mobOriginalHealth));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 60, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 60, 1));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 80, 10));
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ServerLevel level = event.getServer().m_129783_();
        long currentTime = level.m_46467_();
        pendingSwaps.entrySet().removeIf(entry -> {
            AttributeInstance mAttr;
            long ticksRemaining;
            UUID mobUUID = (UUID)entry.getKey();
            SwapData data = (SwapData)entry.getValue();
            Player player = level.m_46003_(data.playerUUID);
            Mob mob = (Mob)level.m_8791_(data.mobUUID);
            if (mob == null || player == null || !mob.m_6084_() || !player.m_6084_()) {
                if (player != null) {
                    DodgePacket.sendToClient((ServerPlayer)player, false);
                }
                return true;
            }
            if (currentTime >= data.aiDisableTime && mob.m_21525_()) {
                mob.m_21557_(false);
            }
            if ((ticksRemaining = data.aiEnableTime - currentTime) > 0L && currentTime % 20L == 0L) {
                int secondsRemaining = (int)(ticksRemaining / 20L);
                player.m_5661_((Component)Component.m_237113_((String)("Swap effect expires in " + secondsRemaining + " seconds")), true);
            }
            if (currentTime >= data.swapTime && !data.swapped) {
                AttributeInstance pAttr = player.m_21051_(Attributes.f_22276_);
                mAttr = mob.m_21051_(Attributes.f_22276_);
                if (pAttr != null && mAttr != null) {
                    double pMax = pAttr.m_22115_();
                    double mMax = mAttr.m_22115_();
                    pAttr.m_22100_(mMax);
                    mAttr.m_22100_(pMax);
                    player.m_21153_(Math.min(player.m_21223_(), (float)mMax));
                    mob.m_21153_(Math.min(mob.m_21223_(), (float)pMax));
                    player.m_5661_((Component)Component.m_237113_((String)("Health attributes swapped with " + mob.m_7755_().getString() + "!")), true);
                } else {
                    System.out.println("Failed to swap health: Player or mob attribute is null");
                }
                data.swapped = true;
            }
            if (currentTime >= data.aiEnableTime) {
                AttributeInstance pAttr = player.m_21051_(Attributes.f_22276_);
                mAttr = mob.m_21051_(Attributes.f_22276_);
                if (pAttr != null && mAttr != null) {
                    pAttr.m_22100_(data.playerOriginalHealth);
                    mAttr.m_22100_(data.mobOriginalHealth);
                    player.m_21153_(Math.min(player.m_21223_(), (float)data.playerOriginalHealth));
                    mob.m_21153_(Math.min(mob.m_21223_(), (float)data.mobOriginalHealth));
                }
                player.m_5661_((Component)Component.m_237113_((String)"Swap effect has expired"), true);
                DodgePacket.sendToClient((ServerPlayer)player, false);
                return true;
            }
            return false;
        });
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"item.zeromod.swap_time.tooltip").m_130938_(style -> style.m_178520_(2003199)));
    }

    private static class SwapData {
        UUID playerUUID;
        UUID mobUUID;
        long aiEnableTime;
        long swapTime;
        long aiDisableTime;
        boolean swapped;
        double playerOriginalHealth;
        double mobOriginalHealth;

        SwapData(UUID playerUUID, UUID mobUUID, long aiEnableTime, long swapTime, long aiDisableTime, double playerOriginalHealth, double mobOriginalHealth) {
            this.playerUUID = playerUUID;
            this.mobUUID = mobUUID;
            this.aiEnableTime = aiEnableTime;
            this.swapTime = swapTime;
            this.aiDisableTime = aiDisableTime;
            this.swapped = false;
            this.playerOriginalHealth = playerOriginalHealth;
            this.mobOriginalHealth = mobOriginalHealth;
        }
    }
}

