/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.network;

import java.util.UUID;
import java.util.function.Supplier;
import net.com.zeromod.data.ReZeroData;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverlayPacket {
    static final Logger LOGGER = LoggerFactory.getLogger(OverlayPacket.class);
    final UUID playerUUID;
    final boolean isTriggered;

    public OverlayPacket(UUID playerUUID, boolean isTriggered) {
        this.playerUUID = playerUUID;
        this.isTriggered = isTriggered;
    }

    public static void encode(OverlayPacket msg, FriendlyByteBuf buf) {
        buf.m_130077_(msg.playerUUID);
        buf.writeBoolean(msg.isTriggered);
    }

    public static OverlayPacket decode(FriendlyByteBuf buf) {
        return new OverlayPacket(buf.m_130259_(), buf.readBoolean());
    }

    public static void handle(OverlayPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91074_.m_20148_().equals(msg.playerUUID)) {
                LOGGER.info("Received overlay packet: isTriggered=" + msg.isTriggered + " for player: " + mc.f_91074_.m_7755_().getString());
                ReZeroData.overlayStates.put(msg.playerUUID, msg.isTriggered);
                if (msg.isTriggered) {
                    mc.f_91067_.m_91602_();
                } else {
                    mc.f_91067_.m_91601_();
                }
            } else {
                LOGGER.warn("Overlay packet received but player UUID mismatch or player is null! Expected: " + msg.playerUUID);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

