/*
 * Decompiled with CFR 0.152.
 */
package net.com.zeromod.network;

import java.util.function.Supplier;
import net.com.zeromod.client.SwapOverlay;
import net.com.zeromod.network.ModNetwork;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;

public class SwapPacket {
    final boolean isActive;

    public SwapPacket(boolean isActive) {
        this.isActive = isActive;
    }

    public static void encode(SwapPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.isActive);
    }

    public static SwapPacket decode(FriendlyByteBuf buf) {
        return new SwapPacket(buf.readBoolean());
    }

    public static void handle(SwapPacket msg, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> SwapOverlay.setActive(msg.isActive));
        ctx.get().setPacketHandled(true);
    }

    public static void sendToClient(ServerPlayer player, boolean isActive) {
        ModNetwork.INSTANCE.sendTo((Object)new SwapPacket(isActive), player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }
}

