/*
 * Decompiled with CFR 0.152.
 */
package rasmi.riseChat;

import github.scarsz.discordsrv.DiscordSRV;
import github.scarsz.discordsrv.dependencies.jda.api.entities.TextChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.PlaceholderAPI;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.luckperms.api.query.QueryOptions;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import rasmi.risechat.libs.kyori.adventure.text.Component;
import rasmi.risechat.libs.kyori.adventure.text.minimessage.MiniMessage;
import rasmi.risechat.libs.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

public class RiseChat
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private final Map<Player, Sound> playerSounds = new HashMap<Player, Sound>();
    private final Map<Player, Player> lastPM = new HashMap<Player, Player>();
    private final Set<Player> spyEnabled = new HashSet<Player>();
    private final Map<Player, Set<Player>> ignoredPlayers = new HashMap<Player, Set<Player>>();
    private final Map<Player, Long> mutedPlayers = new HashMap<Player, Long>();
    private boolean placeholderAPIEnabled = false;
    private boolean discordSRVEnabled = false;
    private boolean luckPermsEnabled = false;
    private DiscordSRV discordSRV;
    private LuckPerms luckPerms;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacyAmpersand();

    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.setupDefaultConfig();
        this.config.options().copyDefaults(true);
        this.saveConfig();
        this.registerCommands();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.placeholderAPIEnabled = true;
            this.getLogger().info("PlaceholderAPI \u043d\u0430\u0439\u0434\u0435\u043d, \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u043e\u0432.");
        }
        if (Bukkit.getPluginManager().getPlugin("DiscordSRV") != null && this.config.getBoolean("discordSRV.enabled", true)) {
            this.discordSRVEnabled = true;
            this.discordSRV = DiscordSRV.getPlugin();
            this.getLogger().info("DiscordSRV \u043d\u0430\u0439\u0434\u0435\u043d, \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0438\u043d\u0442\u0435\u0433\u0440\u0430\u0446\u0438\u044f \u0441 Discord.");
        }
        if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
            try {
                this.luckPerms = LuckPermsProvider.get();
                this.luckPermsEnabled = true;
                this.getLogger().info("LuckPerms \u043d\u0430\u0439\u0434\u0435\u043d, \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u043f\u0440\u0435\u0444\u0438\u043a\u0441\u043e\u0432 \u0438 \u0441\u0443\u0444\u0444\u0438\u043a\u0441\u043e\u0432.");
            }
            catch (IllegalStateException e) {
                this.getLogger().warning("LuckPerms \u043d\u0430\u0439\u0434\u0435\u043d, \u043d\u043e API \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d: " + e.getMessage());
            }
        }
        this.getLogger().info("RiseChat \u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d \u0441 \u043f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u043e\u0439 RGB \u0446\u0432\u0435\u0442\u043e\u0432 (MiniMessage)!");
        Bukkit.getScheduler().runTaskTimer((Plugin)this, this::checkMutes, 0L, 1200L);
    }

    private void setupDefaultConfig() {
        this.config.addDefault("newPlayersChat.restrict", (Object)true);
        this.config.addDefault("newPlayersChat.minPlayTime", (Object)3600000);
        this.config.addDefault("newPlayersChat.restrictMessage", (Object)"<red>\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u0447\u0430\u0442, \u043f\u043e\u043a\u0430 \u043d\u0435 \u043e\u0442\u044b\u0433\u0440\u0430\u0435\u0442\u0435 {\u0432\u0440\u0435\u043c\u044f} \u043c\u0438\u043d\u0443\u0442!");
        this.config.addDefault("useLuckPermsPrefix", (Object)true);
        this.config.addDefault("discordSRV.enabled", (Object)true);
        this.config.addDefault("discordSRV.channelID", (Object)"123456789012345678");
        this.config.addDefault("discordSRV.global_format", (Object)"{\u0438\u0433\u0440\u043e\u043a}: {\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}");
        this.config.addDefault("joinMessages.enabled", (Object)true);
        this.config.addDefault("joinMessages.suppressDefault", (Object)true);
        this.config.addDefault("joinMessages.format", (Object)"<yellow>{\u0438\u0433\u0440\u043e\u043a} <green>\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443!");
        this.config.addDefault("firstJoinMessages.enabled", (Object)true);
        this.config.addDefault("firstJoinMessages.suppressDefault", (Object)true);
        this.config.addDefault("firstJoinMessages.format", (Object)"<yellow>{\u0438\u0433\u0440\u043e\u043a} <aqua>\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0432\u043f\u0435\u0440\u0432\u044b\u0435! \u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c!");
        this.config.addDefault("leaveMessages.enabled", (Object)true);
        this.config.addDefault("leaveMessages.suppressDefault", (Object)true);
        this.config.addDefault("leaveMessages.format", (Object)"<yellow>{\u0438\u0433\u0440\u043e\u043a} <red>\u043f\u043e\u043a\u0438\u043d\u0443\u043b \u0441\u0435\u0440\u0432\u0435\u0440!");
        this.config.addDefault("globalChatEnabled", (Object)true);
        this.config.addDefault("localChatEnabled", (Object)true);
        this.config.addDefault("localChatRadius", (Object)100);
        this.config.addDefault("noPlayersMessageEnabled", (Object)true);
        this.config.addDefault("globalChatPrefix", (Object)"!");
        this.config.addDefault("messages.chat.global_format", (Object)"<aqua>[G] <white>{\u0438\u0433\u0440\u043e\u043a}: {\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}");
        this.config.addDefault("messages.chat.local_format", (Object)"<blue>[L] <white>{\u0438\u0433\u0440\u043e\u043a}: {\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}");
        this.config.addDefault("messages.chat.no_players_nearby", (Object)"<gray>\u041d\u0438\u043a\u0442\u043e \u0432\u0430\u0441 \u043d\u0435 \u0443\u0441\u043b\u044b\u0448\u0430\u043b!");
        this.config.addDefault("messages.pm.usage", (Object)"<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /pm <\u0438\u0433\u0440\u043e\u043a> <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435>");
        this.config.addDefault("messages.pm.sender", (Object)"<gray>\u0412\u044b \u043f\u0440\u043e\u0448\u0435\u043f\u0442\u0430\u043b\u0438 {\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c}: <white>{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}");
        this.config.addDefault("messages.pm.recipient", (Object)"<gray>\u0418\u0433\u0440\u043e\u043a {\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c} \u043f\u0440\u043e\u0448\u0435\u043f\u0442\u0430\u043b \u0432\u0430\u043c: <white>{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}");
        this.config.addDefault("messages.menu.sound_selection", (Object)"<blue>\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0432\u0443\u043a \u043b\u0438\u0447\u043d\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439");
        this.config.addDefault("messages.menu.sound_selected", (Object)"<green>\u0412\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u0437\u0432\u0443\u043a: {\u0437\u0432\u0443\u043a}");
        this.config.addDefault("messages.spy.usage", (Object)"<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /spy <on|off>");
        this.config.addDefault("messages.spy.enabled", (Object)"<green>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
        this.config.addDefault("messages.spy.disabled", (Object)"<green>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
        this.config.addDefault("messages.spy.already_enabled", (Object)"<red>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
        this.config.addDefault("messages.spy.already_disabled", (Object)"<red>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
        this.config.addDefault("messages.ignore.added", (Object)"<green>\u0412\u044b \u0434\u043e\u0431\u0430\u0432\u0438\u043b\u0438 \u0438\u0433\u0440\u043e\u043a\u0430 {\u0438\u0433\u0440\u043e\u043a} \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0445!");
        this.config.addDefault("messages.ignore.removed", (Object)"<green>\u0412\u044b \u0443\u0431\u0440\u0430\u043b\u0438 \u0438\u0433\u0440\u043e\u043a\u0430 {\u0438\u0433\u0440\u043e\u043a} \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0445!");
        this.config.addDefault("messages.ignore.already_ignored", (Object)"<red>\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0443\u0436\u0435 \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0445!");
        this.config.addDefault("messages.ignore.not_ignored", (Object)"<red>\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u043d\u0435 \u043d\u0430\u0445\u043e\u0434\u0438\u0442\u0441\u044f \u0432 \u0441\u043f\u0438\u0441\u043a\u0435 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0445!");
        this.config.addDefault("messages.ignore.self", (Object)"<red>\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f!");
        this.config.addDefault("messages.ignore.usage", (Object)"<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /ignore <\u0438\u0433\u0440\u043e\u043a>");
        this.config.addDefault("messages.mute.muted", (Object)"<red>\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b! \u0421\u0440\u043e\u043a \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: {\u0432\u0440\u0435\u043c\u044f}");
        this.config.addDefault("messages.mute.muted_permanent", (Object)"<red>\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430!");
        this.config.addDefault("messages.mute.player_muted", (Object)"<green>\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0437\u0430\u043c\u0443\u0447\u0435\u043d \u043d\u0430 {\u0432\u0440\u0435\u043c\u044f}!");
        this.config.addDefault("messages.mute.player_muted_permanent", (Object)"<green>\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0437\u0430\u043c\u0443\u0447\u0435\u043d \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430!");
        this.config.addDefault("messages.mute.player_unmuted", (Object)"<green>\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0440\u0430\u0437\u043c\u0443\u0447\u0435\u043d!");
        this.config.addDefault("messages.mute.not_muted", (Object)"<red>\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u043d\u0435 \u0437\u0430\u043c\u0443\u0447\u0435\u043d!");
        this.config.addDefault("messages.mute.usage", (Object)"<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /mute <\u0438\u0433\u0440\u043e\u043a> [\u043f\u0440\u0438\u0447\u0438\u043d\u0430]");
        this.config.addDefault("messages.mute.tempmute_usage", (Object)"<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /tempmute <\u0438\u0433\u0440\u043e\u043a> <\u0432\u0440\u0435\u043c\u044f> [\u043f\u0440\u0438\u0447\u0438\u043d\u0430]");
        this.config.addDefault("messages.mute.unmute_usage", (Object)"<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /unmute <\u0438\u0433\u0440\u043e\u043a>");
        this.config.addDefault("messages.errors.only_players", (Object)"<red>\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!");
        this.config.addDefault("messages.errors.player_not_found", (Object)"<red>\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!");
        this.config.addDefault("messages.errors.no_permission", (Object)"<red>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!");
        this.config.addDefault("messages.errors.pm_self", (Object)"<red>\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441\u0430\u043c\u043e\u043c\u0443 \u0441\u0435\u0431\u0435!");
    }

    private void registerCommands() {
        this.getCommand("pm").setExecutor((CommandExecutor)new PrivateMessageCommand());
        this.getCommand("msg").setExecutor((CommandExecutor)new PrivateMessageCommand());
        this.getCommand("m").setExecutor((CommandExecutor)new PrivateMessageCommand());
        this.getCommand("pmsound").setExecutor((CommandExecutor)new PmSoundCommand());
        this.getCommand("spy").setExecutor((CommandExecutor)new SpyCommand());
        this.getCommand("risechat").setExecutor((CommandExecutor)new RiseChatCommand());
        this.getCommand("ignore").setExecutor((CommandExecutor)new IgnoreCommand());
        this.getCommand("mute").setExecutor((CommandExecutor)new MuteCommand());
        this.getCommand("tempmute").setExecutor((CommandExecutor)new TempMuteCommand());
        this.getCommand("unmute").setExecutor((CommandExecutor)new UnmuteCommand());
    }

    private void checkMutes() {
        long currentTime = System.currentTimeMillis();
        this.mutedPlayers.entrySet().removeIf(entry -> {
            if ((Long)entry.getValue() != -1L && (Long)entry.getValue() <= currentTime) {
                Player player = (Player)entry.getKey();
                if (player.isOnline()) {
                    String unmuteMsg = this.getMessage("messages.mute.player_unmuted", "<green>\u0412\u0430\u0448 \u043c\u0443\u0442 \u0438\u0441\u0442\u0435\u043a!");
                    if (this.placeholderAPIEnabled) {
                        unmuteMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)unmuteMsg);
                    }
                    player.sendMessage(this.parseMessage(unmuteMsg));
                }
                return true;
            }
            return false;
        });
    }

    private String parseMessage(String message) {
        message = this.translateBirdflopHex(message);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        try {
            Object component = this.miniMessage.deserialize(message);
            return this.legacySerializer.serialize((Component)component);
        }
        catch (Exception e) {
            return message;
        }
    }

    private String translateBirdflopHex(String message) {
        Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            String replacement = ChatColor.of((String)("#" + hexCode)).toString();
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private boolean isPlayerMuted(Player player) {
        Long muteTime = this.mutedPlayers.get(player);
        if (muteTime == null) {
            return false;
        }
        if (muteTime == -1L) {
            return true;
        }
        if (muteTime <= System.currentTimeMillis()) {
            this.mutedPlayers.remove(player);
            return false;
        }
        return true;
    }

    private boolean isPlayerIgnored(Player sender, Player target) {
        Set<Player> ignored = this.ignoredPlayers.get(target);
        return ignored != null && ignored.contains(sender);
    }

    private String getPlayerDisplayName(Player player) {
        String displayName = player.getName();
        if (this.luckPermsEnabled && this.config.getBoolean("useLuckPermsPrefix", true)) {
            try {
                User user = this.luckPerms.getUserManager().getUser(player.getUniqueId());
                if (user != null) {
                    CachedMetaData metaData = user.getCachedData().getMetaData(QueryOptions.defaultContextualOptions());
                    String prefix = metaData.getPrefix();
                    String suffix = metaData.getSuffix();
                    StringBuilder nameBuilder = new StringBuilder();
                    if (prefix != null) {
                        nameBuilder.append(this.parseMessage(prefix));
                    }
                    nameBuilder.append(player.getName());
                    if (suffix != null) {
                        nameBuilder.append(this.parseMessage(suffix));
                    }
                    displayName = nameBuilder.toString();
                }
            }
            catch (Exception e) {
                this.getLogger().warning("\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u0438 \u043f\u043e\u043b\u0443\u0447\u0435\u043d\u0438\u0438 \u0434\u0430\u043d\u043d\u044b\u0445 LuckPerms \u0434\u043b\u044f \u0438\u0433\u0440\u043e\u043a\u0430 " + player.getName() + ": " + e.getMessage());
            }
        }
        return displayName;
    }

    private String getMessage(String path, String defaultMessage) {
        return this.config.getString(path, defaultMessage);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        String displayName = this.getPlayerDisplayName(player);
        if (this.config.getBoolean("firstJoinMessages.enabled", true) && !player.hasPlayedBefore()) {
            if (this.config.getBoolean("firstJoinMessages.suppressDefault", true)) {
                event.setJoinMessage(null);
            }
            String firstJoinMessage = this.getMessage("firstJoinMessages.format", "<yellow>{\u0438\u0433\u0440\u043e\u043a} <aqua>\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0432\u043f\u0435\u0440\u0432\u044b\u0435! \u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c!").replace("{\u0438\u0433\u0440\u043e\u043a}", displayName);
            if (this.placeholderAPIEnabled) {
                firstJoinMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)firstJoinMessage);
            }
            Bukkit.broadcastMessage((String)this.parseMessage(firstJoinMessage));
            if (this.discordSRVEnabled) {
                String discordMessage = this.config.getString("firstJoinMessages.format", "{\u0438\u0433\u0440\u043e\u043a} \u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443 \u0432\u043f\u0435\u0440\u0432\u044b\u0435! \u0414\u043e\u0431\u0440\u043e \u043f\u043e\u0436\u0430\u043b\u043e\u0432\u0430\u0442\u044c!").replace("{\u0438\u0433\u0440\u043e\u043a}", ChatColor.stripColor((String)displayName));
                if (this.placeholderAPIEnabled) {
                    discordMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)discordMessage);
                }
                discordMessage = ChatColor.stripColor((String)this.parseMessage(discordMessage));
                String channelID = this.config.getString("discordSRV.channelID", "123456789012345678");
                TextChannel channel = this.discordSRV.getJda().getTextChannelById(channelID);
                if (channel != null) {
                    channel.sendMessage((CharSequence)discordMessage).queue();
                } else {
                    this.getLogger().warning("Discord \u043a\u0430\u043d\u0430\u043b \u0441 ID " + channelID + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                }
            }
        } else if (this.config.getBoolean("joinMessages.enabled", true)) {
            if (this.config.getBoolean("joinMessages.suppressDefault", true)) {
                event.setJoinMessage(null);
            }
            String joinMessage = this.getMessage("joinMessages.format", "<yellow>{\u0438\u0433\u0440\u043e\u043a} <green>\u043f\u0440\u0438\u0441\u043e\u0435\u0434\u0438\u043d\u0438\u043b\u0441\u044f \u043a \u0441\u0435\u0440\u0432\u0435\u0440\u0443!").replace("{\u0438\u0433\u0440\u043e\u043a}", displayName);
            if (this.placeholderAPIEnabled) {
                joinMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)joinMessage);
            }
            Bukkit.broadcastMessage((String)this.parseMessage(joinMessage));
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        this.ignoredPlayers.remove(player);
        this.ignoredPlayers.values().forEach(set -> set.remove(player));
        this.spyEnabled.remove(player);
        this.lastPM.remove(player);
        this.playerSounds.remove(player);
        if (this.config.getBoolean("leaveMessages.enabled", true)) {
            String displayName = this.getPlayerDisplayName(player);
            if (this.config.getBoolean("leaveMessages.suppressDefault", true)) {
                event.setQuitMessage(null);
            }
            String leaveMessage = this.getMessage("leaveMessages.format", "<yellow>{\u0438\u0433\u0440\u043e\u043a} <red>\u043f\u043e\u043a\u0438\u043d\u0443\u043b \u0441\u0435\u0440\u0432\u0435\u0440!").replace("{\u0438\u0433\u0440\u043e\u043a}", displayName);
            if (this.placeholderAPIEnabled) {
                leaveMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)leaveMessage);
            }
            Bukkit.broadcastMessage((String)this.parseMessage(leaveMessage));
        }
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        event.setCancelled(true);
        Player player = event.getPlayer();
        String message = event.getMessage();
        if (this.isPlayerMuted(player)) {
            String muteMsg;
            Long muteTime = this.mutedPlayers.get(player);
            if (muteTime == -1L) {
                muteMsg = this.getMessage("messages.mute.muted_permanent", "<red>\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430!");
            } else {
                long remainingTime = (muteTime - System.currentTimeMillis()) / 1000L / 60L;
                muteMsg = this.getMessage("messages.mute.muted", "<red>\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b! \u0421\u0440\u043e\u043a \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: {\u0432\u0440\u0435\u043c\u044f}").replace("{\u0432\u0440\u0435\u043c\u044f}", remainingTime + " \u043c\u0438\u043d");
            }
            if (this.placeholderAPIEnabled) {
                muteMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)muteMsg);
            }
            player.sendMessage(this.parseMessage(muteMsg));
            return;
        }
        if (this.config.getBoolean("newPlayersChat.restrict", true)) {
            long minPlayTime = this.config.getLong("newPlayersChat.minPlayTime", 3600000L);
            long playTime = (long)player.getStatistic(Statistic.PLAY_ONE_MINUTE) * 50L;
            if (playTime < minPlayTime && !player.hasPermission("risechat.bypassnewplayer")) {
                String restrictMessage = this.getMessage("newPlayersChat.restrictMessage", "<red>\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043f\u0438\u0441\u0430\u0442\u044c \u0432 \u0447\u0430\u0442, \u043f\u043e\u043a\u0430 \u043d\u0435 \u043e\u0442\u044b\u0433\u0440\u0430\u0435\u0442\u0435 {\u0432\u0440\u0435\u043c\u044f} \u043c\u0438\u043d\u0443\u0442!").replace("{\u0432\u0440\u0435\u043c\u044f}", String.valueOf(minPlayTime / 60000L));
                if (this.placeholderAPIEnabled) {
                    restrictMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)restrictMessage);
                }
                player.sendMessage(this.parseMessage(restrictMessage));
                return;
            }
        }
        boolean globalChatEnabled = this.config.getBoolean("globalChatEnabled", true);
        boolean localChatEnabled = this.config.getBoolean("localChatEnabled", true);
        int localChatRadius = this.config.getInt("localChatRadius", 100);
        boolean noPlayersMessageEnabled = this.config.getBoolean("noPlayersMessageEnabled", true);
        String displayName = this.getPlayerDisplayName(player);
        if (message.startsWith(this.config.getString("globalChatPrefix", "!"))) {
            if (globalChatEnabled) {
                String globalMessage = message.substring(1);
                String formattedMessage = this.getMessage("messages.chat.global_format", "<aqua>[G] <white>{\u0438\u0433\u0440\u043e\u043a}: {\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}").replace("{\u0438\u0433\u0440\u043e\u043a}", displayName).replace("{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}", globalMessage);
                Pattern pattern = Pattern.compile("@(\\w+)");
                Matcher matcher = pattern.matcher(formattedMessage);
                StringBuilder finalMessage = new StringBuilder(formattedMessage);
                while (matcher.find()) {
                    String mentionedPlayerName = matcher.group(1);
                    Player mentionedPlayer = Bukkit.getPlayerExact((String)mentionedPlayerName);
                    if (mentionedPlayer == null || !mentionedPlayer.isOnline() || this.isPlayerIgnored(player, mentionedPlayer)) continue;
                    String replacement = "<yellow>@" + mentionedPlayerName + "</yellow>";
                    finalMessage = new StringBuilder(finalMessage.toString().replace("@" + mentionedPlayerName, replacement));
                    Sound sound = this.playerSounds.getOrDefault(mentionedPlayer, Sound.BLOCK_NOTE_BLOCK_PLING);
                    mentionedPlayer.playSound(mentionedPlayer.getLocation(), sound, 1.0f, 1.0f);
                }
                if (this.placeholderAPIEnabled) {
                    finalMessage = new StringBuilder(PlaceholderAPI.setPlaceholders((Player)player, (String)finalMessage.toString()));
                }
                String parsedMessage = this.parseMessage(finalMessage.toString());
                for (Player p : Bukkit.getOnlinePlayers()) {
                    if (this.isPlayerIgnored(player, p)) continue;
                    p.sendMessage(parsedMessage);
                }
                if (this.discordSRVEnabled) {
                    String discordMessage = this.config.getString("discordSRV.global_format", "{\u0438\u0433\u0440\u043e\u043a}: {\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}").replace("{\u0438\u0433\u0440\u043e\u043a}", ChatColor.stripColor((String)displayName)).replace("{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}", globalMessage);
                    if (this.placeholderAPIEnabled) {
                        discordMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)discordMessage);
                    }
                    discordMessage = ChatColor.stripColor((String)this.parseMessage(discordMessage));
                    String channelID = this.config.getString("discordSRV.channelID", "123456789012345678");
                    TextChannel channel = this.discordSRV.getJda().getTextChannelById(channelID);
                    if (channel != null) {
                        channel.sendMessage((CharSequence)discordMessage).queue();
                    } else {
                        this.getLogger().warning("Discord \u043a\u0430\u043d\u0430\u043b \u0441 ID " + channelID + " \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d!");
                    }
                }
            }
        } else if (localChatEnabled) {
            String formattedMessage = this.getMessage("messages.chat.local_format", "&9[L] &f{\u0438\u0433\u0440\u043e\u043a}: {\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}").replace("{\u0438\u0433\u0440\u043e\u043a}", displayName).replace("{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}", message);
            if (this.placeholderAPIEnabled) {
                formattedMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)formattedMessage);
            }
            String parsedMessage = this.parseMessage(formattedMessage);
            boolean playerHeard = false;
            for (Player p : Bukkit.getOnlinePlayers()) {
                boolean isSpying;
                boolean inRange = p.getWorld().equals((Object)player.getWorld()) && p.getLocation().distance(player.getLocation()) <= (double)localChatRadius;
                boolean bl = isSpying = this.spyEnabled.contains(p) && p.hasPermission("risechat.spy");
                if (!inRange && !isSpying || this.isPlayerIgnored(player, p)) continue;
                p.sendMessage(parsedMessage);
                if (p.equals((Object)player) || !inRange) continue;
                playerHeard = true;
            }
            if (!playerHeard && noPlayersMessageEnabled) {
                String noPlayersMessage = this.getMessage("messages.chat.no_players_nearby", "<gray>\u041d\u0438\u043a\u0442\u043e \u0432\u0430\u0441 \u043d\u0435 \u0443\u0441\u043b\u044b\u0448\u0430\u043b!");
                if (this.placeholderAPIEnabled) {
                    noPlayersMessage = PlaceholderAPI.setPlaceholders((Player)player, (String)noPlayersMessage);
                }
                player.sendMessage(this.parseMessage(noPlayersMessage));
            }
        }
    }

    private void openSoundMenu(Player player) {
        Sound[] sounds;
        String menuTitle = this.getMessage("messages.menu.sound_selection", "&9\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0432\u0443\u043a \u043b\u0438\u0447\u043d\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439");
        if (this.placeholderAPIEnabled) {
            menuTitle = PlaceholderAPI.setPlaceholders((Player)player, (String)menuTitle);
        }
        menuTitle = ChatColor.stripColor((String)this.parseMessage(menuTitle));
        Inventory inventory = Bukkit.createInventory(null, (int)9, (String)menuTitle);
        for (Sound sound : sounds = new Sound[]{Sound.BLOCK_NOTE_BLOCK_PLING, Sound.ENTITY_EXPERIENCE_ORB_PICKUP, Sound.BLOCK_ANVIL_USE}) {
            ItemStack item = new ItemStack(Material.NOTE_BLOCK);
            ItemMeta meta = item.getItemMeta();
            meta.setDisplayName(String.valueOf(ChatColor.WHITE) + sound.name());
            item.setItemMeta(meta);
            inventory.addItem(new ItemStack[]{item});
        }
        player.openInventory(inventory);
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() instanceof Player) {
            Player player = (Player)event.getWhoClicked();
            String menuTitle = this.getMessage("messages.menu.sound_selection", "&9\u0412\u044b\u0431\u0435\u0440\u0438\u0442\u0435 \u0437\u0432\u0443\u043a \u043b\u0438\u0447\u043d\u044b\u0445 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0439");
            if (this.placeholderAPIEnabled) {
                menuTitle = PlaceholderAPI.setPlaceholders((Player)player, (String)menuTitle);
            }
            menuTitle = ChatColor.stripColor((String)this.parseMessage(menuTitle));
            if (event.getView().getTitle().equals(menuTitle)) {
                event.setCancelled(true);
                if (event.getCurrentItem() != null && event.getCurrentItem().getItemMeta() != null) {
                    String soundName = event.getCurrentItem().getItemMeta().getDisplayName().replace(ChatColor.WHITE.toString(), "");
                    try {
                        Sound sound = Sound.valueOf((String)soundName);
                        this.playerSounds.put(player, sound);
                        player.closeInventory();
                        String successMsg = this.getMessage("messages.menu.sound_selected", "&a\u0412\u044b \u0432\u044b\u0431\u0440\u0430\u043b\u0438 \u0437\u0432\u0443\u043a: {\u0437\u0432\u0443\u043a}").replace("{\u0437\u0432\u0443\u043a}", sound.name());
                        if (this.placeholderAPIEnabled) {
                            successMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)successMsg);
                        }
                        player.sendMessage(this.parseMessage(successMsg));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private long parseTimeString(String timeStr) {
        long time = 0L;
        Pattern pattern = Pattern.compile("(\\d+)([smhd])");
        Matcher matcher = pattern.matcher(timeStr.toLowerCase());
        while (matcher.find()) {
            String unit;
            int value = Integer.parseInt(matcher.group(1));
            switch (unit = matcher.group(2)) {
                case "s": {
                    time += (long)value * 1000L;
                    break;
                }
                case "m": {
                    time += (long)(value * 60) * 1000L;
                    break;
                }
                case "h": {
                    time += (long)(value * 60 * 60) * 1000L;
                    break;
                }
                case "d": {
                    time += (long)(value * 24 * 60 * 60) * 1000L;
                }
            }
        }
        return time;
    }

    private String formatTime(long millis) {
        if (millis == -1L) {
            return "\u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430";
        }
        long seconds = millis / 1000L;
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        if (days > 0L) {
            return days + " \u0434\u043d. " + hours % 24L + " \u0447.";
        }
        if (hours > 0L) {
            return hours + " \u0447. " + minutes % 60L + " \u043c\u0438\u043d.";
        }
        if (minutes > 0L) {
            return minutes + " \u043c\u0438\u043d.";
        }
        return seconds + " \u0441\u0435\u043a.";
    }

    public class PrivateMessageCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.only_players", "&c\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!")));
                return true;
            }
            if (args.length < 2) {
                String usageMsg = RiseChat.this.getMessage("messages.pm.usage", "&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /pm <\u0438\u0433\u0440\u043e\u043a> <\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435>");
                if (RiseChat.this.placeholderAPIEnabled) {
                    usageMsg = PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)usageMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(usageMsg));
                return true;
            }
            Player senderPlayer = (Player)sender;
            Player recipient = Bukkit.getPlayer((String)args[0]);
            if (recipient == null || !recipient.isOnline()) {
                String errorMsg = RiseChat.this.getMessage("messages.errors.player_not_found", "&c>\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    errorMsg = PlaceholderAPI.setPlaceholders((Player)senderPlayer, (String)errorMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(errorMsg));
                return true;
            }
            if (recipient.equals((Object)senderPlayer)) {
                String errorMsg = RiseChat.this.getMessage("messages.errors.pm_self", "&c>\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u044c \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0441\u0430\u043c\u043e\u043c\u0443 \u0441\u0435\u0431\u0435!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    errorMsg = PlaceholderAPI.setPlaceholders((Player)senderPlayer, (String)errorMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(errorMsg));
                return true;
            }
            if (RiseChat.this.isPlayerMuted(senderPlayer)) {
                String muteMsg;
                Long muteTime = RiseChat.this.mutedPlayers.get(senderPlayer);
                if (muteTime == -1L) {
                    muteMsg = RiseChat.this.getMessage("messages.mute.muted_permanent", "&c\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430!");
                } else {
                    long remainingTime = (muteTime - System.currentTimeMillis()) / 1000L / 60L;
                    muteMsg = RiseChat.this.getMessage("messages.mute.muted", "&c\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b! \u0421\u0440\u043e\u043a \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: {\u0432\u0440\u0435\u043c\u044f}").replace("{\u0432\u0440\u0435\u043c\u044f}", remainingTime + " \u043c\u0438\u043d");
                }
                if (RiseChat.this.placeholderAPIEnabled) {
                    muteMsg = PlaceholderAPI.setPlaceholders((Player)senderPlayer, (String)muteMsg);
                }
                senderPlayer.sendMessage(RiseChat.this.parseMessage(muteMsg));
                return true;
            }
            if (RiseChat.this.isPlayerIgnored(senderPlayer, recipient)) {
                String errorMsg = RiseChat.this.getMessage("messages.errors.player_not_found", "<red>\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    errorMsg = PlaceholderAPI.setPlaceholders((Player)senderPlayer, (String)errorMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(errorMsg));
                return true;
            }
            String message = String.join((CharSequence)" ", args).substring(args[0].length() + 1);
            String pmFormatSender = RiseChat.this.getMessage("messages.pm.sender", "<gray>\u0412\u044b \u043f\u0440\u043e\u0448\u0435\u043f\u0442\u0430\u043b\u0438 {\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c}: <white>{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}").replace("{\u043f\u043e\u043b\u0443\u0447\u0430\u0442\u0435\u043b\u044c}", recipient.getName()).replace("{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}", message);
            String pmFormatRecipient = RiseChat.this.getMessage("messages.pm.recipient", "<gray>\u0418\u0433\u0440\u043e\u043a {\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c} \u043f\u0440\u043e\u0448\u0435\u043f\u0442\u0430\u043b \u0432\u0430\u043c: <white>{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}").replace("{\u043e\u0442\u043f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c}", senderPlayer.getName()).replace("{\u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435}", message);
            if (RiseChat.this.placeholderAPIEnabled) {
                pmFormatSender = PlaceholderAPI.setPlaceholders((Player)senderPlayer, (String)pmFormatSender);
                pmFormatRecipient = PlaceholderAPI.setPlaceholders((Player)recipient, (String)pmFormatRecipient);
            }
            sender.sendMessage(RiseChat.this.parseMessage(pmFormatSender));
            recipient.sendMessage(RiseChat.this.parseMessage(pmFormatRecipient));
            RiseChat.this.lastPM.put(recipient, senderPlayer);
            RiseChat.this.lastPM.put(senderPlayer, recipient);
            Sound sound = RiseChat.this.playerSounds.getOrDefault(recipient, Sound.BLOCK_NOTE_BLOCK_PLING);
            recipient.playSound(recipient.getLocation(), sound, 1.0f, 1.0f);
            return true;
        }
    }

    public class PmSoundCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.only_players", "&c\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!")));
                return true;
            }
            Player player = (Player)sender;
            RiseChat.this.openSoundMenu(player);
            return true;
        }
    }

    public class SpyCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.only_players", "&c\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!")));
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("risechat.spy")) {
                String errorMsg = RiseChat.this.getMessage("messages.errors.no_permission", "<red>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    errorMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)errorMsg);
                }
                player.sendMessage(RiseChat.this.parseMessage(errorMsg));
                return true;
            }
            if (args.length == 0 || !args[0].equalsIgnoreCase("on") && !args[0].equalsIgnoreCase("off")) {
                String usageMsg = RiseChat.this.getMessage("messages.spy.usage", "<gray>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /spy <on|off>");
                if (RiseChat.this.placeholderAPIEnabled) {
                    usageMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)usageMsg);
                }
                player.sendMessage(RiseChat.this.parseMessage(usageMsg));
                return true;
            }
            if (args[0].equalsIgnoreCase("on")) {
                if (RiseChat.this.spyEnabled.contains(player)) {
                    String alreadyEnabledMsg = RiseChat.this.getMessage("messages.spy.already_enabled", "<red>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u0443\u0436\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
                    if (RiseChat.this.placeholderAPIEnabled) {
                        alreadyEnabledMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)alreadyEnabledMsg);
                    }
                    player.sendMessage(RiseChat.this.parseMessage(alreadyEnabledMsg));
                } else {
                    RiseChat.this.spyEnabled.add(player);
                    String enabledMsg = RiseChat.this.getMessage("messages.spy.enabled", "<green>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
                    if (RiseChat.this.placeholderAPIEnabled) {
                        enabledMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)enabledMsg);
                    }
                    player.sendMessage(RiseChat.this.parseMessage(enabledMsg));
                }
            } else if (!RiseChat.this.spyEnabled.contains(player)) {
                String alreadyDisabledMsg = RiseChat.this.getMessage("messages.spy.already_disabled", "<red>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u0443\u0436\u0435 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    alreadyDisabledMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)alreadyDisabledMsg);
                }
                player.sendMessage(RiseChat.this.parseMessage(alreadyDisabledMsg));
            } else {
                RiseChat.this.spyEnabled.remove(player);
                String disabledMsg = RiseChat.this.getMessage("messages.spy.disabled", "<green>\u0420\u0435\u0436\u0438\u043c \u0448\u043f\u0438\u043e\u043d\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    disabledMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)disabledMsg);
                }
                player.sendMessage(RiseChat.this.parseMessage(disabledMsg));
            }
            return true;
        }
    }

    public class RiseChatCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("risechat.reload")) {
                    sender.sendMessage(RiseChat.this.parseMessage("<red>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!"));
                    return true;
                }
                RiseChat.this.reloadConfig();
                RiseChat.this.config = RiseChat.this.getConfig();
                RiseChat.this.luckPermsEnabled = false;
                if (Bukkit.getPluginManager().getPlugin("LuckPerms") != null) {
                    try {
                        RiseChat.this.luckPerms = LuckPermsProvider.get();
                        RiseChat.this.luckPermsEnabled = true;
                        RiseChat.this.getLogger().info("LuckPerms \u043f\u0435\u0440\u0435\u043f\u043e\u0434\u043a\u043b\u044e\u0447\u0435\u043d \u043f\u043e\u0441\u043b\u0435 \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438.");
                    }
                    catch (IllegalStateException e) {
                        RiseChat.this.getLogger().warning("LuckPerms \u043d\u0430\u0439\u0434\u0435\u043d, \u043d\u043e API \u043d\u0435\u0434\u043e\u0441\u0442\u0443\u043f\u0435\u043d: " + e.getMessage());
                    }
                }
                sender.sendMessage(RiseChat.this.parseMessage("<green>RiseChat \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d!"));
                return true;
            }
            sender.sendMessage(RiseChat.this.parseMessage("<aqua>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /risechat reload"));
            return true;
        }
    }

    public class IgnoreCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.only_players", "&c\u0422\u043e\u043b\u044c\u043a\u043e \u0438\u0433\u0440\u043e\u043a\u0438 \u043c\u043e\u0433\u0443\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u044c \u044d\u0442\u0443 \u043a\u043e\u043c\u0430\u043d\u0434\u0443!")));
                return true;
            }
            if (args.length != 1) {
                String usageMsg = RiseChat.this.getMessage("messages.ignore.usage", "&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /ignore <\u0438\u0433\u0440\u043e\u043a>");
                if (RiseChat.this.placeholderAPIEnabled) {
                    usageMsg = PlaceholderAPI.setPlaceholders((Player)((Player)sender), (String)usageMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(usageMsg));
                return true;
            }
            Player player = (Player)sender;
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                String errorMsg = RiseChat.this.getMessage("messages.errors.player_not_found", "&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    errorMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)errorMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(errorMsg));
                return true;
            }
            if (target.equals((Object)player)) {
                String errorMsg = RiseChat.this.getMessage("messages.ignore.self", "&c\u0412\u044b \u043d\u0435 \u043c\u043e\u0436\u0435\u0442\u0435 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0441\u0430\u043c\u043e\u0433\u043e \u0441\u0435\u0431\u044f!");
                if (RiseChat.this.placeholderAPIEnabled) {
                    errorMsg = PlaceholderAPI.setPlaceholders((Player)player, (String)errorMsg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(errorMsg));
                return true;
            }
            Set ignored = RiseChat.this.ignoredPlayers.computeIfAbsent(player, k -> new HashSet());
            if (ignored.contains(target)) {
                ignored.remove(target);
                String msg = RiseChat.this.getMessage("messages.ignore.removed", "&a\u0412\u044b \u0443\u0431\u0440\u0430\u043b\u0438 \u0438\u0433\u0440\u043e\u043a\u0430 {\u0438\u0433\u0440\u043e\u043a} \u0438\u0437 \u0441\u043f\u0438\u0441\u043a\u0430 \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0445!").replace("{\u0438\u0433\u0440\u043e\u043a}", target.getName());
                if (RiseChat.this.placeholderAPIEnabled) {
                    msg = PlaceholderAPI.setPlaceholders((Player)player, (String)msg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(msg));
            } else {
                ignored.add(target);
                String msg = RiseChat.this.getMessage("messages.ignore.added", "&a\u0412\u044b \u0434\u043e\u0431\u0430\u0432\u0438\u043b\u0438 \u0438\u0433\u0440\u043e\u043a\u0430 {\u0438\u0433\u0440\u043e\u043a} \u0432 \u0441\u043f\u0438\u0441\u043e\u043a \u0438\u0433\u043d\u043e\u0440\u0438\u0440\u0443\u0435\u043c\u044b\u0445!").replace("{\u0438\u0433\u0440\u043e\u043a}", target.getName());
                if (RiseChat.this.placeholderAPIEnabled) {
                    msg = PlaceholderAPI.setPlaceholders((Player)player, (String)msg);
                }
                sender.sendMessage(RiseChat.this.parseMessage(msg));
            }
            return true;
        }
    }

    public class MuteCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("risechat.mute")) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.no_permission", "&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!")));
                return true;
            }
            if (args.length < 1) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.mute.usage", "&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /mute <\u0438\u0433\u0440\u043e\u043a> [\u043f\u0440\u0438\u0447\u0438\u043d\u0430]")));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.player_not_found", "&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!")));
                return true;
            }
            RiseChat.this.mutedPlayers.put(target, -1L);
            String msg = RiseChat.this.getMessage("messages.mute.player_muted_permanent", "&a\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0437\u0430\u043c\u0443\u0447\u0435\u043d \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430!").replace("{\u0438\u0433\u0440\u043e\u043a}", target.getName());
            sender.sendMessage(RiseChat.this.parseMessage(msg));
            String muteMsg = RiseChat.this.getMessage("messages.mute.muted_permanent", "&c\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b \u043d\u0430\u0432\u0441\u0435\u0433\u0434\u0430!");
            if (RiseChat.this.placeholderAPIEnabled) {
                muteMsg = PlaceholderAPI.setPlaceholders((Player)target, (String)muteMsg);
            }
            target.sendMessage(RiseChat.this.parseMessage(muteMsg));
            return true;
        }
    }

    public class TempMuteCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("risechat.mute")) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.no_permission", "&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!")));
                return true;
            }
            if (args.length < 2) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.mute.tempmute_usage", "&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /tempmute <\u0438\u0433\u0440\u043e\u043a> <\u0432\u0440\u0435\u043c\u044f> [\u043f\u0440\u0438\u0447\u0438\u043d\u0430]")));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.player_not_found", "&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!")));
                return true;
            }
            long duration = RiseChat.this.parseTimeString(args[1]);
            if (duration == 0L) {
                sender.sendMessage(RiseChat.this.parseMessage("&c\u041d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0432\u0440\u0435\u043c\u0435\u043d\u0438! \u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435: 1s, 1m, 1h, 1d"));
                return true;
            }
            long muteUntil = System.currentTimeMillis() + duration;
            RiseChat.this.mutedPlayers.put(target, muteUntil);
            String timeStr = RiseChat.this.formatTime(duration);
            String msg = RiseChat.this.getMessage("messages.mute.player_muted", "&a\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0437\u0430\u043c\u0443\u0447\u0435\u043d \u043d\u0430 {\u0432\u0440\u0435\u043c\u044f}!").replace("{\u0438\u0433\u0440\u043e\u043a}", target.getName()).replace("{\u0432\u0440\u0435\u043c\u044f}", timeStr);
            sender.sendMessage(RiseChat.this.parseMessage(msg));
            String muteMsg = RiseChat.this.getMessage("messages.mute.muted", "&c\u0412\u044b \u0437\u0430\u043c\u0443\u0447\u0435\u043d\u044b! \u0421\u0440\u043e\u043a \u043e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u044f: {\u0432\u0440\u0435\u043c\u044f}").replace("{\u0432\u0440\u0435\u043c\u044f}", timeStr);
            if (RiseChat.this.placeholderAPIEnabled) {
                muteMsg = PlaceholderAPI.setPlaceholders((Player)target, (String)muteMsg);
            }
            target.sendMessage(RiseChat.this.parseMessage(muteMsg));
            return true;
        }
    }

    public class UnmuteCommand
    implements CommandExecutor {
        public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
            if (!sender.hasPermission("risechat.mute")) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.no_permission", "&c\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b!")));
                return true;
            }
            if (args.length != 1) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.mute.unmute_usage", "&c\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435: /unmute <\u0438\u0433\u0440\u043e\u043a>")));
                return true;
            }
            Player target = Bukkit.getPlayer((String)args[0]);
            if (target == null || !target.isOnline()) {
                sender.sendMessage(RiseChat.this.parseMessage(RiseChat.this.getMessage("messages.errors.player_not_found", "&c\u0418\u0433\u0440\u043e\u043a \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d \u0438\u043b\u0438 \u043e\u0444\u0444\u043b\u0430\u0439\u043d!")));
                return true;
            }
            if (!RiseChat.this.isPlayerMuted(target)) {
                String msg = RiseChat.this.getMessage("messages.mute.not_muted", "&c\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u043d\u0435 \u0437\u0430\u043c\u0443\u0447\u0435\u043d!").replace("{\u0438\u0433\u0440\u043e\u043a}", target.getName());
                sender.sendMessage(RiseChat.this.parseMessage(msg));
                return true;
            }
            RiseChat.this.mutedPlayers.remove(target);
            String msg = RiseChat.this.getMessage("messages.mute.player_unmuted", "&a\u0418\u0433\u0440\u043e\u043a {\u0438\u0433\u0440\u043e\u043a} \u0440\u0430\u0437\u043c\u0443\u0447\u0435\u043d!").replace("{\u0438\u0433\u0440\u043e\u043a}", target.getName());
            sender.sendMessage(RiseChat.this.parseMessage(msg));
            String unmuteMsg = RiseChat.this.getMessage("messages.mute.player_unmuted", "&a\u0412\u044b \u0431\u044b\u043b\u0438 \u0440\u0430\u0437\u043c\u0443\u0447\u0435\u043d\u044b!");
            if (RiseChat.this.placeholderAPIEnabled) {
                unmuteMsg = PlaceholderAPI.setPlaceholders((Player)target, (String)unmuteMsg);
            }
            target.sendMessage(RiseChat.this.parseMessage(unmuteMsg));
            return true;
        }
    }
}

