/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.stonks.client;

import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.VillagerRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.renderstate.RegisterRenderStateModifiersEvent;

public class ClientHandler {
    public static final ModelLayerLocation STONKS_VILLAGER = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"stonks", (String)"villager"), "main");
    public static final ContextKey<Float> HEAD_HEIGHT = new ContextKey(ResourceLocation.fromNamespaceAndPath((String)"stonks", (String)"head_height"));

    public static void registerCustomRenderData(RegisterRenderStateModifiersEvent event) {
        event.registerEntityModifier(VillagerRenderer.class, (villager, renderState) -> {
            CompoundTag persistentData = villager.getPersistentData();
            ItemStack heldStack = villager.getMainHandItem();
            float headY = persistentData.getFloatOr("headY", 9.4f);
            if (heldStack.isEmpty()) {
                if (headY <= 9.4f) {
                    headY += 0.2f;
                }
            } else if (headY >= 0.0f) {
                headY -= 0.2f;
            }
            persistentData.putFloat("headY", headY);
            renderState.setRenderData(HEAD_HEIGHT, (Object)Float.valueOf(headY));
        });
    }

    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(STONKS_VILLAGER, () -> LayerDefinition.create((MeshDefinition)ClientHandler.createStonksMesh(), (int)64, (int)64));
    }

    private static MeshDefinition createStonksMesh() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        float f = 0.5f;
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.ZERO);
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(f)), PartPose.offset((float)0.0f, (float)0.1f, (float)0.0f));
        hat.addOrReplaceChild("hat_rim", CubeListBuilder.create().texOffs(30, 47).addBox(-8.0f, -9.0f, -7.0f, 16.0f, 16.0f, 1.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-6.0f, (float)-4.0f, (float)3.1416f, (float)0.0f, (float)0.0f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, 1.0f, -12.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(16, 20).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 12.0f, 6.0f), PartPose.ZERO);
        body.addOrReplaceChild("jacket", CubeListBuilder.create().texOffs(0, 38).addBox(-4.0f, 0.0f, -3.0f, 8.0f, 18.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.ZERO);
        partdefinition.addOrReplaceChild("arms", CubeListBuilder.create().texOffs(44, 22).addBox(-8.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f).texOffs(44, 22).addBox(4.0f, -2.0f, -2.0f, 4.0f, 8.0f, 4.0f, true).texOffs(40, 38).addBox(-4.0f, 2.0f, -2.0f, 8.0f, 4.0f, 4.0f), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)-1.0f, (float)-0.75f, (float)0.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 22).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 22).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        return meshdefinition;
    }
}

