/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore;

import java.util.function.Supplier;
import net.errordude42.sillywilliescore.block.custom.ModFlammableRotatedPillarBlock;
import net.errordude42.sillywilliescore.block.custom.ModPlantBlock;
import net.errordude42.sillywilliescore.block.custom.ModSaplingBlock;
import net.errordude42.sillywilliescore.block.custom.PlushZom;
import net.errordude42.sillywilliescore.block.sign.ModHangingSignBlock;
import net.errordude42.sillywilliescore.block.sign.ModStandingSignBlock;
import net.errordude42.sillywilliescore.block.sign.ModWallHangingSignBlock;
import net.errordude42.sillywilliescore.block.sign.ModWallSignBlock;
import net.errordude42.sillywilliescore.item.ModItems;
import net.errordude42.sillywilliescore.util.ModWoodTypes;
import net.errordude42.sillywilliescore.worldgen.tree.ModTreeGrowers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropExperienceBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"sillywilliescore");
    public static final DeferredBlock<Block> SILT = ModBlocks.registerBlock("silt", () -> new RotatedPillarBlock(BlockBehaviour.Properties.of().strength(1.0f).sound(SoundType.MUD).mapColor(MapColor.CLAY)));
    public static final DeferredBlock<Block> ENTANGULUM_ORE = ModBlocks.registerBlock("entangulumore", () -> new DropExperienceBlock((IntProvider)UniformInt.of((int)2, (int)4), BlockBehaviour.Properties.of().strength(6.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> GEOSTONE = ModBlocks.registerBlock("geostone", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> GEOSTONE_STAIRS = ModBlocks.registerBlock("geostone_stairs", () -> new StairBlock(((Block)GEOSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> GEOSTONE_COBBLE_STAIRS = ModBlocks.registerBlock("geostone_cobble_stairs", () -> new StairBlock(((Block)GEOSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SlabBlock> GEOSTONE_SLAB = ModBlocks.registerBlock("geostone_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SlabBlock> GEOSTONE_COBBLE_SLAB = ModBlocks.registerBlock("geostone_cobble_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<WallBlock> GEOSTONE_COBBLE_WALL = ModBlocks.registerBlock("geostone_cobble_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<PressurePlateBlock> GEOSTONE_PRESSURE_PLATE = ModBlocks.registerBlock("geostone_pressure_plate", () -> new PressurePlateBlock(BlockSetType.STONE, BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<ButtonBlock> GEOSTONE_BUTTON = ModBlocks.registerBlock("geostone_button", () -> new ButtonBlock(BlockSetType.STONE, 20, BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops().noCollission()));
    public static final DeferredBlock<Block> TRIANGULUMORE_DEEPSLATE = ModBlocks.registerBlock("triangulumore_deepslate", () -> new Block(BlockBehaviour.Properties.of().strength(6.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BLOCK_OF_RAW_TRIANGULUM = ModBlocks.registerBlock("block_of_raw_triangulum", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BLOCK_OF_RAW_ENTANGULUM = ModBlocks.registerBlock("block_of_raw_entangulum", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_PURPLE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> TRIANGULUM_BRICKS = ModBlocks.registerBlock("triangulum_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CHISLED_GEOSTONE = ModBlocks.registerBlock("chisled_geostone", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SMOOTH_GEOSTONE = ModBlocks.registerBlock("smooth_geostone", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> MOSSY_GEOSTONE_BRICKS = ModBlocks.registerBlock("mossy_geostone_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> GEOSTONE_BRICKS = ModBlocks.registerBlock("geostone_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRACKED_GEOSTONE_BRICKS = ModBlocks.registerBlock("cracked_geostone_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SlabBlock> SMOOTH_GEOSTONE_SLAB = ModBlocks.registerBlock("smooth_geostone_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> GEOSTONE_BRICKS_STAIRS = ModBlocks.registerBlock("geostone_bricks_stairs", () -> new StairBlock(((Block)GEOSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> MOSSY_GEOSTONE_BRICKS_STAIRS = ModBlocks.registerBlock("mossy_geostone_bricks_stairs", () -> new StairBlock(((Block)MOSSY_GEOSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SlabBlock> GEOSTONE_BRICKS_SLAB = ModBlocks.registerBlock("geostone_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SlabBlock> MOSSY_GEOSTONE_BRICKS_SLAB = ModBlocks.registerBlock("mossy_geostone_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<WallBlock> GEOSTONE_BRICKS_WALL = ModBlocks.registerBlock("geostone_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<WallBlock> MOSSY_GEOSTONE_BRICKS_WALL = ModBlocks.registerBlock("mossy_geostone_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<StairBlock> TRIANGULUM_BRICKS_STAIRS = ModBlocks.registerBlock("triangulum_bricks_stairs", () -> new StairBlock(((Block)TRIANGULUM_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()));
    public static final DeferredBlock<SlabBlock> TRIANGULUM_BRICKS_SLAB = ModBlocks.registerBlock("triangulum_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()));
    public static final DeferredBlock<PressurePlateBlock> TRIANGULUM_BRICKS_PRESSURE_PLATE = ModBlocks.registerBlock("triangulum_bricks_pressure_plate", () -> new PressurePlateBlock(BlockSetType.IRON, BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()));
    public static final DeferredBlock<ButtonBlock> TRIANGULUM_BRICKS_BUTTON = ModBlocks.registerBlock("triangulum_bricks_button", () -> new ButtonBlock(BlockSetType.IRON, 20, BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops().noCollission()));
    public static final DeferredBlock<WallBlock> TRIANGULUM_BRICKS_WALL = ModBlocks.registerBlock("triangulum_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.METAL).mapColor(MapColor.COLOR_YELLOW).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> GEOSTONE_COBBLE = ModBlocks.registerBlock("geostone_cobble", () -> new Block(BlockBehaviour.Properties.of().strength(3.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> WONDER_OAK_LOG = ModBlocks.registerBlock("wonder_oak_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LOG)));
    public static final DeferredBlock<Block> WONDER_OAK_WOOD = ModBlocks.registerBlock("wonder_oak_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WOOD)));
    public static final DeferredBlock<Block> STRIPPED_WONDER_OAK_LOG = ModBlocks.registerBlock("stripped_wonder_oak_log", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_LOG)));
    public static final DeferredBlock<Block> STRIPPED_WONDER_OAK_WOOD = ModBlocks.registerBlock("stripped_wonder_oak_wood", () -> new ModFlammableRotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STRIPPED_OAK_WOOD)));
    public static final DeferredBlock<Block> WONDER_OAK_PLANKS = ModBlocks.registerBlock("wonder_oak_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<Block> WONDER_OAK_SIGN = ModBlocks.registerBlockNoItem("wonder_oak_sign", () -> new ModStandingSignBlock(ModWoodTypes.WONDER_OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SIGN)));
    public static final DeferredBlock<Block> WONDER_OAK_WALL_SIGN = ModBlocks.registerBlockNoItem("wonder_oak_wall_sign", () -> new ModWallSignBlock(ModWoodTypes.WONDER_OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_SIGN)));
    public static final DeferredBlock<Block> WONDER_OAK_HANGING_SIGN = ModBlocks.registerBlockNoItem("wonder_oak_hanging_sign", () -> new ModHangingSignBlock(ModWoodTypes.WONDER_OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_HANGING_SIGN)));
    public static final DeferredBlock<Block> WONDER_OAK_WALL_HANGING_SIGN = ModBlocks.registerBlockNoItem("wonder_oak_wall_hanging_sign", () -> new ModWallHangingSignBlock(ModWoodTypes.WONDER_OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_WALL_HANGING_SIGN)));
    public static final DeferredBlock<TrapDoorBlock> WONDER_OAK_TRAPDOOR = ModBlocks.registerBlock("wonder_oak_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<DoorBlock> WONDER_OAK_DOOR = ModBlocks.registerBlock("wonder_oak_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<FenceGateBlock> WONDER_OAK_FENCE_GATE = ModBlocks.registerBlock("wonder_oak_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<FenceBlock> WONDER_OAK_FENCE = ModBlocks.registerBlock("wonder_oak_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<ButtonBlock> WONDER_OAK_BUTTON = ModBlocks.registerBlock("wonder_oak_button", () -> new ButtonBlock(BlockSetType.OAK, 20, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_BUTTON)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<PressurePlateBlock> WONDER_OAK_PRESSURE_PLATE = ModBlocks.registerBlock("wonder_oak_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<SlabBlock> WONDER_OAK_SLAB = ModBlocks.registerBlock("wonder_oak_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<StairBlock> WONDER_OAK_STAIRS = ModBlocks.registerBlock("wonder_oak_stairs", () -> new StairBlock(((Block)WONDER_OAK_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 20;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 5;
        }
    });
    public static final DeferredBlock<Block> WONDER_OAK_LEAVES = ModBlocks.registerBlock("wonder_oak_leaves", () -> new LeavesBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_LEAVES)){

        public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return true;
        }

        public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 60;
        }

        public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
            return 30;
        }
    });
    public static final DeferredBlock<Block> WONDER_OAK_SAPLING = ModBlocks.registerBlock("wonder_oak_wood_sapling", () -> new ModSaplingBlock(ModTreeGrowers.WONDER_OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SAPLING), (Supplier)SILT){

        @Override
        protected boolean mayPlaceOn(BlockState state, BlockGetter pLevel, BlockPos pPos) {
            if (state.getBlock().defaultBlockState() == ((Block)SILT.get()).defaultBlockState()) {
                return true;
            }
            return state.getBlock().defaultBlockState() == ((Block)SILT.get()).defaultBlockState();
        }
    });
    public static final DeferredBlock<Block> TWISTED_GRASS = ModBlocks.registerBlock("twisted_grass", () -> new ModPlantBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).noCollission().noOcclusion().instabreak().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).replaceable()){

        @Override
        protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
            Vec3 vec3 = state.getOffset(level, pos);
            VoxelShape shape = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
            return shape.move(vec3.x, vec3.y, vec3.z);
        }
    });
    public static final DeferredBlock<Block> GEOMETRIUS = ModBlocks.registerBlock("geometrius", () -> new ModPlantBlock(BlockBehaviour.Properties.of().sound(SoundType.GRASS).noCollission().noOcclusion().instabreak().offsetType(BlockBehaviour.OffsetType.XZ).pushReaction(PushReaction.DESTROY).mapColor(MapColor.COLOR_YELLOW)));
    public static final DeferredBlock<Block> TRIANGULUMORE_GEOSTONE = ModBlocks.registerBlockNoItem("triangulumore_geostone", () -> new Block(BlockBehaviour.Properties.of().strength(6.0f).sound(SoundType.DEEPSLATE).mapColor(MapColor.DEEPSLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> PLUSHZOM = ModBlocks.registerBlockNoItem("plushzom", () -> new PlushZom(BlockBehaviour.Properties.of().noCollission().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> PLUSHCRIT = ModBlocks.registerBlockNoItem("plushcrit", () -> new PlushZom(BlockBehaviour.Properties.of().noCollission().sound(SoundType.WOOL)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    private static <T extends Block> DeferredBlock<T> registerBlockNoItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

