/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore;

import com.mojang.logging.LogUtils;
import net.errordude42.sillywilliescore.Config;
import net.errordude42.sillywilliescore.ModBlockEntity;
import net.errordude42.sillywilliescore.ModBlocks;
import net.errordude42.sillywilliescore.ModEntities;
import net.errordude42.sillywilliescore.effect.ModEffects;
import net.errordude42.sillywilliescore.entity.boat.ModBoatRenderer;
import net.errordude42.sillywilliescore.item.ModCreativeModeTabs;
import net.errordude42.sillywilliescore.item.ModItems;
import net.errordude42.sillywilliescore.loot.ModLootModifiers;
import net.errordude42.sillywilliescore.util.ModWoodTypes;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="sillywilliescore")
public class SillyWilliesCore {
    public static final String MOD_ID = "sillywilliescore";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceKey<Level> GEO_KEY = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)SillyWilliesCore.rl("geo"));

    public static ResourceLocation rl(String s) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)s);
    }

    public SillyWilliesCore(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        NeoForge.EVENT_BUS.register((Object)this);
        ModLootModifiers.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModItems.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModBlockEntity.register(modEventBus);
        ModEntities.register(modEventBus);
        ModEffects.register(modEventBus);
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.INGREDIENTS) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @EventBusSubscriber(modid="sillywilliescore", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ClientModEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            Sheets.addWoodType((WoodType)ModWoodTypes.WONDER_OAK);
            EntityRenderers.register(ModEntities.MOD_BOAT.get(), context -> new ModBoatRenderer(context, false));
            EntityRenderers.register(ModEntities.MOD_CHEST_BOAT.get(), context -> new ModBoatRenderer(context, true));
        }
    }
}

