/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore.datagen;

import net.errordude42.sillywilliescore.ModBlocks;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class ModBlockStateProvider
extends BlockStateProvider {
    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "sillywilliescore", exFileHelper);
    }

    public String pName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation texture(String name) {
        return this.modLoc("block/" + name);
    }

    public ResourceLocation texture(String name, String location) {
        return this.modLoc("block/" + location + name);
    }

    public ResourceLocation texture(String name, String location, String suffix) {
        return this.modLoc("block/" + location + name + suffix);
    }

    protected void registerStatesAndModels() {
        this.blockWithItem(ModBlocks.SILT);
        this.blockWithItem(ModBlocks.TRIANGULUM_BRICKS);
        this.blockWithItem(ModBlocks.ENTANGULUM_ORE);
        this.blockWithItem(ModBlocks.GEOSTONE);
        this.blockWithItem(ModBlocks.GEOSTONE_COBBLE);
        this.blockWithItem(ModBlocks.BLOCK_OF_RAW_ENTANGULUM);
        this.blockWithItem(ModBlocks.BLOCK_OF_RAW_TRIANGULUM);
        this.blockWithItem(ModBlocks.CRACKED_GEOSTONE_BRICKS);
        this.blockWithItem(ModBlocks.GEOSTONE_BRICKS);
        this.blockWithItem(ModBlocks.MOSSY_GEOSTONE_BRICKS);
        this.blockWithItem(ModBlocks.WONDER_OAK_PLANKS);
        this.blockWithItem(ModBlocks.TRIANGULUMORE_GEOSTONE);
        this.pillarBlock(ModBlocks.CHISLED_GEOSTONE, "chisled_geostone");
        this.pillarBlock(ModBlocks.TRIANGULUMORE_DEEPSLATE, "triangulumore_deepslate");
        this.smoothDifferentTexture(ModBlocks.SMOOTH_GEOSTONE, "smooth_geostone", "chisled_geostone_top");
        this.stairsBlock((StairBlock)ModBlocks.TRIANGULUM_BRICKS_STAIRS.get(), this.blockTexture((Block)ModBlocks.TRIANGULUM_BRICKS.get()));
        this.stairsBlock((StairBlock)ModBlocks.GEOSTONE_STAIRS.get(), this.blockTexture((Block)ModBlocks.GEOSTONE.get()));
        this.stairsBlock((StairBlock)ModBlocks.MOSSY_GEOSTONE_BRICKS_STAIRS.get(), this.blockTexture((Block)ModBlocks.MOSSY_GEOSTONE_BRICKS.get()));
        this.stairsBlock((StairBlock)ModBlocks.GEOSTONE_BRICKS_STAIRS.get(), this.blockTexture((Block)ModBlocks.GEOSTONE_BRICKS.get()));
        this.stairsBlock((StairBlock)ModBlocks.GEOSTONE_COBBLE_STAIRS.get(), this.blockTexture((Block)ModBlocks.GEOSTONE_COBBLE.get()));
        this.stairsBlock((StairBlock)ModBlocks.WONDER_OAK_STAIRS.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.TRIANGULUM_BRICKS_SLAB.get(), this.blockTexture((Block)ModBlocks.TRIANGULUM_BRICKS.get()), this.blockTexture((Block)ModBlocks.TRIANGULUM_BRICKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.MOSSY_GEOSTONE_BRICKS_SLAB.get(), this.blockTexture((Block)ModBlocks.MOSSY_GEOSTONE_BRICKS.get()), this.blockTexture((Block)ModBlocks.MOSSY_GEOSTONE_BRICKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.GEOSTONE_BRICKS_SLAB.get(), this.blockTexture((Block)ModBlocks.GEOSTONE_BRICKS.get()), this.blockTexture((Block)ModBlocks.GEOSTONE_BRICKS.get()));
        this.slabBlock((SlabBlock)ModBlocks.SMOOTH_GEOSTONE_SLAB.get(), this.blockTexture(((Block)ModBlocks.SMOOTH_GEOSTONE.get()).defaultBlockState().getBlock()), this.blockTexture(((Block)ModBlocks.SMOOTH_GEOSTONE.get()).defaultBlockState().getBlock()));
        this.slabBlock((SlabBlock)ModBlocks.GEOSTONE_SLAB.get(), this.blockTexture((Block)ModBlocks.GEOSTONE.get()), this.blockTexture((Block)ModBlocks.GEOSTONE.get()));
        this.slabBlock((SlabBlock)ModBlocks.GEOSTONE_COBBLE_SLAB.get(), this.blockTexture((Block)ModBlocks.GEOSTONE_COBBLE.get()), this.blockTexture((Block)ModBlocks.GEOSTONE_COBBLE.get()));
        this.slabBlock((SlabBlock)ModBlocks.WONDER_OAK_SLAB.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.GEOSTONE_BUTTON.get(), this.blockTexture((Block)ModBlocks.GEOSTONE.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.TRIANGULUM_BRICKS_BUTTON.get(), this.blockTexture((Block)ModBlocks.TRIANGULUM_BRICKS.get()));
        this.buttonBlock((ButtonBlock)ModBlocks.WONDER_OAK_BUTTON.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.TRIANGULUM_BRICKS_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.TRIANGULUM_BRICKS.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.GEOSTONE_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.GEOSTONE.get()));
        this.pressurePlateBlock((PressurePlateBlock)ModBlocks.WONDER_OAK_PRESSURE_PLATE.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.wallBlock((WallBlock)ModBlocks.TRIANGULUM_BRICKS_WALL.get(), this.blockTexture((Block)ModBlocks.TRIANGULUM_BRICKS.get()));
        this.wallBlock((WallBlock)ModBlocks.GEOSTONE_COBBLE_WALL.get(), this.blockTexture((Block)ModBlocks.GEOSTONE_COBBLE.get()));
        this.wallBlock((WallBlock)ModBlocks.MOSSY_GEOSTONE_BRICKS_WALL.get(), this.blockTexture((Block)ModBlocks.MOSSY_GEOSTONE_BRICKS.get()));
        this.wallBlock((WallBlock)ModBlocks.GEOSTONE_BRICKS_WALL.get(), this.blockTexture((Block)ModBlocks.GEOSTONE_BRICKS.get()));
        this.blockItem(ModBlocks.TRIANGULUM_BRICKS_SLAB);
        this.blockItem(ModBlocks.GEOSTONE_SLAB);
        this.blockItem(ModBlocks.GEOSTONE_BRICKS_SLAB);
        this.blockItem(ModBlocks.MOSSY_GEOSTONE_BRICKS_SLAB);
        this.blockItem(ModBlocks.SMOOTH_GEOSTONE_SLAB);
        this.blockItem(ModBlocks.GEOSTONE_COBBLE_SLAB);
        this.blockItem(ModBlocks.TRIANGULUM_BRICKS_STAIRS);
        this.blockItem(ModBlocks.GEOSTONE_STAIRS);
        this.blockItem(ModBlocks.GEOSTONE_BRICKS_STAIRS);
        this.blockItem(ModBlocks.MOSSY_GEOSTONE_BRICKS_STAIRS);
        this.blockItem(ModBlocks.GEOSTONE_COBBLE_STAIRS);
        this.blockItem(ModBlocks.GEOSTONE_PRESSURE_PLATE);
        this.blockItem(ModBlocks.TRIANGULUM_BRICKS_PRESSURE_PLATE);
        this.blockItem(ModBlocks.WONDER_OAK_SLAB);
        this.blockItem(ModBlocks.WONDER_OAK_STAIRS);
        this.blockItem(ModBlocks.WONDER_OAK_PRESSURE_PLATE);
        this.fenceBlock((FenceBlock)ModBlocks.WONDER_OAK_FENCE.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.fenceGateBlock((FenceGateBlock)ModBlocks.WONDER_OAK_FENCE_GATE.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.WONDER_OAK_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.WONDER_OAK_WOOD.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_LOG.get()), this.blockTexture((Block)ModBlocks.WONDER_OAK_LOG.get()));
        this.logBlock((RotatedPillarBlock)ModBlocks.STRIPPED_WONDER_OAK_LOG.get());
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRIPPED_WONDER_OAK_WOOD.get(), this.blockTexture((Block)ModBlocks.STRIPPED_WONDER_OAK_LOG.get()), this.blockTexture((Block)ModBlocks.STRIPPED_WONDER_OAK_LOG.get()));
        this.blockItem(ModBlocks.WONDER_OAK_LOG);
        this.blockItem(ModBlocks.WONDER_OAK_WOOD);
        this.blockItem(ModBlocks.STRIPPED_WONDER_OAK_LOG);
        this.blockItem(ModBlocks.STRIPPED_WONDER_OAK_WOOD);
        this.blockItem(ModBlocks.WONDER_OAK_FENCE_GATE);
        this.blockItem(ModBlocks.WONDER_OAK_TRAPDOOR, "_bottom");
        this.signBlock((Block)ModBlocks.WONDER_OAK_SIGN.get(), (Block)ModBlocks.WONDER_OAK_WALL_SIGN.get(), this.blockTexture((Block)ModBlocks.WONDER_OAK_PLANKS.get()));
        this.hangingSignBlock((Block)ModBlocks.WONDER_OAK_HANGING_SIGN.get(), (Block)ModBlocks.WONDER_OAK_WALL_HANGING_SIGN.get(), this.blockTexture((Block)ModBlocks.STRIPPED_WONDER_OAK_LOG.get()));
        this.leavesBlock(ModBlocks.WONDER_OAK_LEAVES);
        this.saplingBlock(ModBlocks.WONDER_OAK_SAPLING);
        this.saplingBlock(ModBlocks.TWISTED_GRASS);
        this.saplingBlock(ModBlocks.GEOMETRIUS);
        this.doorBlockWithRenderType((DoorBlock)ModBlocks.WONDER_OAK_DOOR.get(), this.modLoc("block/wonder_oak_door_bottom"), this.modLoc("block/wonder_oak_door_top"), "cutout");
        this.trapdoorBlockWithRenderType((TrapDoorBlock)ModBlocks.WONDER_OAK_TRAPDOOR.get(), this.modLoc("block/wonder_oak_trapdoor"), true, "cutout");
    }

    private void saplingBlock(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(BuiltInRegistries.BLOCK.getKey((Object)((Block)blockRegistryObject.get())).getPath(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void leavesBlock(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().singleTexture(BuiltInRegistries.BLOCK.getKey((Object)((Block)blockRegistryObject.get())).getPath(), ResourceLocation.parse((String)"minecraft:block/leaves"), "all", this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    private void smoothDifferentTexture(DeferredBlock<?> deferredBlock, String name, String textureName) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)this.models().cubeAll(name, ResourceLocation.parse((String)("sillywilliescore:block/" + textureName))));
    }

    private void pillarBlock(DeferredBlock<?> deferredBlock, String name) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), (ModelFile)this.models().cubeColumn(name, ResourceLocation.parse((String)("sillywilliescore:block/" + deferredBlock.getId().getPath() + "_side")), ResourceLocation.parse((String)("sillywilliescore:block/" + deferredBlock.getId().getPath() + "_top"))));
    }

    private void blockWithItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockWithItem((Block)deferredBlock.get(), this.cubeAll((Block)deferredBlock.get()));
    }

    private void blockItem(DeferredBlock<?> deferredBlock) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("sillywilliescore:block/" + deferredBlock.getId().getPath()));
    }

    private void blockItem(DeferredBlock<?> deferredBlock, String appendix) {
        this.simpleBlockItem((Block)deferredBlock.get(), (ModelFile)new ModelFile.UncheckedModelFile("sillywilliescore:block/" + deferredBlock.getId().getPath() + appendix));
    }

    public void hangingSignBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.pName(signBlock), texture);
        this.simpleBlock(signBlock, (ModelFile)sign);
        this.simpleBlock(wallSignBlock, (ModelFile)sign);
    }

    private void signBlock(Block signBlock, Block wallSignBlock, ModelFile sign) {
        this.simpleBlock(signBlock, sign);
        this.simpleBlock(wallSignBlock, sign);
    }

    private void signBlock(Block signBlock, Block wallSignBlock, ResourceLocation texture) {
        ModelBuilder sign = this.models().sign(this.pName(signBlock), texture);
        this.signBlock(signBlock, wallSignBlock, (ModelFile)sign);
    }
}

