/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore.datagen;

import java.util.LinkedHashMap;
import net.errordude42.sillywilliescore.ModBlocks;
import net.errordude42.sillywilliescore.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimMaterials;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;

public class ModItemModelProvider
extends ItemModelProvider {
    private static LinkedHashMap<ResourceKey<TrimMaterial>, Float> trimMaterials = new LinkedHashMap();

    private void trimmedArmorItem(DeferredItem<ArmorItem> itemDeferredItem) {
        String MOD_ID = "sillywilliescore";
        Object object = itemDeferredItem.get();
        if (object instanceof ArmorItem) {
            ArmorItem armorItem = (ArmorItem)object;
            trimMaterials.forEach((trimMaterial, value) -> {
                float trimValue = value.floatValue();
                String armorType = "";
                if (armorItem.toString().contains("helmet")) {
                    armorType = "helmet";
                } else if (armorItem.toString().contains("chestplate")) {
                    armorType = "chestplate";
                } else if (armorItem.toString().contains("leggings")) {
                    armorType = "leggings";
                } else if (armorItem.toString().contains("boots")) {
                    armorType = "boots";
                }
                String armorItemPath = armorItem.toString();
                String trimPath = "trims/items/" + armorType + "_trim_" + trimMaterial.location().getPath();
                String currentTrimName = armorItemPath + "_" + trimMaterial.location().getPath() + "_trim";
                ResourceLocation armorItemResLoc = ResourceLocation.parse((String)armorItemPath);
                ResourceLocation trimResLoc = ResourceLocation.parse((String)trimPath);
                ResourceLocation trimNameResLoc = ResourceLocation.parse((String)currentTrimName);
                this.existingFileHelper.trackGenerated(trimResLoc, PackType.CLIENT_RESOURCES, ".png", "textures");
                ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(currentTrimName)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", armorItemResLoc.getNamespace() + ":item/" + armorItemResLoc.getPath())).texture("layer1", trimResLoc);
                ((ItemModelBuilder)this.withExistingParent(itemDeferredItem.getId().getPath(), this.mcLoc("item/generated"))).override().model((ModelFile)new ModelFile.UncheckedModelFile(trimNameResLoc.getNamespace() + ":item/" + trimNameResLoc.getPath())).predicate(this.mcLoc("trim_type"), trimValue).end().texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("item/" + itemDeferredItem.getId().getPath())));
            });
        }
    }

    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "sillywilliescore", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ModItems.RAW_ENTANGULUM.get());
        this.basicItem((Item)ModItems.TRIANGULUM_PLATE.get());
        this.basicItem((Item)ModItems.TRIANGULUM_RAW.get());
        this.basicItem((Item)ModItems.TRIANGULUM.get());
        this.basicItem((Item)ModItems.TRIANGULUM_BRICK.get());
        this.basicItem((Item)ModItems.TRIANGULUM_UPGRADE_TEMPLATE.get());
        this.basicItem((Item)ModItems.INCOMPLETE_TRIANGULUM.get());
        this.basicItem((Item)ModItems.PLATE_MOLD.get());
        this.basicItem((Item)ModItems.ENTANGULUM_DUST.get());
        this.basicItem((Item)ModItems.DIRTY_ENTANGULUM_DUST.get());
        this.basicItem((Item)ModItems.ENTANGULUM_SPOOL.get());
        this.basicItem((Item)ModItems.ENTANGULUM_MASTERWORK_SMITHING_TEMPLATE.get());
        this.basicItem((Item)ModItems.ENTANGULUM_STRING.get());
        this.basicItem((Item)ModItems.EMPTY_SPOOL.get());
        this.basicItem((Item)ModItems.ENTANGULUM_PLATE.get());
        this.basicItem((Item)ModItems.ENTANGULUM_DUSTED_MOLD.get());
        this.basicItem(ModBlocks.WONDER_OAK_DOOR.asItem());
        this.handheldItem(ModItems.TRIANGULUM_SWORD);
        this.handheldItem(ModItems.TRIANGULUM_SHOVEL);
        this.handheldItem(ModItems.TRIANGULUM_AXE);
        this.handheldItem(ModItems.TRIANGULUM_HOE);
        this.handheldItem(ModItems.TRIANGULUM_PICKAXE);
        this.buttonItem(ModBlocks.TRIANGULUM_BRICKS_BUTTON, ModBlocks.TRIANGULUM_BRICKS);
        this.buttonItem(ModBlocks.GEOSTONE_BUTTON, ModBlocks.GEOSTONE);
        this.buttonItem(ModBlocks.WONDER_OAK_BUTTON, ModBlocks.WONDER_OAK_PLANKS);
        this.fenceItem(ModBlocks.WONDER_OAK_FENCE, ModBlocks.WONDER_OAK_PLANKS);
        this.wallItem(ModBlocks.TRIANGULUM_BRICKS_WALL, ModBlocks.TRIANGULUM_BRICKS);
        this.wallItem(ModBlocks.GEOSTONE_COBBLE_WALL, ModBlocks.GEOSTONE_COBBLE);
        this.wallItem(ModBlocks.GEOSTONE_BRICKS_WALL, ModBlocks.GEOSTONE_BRICKS);
        this.wallItem(ModBlocks.MOSSY_GEOSTONE_BRICKS_WALL, ModBlocks.MOSSY_GEOSTONE_BRICKS);
        this.saplingItem(ModBlocks.WONDER_OAK_SAPLING);
        this.saplingItem(ModBlocks.TWISTED_GRASS);
        this.saplingItem(ModBlocks.GEOMETRIUS);
        this.differentItemTexture(ModBlocks.WONDER_OAK_SIGN);
        this.differentItemTexture(ModBlocks.WONDER_OAK_HANGING_SIGN);
        this.differentItemTexture(ModItems.WONDER_OAK_BOAT);
        this.differentItemTexture(ModItems.WONDER_OAK_CHEST_BOAT);
    }

    private ItemModelBuilder saplingItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("block/" + item.getId().getPath())));
    }

    private ItemModelBuilder differentItemTexture(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("item/" + item.getId().getPath() + "_item")));
    }

    private ItemModelBuilder differentItemTexture(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("item/" + item.getId().getPath() + "_item")));
    }

    public void buttonItem(DeferredBlock<?> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void fenceItem(DeferredBlock<?> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void wallItem(DeferredBlock<?> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("block/" + baseBlock.getId().getPath())));
    }

    public ItemModelBuilder simpleBlockItem(ResourceLocation block) {
        return (ItemModelBuilder)this.withExistingParent(block.toString(), ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("block/" + block.getPath())));
    }

    private ItemModelBuilder handheldItem(DeferredItem<?> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/handheld"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)("item/" + item.getId().getPath())));
    }

    static {
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.QUARTZ, Float.valueOf(0.1f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.IRON, Float.valueOf(0.2f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.NETHERITE, Float.valueOf(0.3f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.REDSTONE, Float.valueOf(0.4f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.COPPER, Float.valueOf(0.5f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.GOLD, Float.valueOf(0.6f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.EMERALD, Float.valueOf(0.7f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.DIAMOND, Float.valueOf(0.8f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.LAPIS, Float.valueOf(0.9f));
        trimMaterials.put((ResourceKey<TrimMaterial>)TrimMaterials.AMETHYST, Float.valueOf(1.0f));
    }
}

