/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore.entity.boat;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.errordude42.sillywilliescore.SillyWilliesCore;
import net.errordude42.sillywilliescore.entity.boat.ModBoatEntity;
import net.errordude42.sillywilliescore.entity.boat.ModChestBoatEntity;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;

public class ModBoatRenderer
extends BoatRenderer {
    private final Map<ModBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(ModBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)SillyWilliesCore.rl(ModBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (ModBoatEntity.Type)((Object)type), pChestBoat))));

    public ModBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(ModBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context context, ModBoatEntity.Type type, boolean chestBoat) {
        ResourceLocation location = SillyWilliesCore.rl(type.getName());
        ModelLayerLocation modellayerlocation = chestBoat ? new ModelLayerLocation(location.withPrefix("chest_boat/"), "main") : new ModelLayerLocation(location.withPrefix("boat/"), "main");
        ModelPart modelpart = context.bakeLayer(modellayerlocation);
        return chestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(Boat boat) {
        if (boat instanceof ModBoatEntity) {
            ModBoatEntity modBoat = (ModBoatEntity)boat;
            return this.boatResources.get((Object)modBoat.getModVariant());
        }
        if (boat instanceof ModChestBoatEntity) {
            ModChestBoatEntity modChestBoatEntity = (ModChestBoatEntity)boat;
            return this.boatResources.get((Object)modChestBoatEntity.getModVariant());
        }
        return null;
    }
}

