/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore.worldgen;

import java.util.List;
import net.errordude42.sillywilliescore.ModBlocks;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_TRIANGULUM_ORE_KEY = ModConfiguredFeatures.registerKey("triangulum_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEO_TRIANGULUM_ORE_KEY = ModConfiguredFeatures.registerKey("geo_triangulum_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> TWISTED_GRASS_KEY = ModConfiguredFeatures.registerKey("twisted_grass");
    public static final ResourceKey<ConfiguredFeature<?, ?>> GEOMETRIUS_KEY = ModConfiguredFeatures.registerKey("geometrius");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WONDER_OAK_KEY = ModConfiguredFeatures.registerKey("wonder_oak");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        BlockMatchTest netherrackReplaceables = new BlockMatchTest(Blocks.NETHERRACK);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.END_STONE);
        BlockMatchTest geostoneReplacables = new BlockMatchTest((Block)ModBlocks.GEOSTONE.get());
        List<OreConfiguration.TargetBlockState> overworldTriangulumOres = List.of(OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.TRIANGULUMORE_DEEPSLATE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_TRIANGULUM_ORE_KEY, Feature.ORE, new OreConfiguration(overworldTriangulumOres, 9));
        ModConfiguredFeatures.register(context, GEO_TRIANGULUM_ORE_KEY, Feature.ORE, new OreConfiguration((RuleTest)geostoneReplacables, ((Block)ModBlocks.TRIANGULUMORE_GEOSTONE.get()).defaultBlockState(), 14));
        ModConfiguredFeatures.register(context, TWISTED_GRASS_KEY, Feature.RANDOM_PATCH, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.TWISTED_GRASS.get())), 64));
        ModConfiguredFeatures.register(context, GEOMETRIUS_KEY, Feature.FLOWER, ModConfiguredFeatures.grassPatch((BlockStateProvider)BlockStateProvider.simple((Block)((Block)ModBlocks.GEOMETRIUS.get())), 64));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)name));
    }

    private static RandomPatchConfiguration grassPatch(BlockStateProvider stateProvider, int tries) {
        return FeatureUtils.simpleRandomPatchConfiguration((int)tries, (Holder)PlacementUtils.onlyWhenEmpty((Feature)Feature.SIMPLE_BLOCK, (FeatureConfiguration)new SimpleBlockConfiguration(stateProvider)));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

