/*
 * Decompiled with CFR 0.152.
 */
package net.errordude42.sillywilliescore.worldgen;

import java.util.List;
import net.errordude42.sillywilliescore.ModBlocks;
import net.errordude42.sillywilliescore.worldgen.ModConfiguredFeatures;
import net.errordude42.sillywilliescore.worldgen.ModOrePlacement;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> TRIANGULUM_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("triangulum_ore_placed");
    public static final ResourceKey<PlacedFeature> GEO_TRIANGULUM_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("geo_triangulum_ore_placed");
    public static final ResourceKey<PlacedFeature> WONDER_OAK_PLACED_KEY = ModPlacedFeatures.registerKey("wonder_oak_placed");
    public static final ResourceKey<PlacedFeature> TWISTED_GRASS_PLACED_KEY = ModPlacedFeatures.registerKey("twisted_grass_placed.json");
    public static final ResourceKey<PlacedFeature> GEOMETRIUS_PLACED_KEY = ModPlacedFeatures.registerKey("geometrius_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, TRIANGULUM_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_TRIANGULUM_ORE_KEY), ModOrePlacement.rareOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)-20))));
        ModPlacedFeatures.register(context, GEO_TRIANGULUM_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.GEO_TRIANGULUM_ORE_KEY), ModOrePlacement.commonOrePlacement(12, (PlacementModifier)HeightRangePlacement.triangle((VerticalAnchor)VerticalAnchor.absolute((int)-64), (VerticalAnchor)VerticalAnchor.absolute((int)160))));
        ModPlacedFeatures.register(context, TWISTED_GRASS_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.TWISTED_GRASS_KEY), List.of(NoiseThresholdCountPlacement.of((double)-0.8, (int)5, (int)10), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP_WORLD_SURFACE, BiomeFilter.biome()));
        ModPlacedFeatures.register(context, WONDER_OAK_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.WONDER_OAK_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)7, (float)0.2f, (int)6), (Block)((Block)ModBlocks.WONDER_OAK_SAPLING.get())));
        PlacementUtils.register(context, GEOMETRIUS_PLACED_KEY, (Holder)configuredFeatures.getOrThrow(ModConfiguredFeatures.GEOMETRIUS_KEY), (PlacementModifier[])new PlacementModifier[]{RarityFilter.onAverageOnceEvery((int)32), InSquarePlacement.spread(), PlacementUtils.HEIGHTMAP, BiomeFilter.biome()});
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"sillywilliescore", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

