/*
 * Decompiled with CFR 0.152.
 */
package com.minecraft.wellrested;

import com.minecraft.wellrested.commands.ReloadCommand;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class WellRested
extends JavaPlugin
implements Listener {
    private int saturationDuration;
    private int saturationAmplifier;
    private String wellRestedMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("wellrested").setExecutor((CommandExecutor)new ReloadCommand(this));
        this.getLogger().info("WellRested plugin has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("WellRested plugin has been disabled!");
    }

    public void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.saturationDuration = config.getInt("saturation.duration", 60);
        this.saturationAmplifier = config.getInt("saturation.amplifier", 1);
        this.wellRestedMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("messages.well-rested", "&aYou got a very good sleep, and now you're well rested!"));
    }

    @EventHandler
    public void onPlayerWakeUp(PlayerBedLeaveEvent event) {
        Player player = event.getPlayer();
        long worldTime = player.getWorld().getTime();
        if (worldTime >= 0L && worldTime <= 1000L) {
            player.addPotionEffect(new PotionEffect(PotionEffectType.SATURATION, this.saturationDuration * 20, this.saturationAmplifier));
            player.sendMessage(this.wellRestedMessage);
        }
    }
}

