/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.mixin.mixins;

import java.util.function.Supplier;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.storage.WritableLevelData;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFSoundContext;

@Mixin(value={ClientLevel.class})
public abstract class MixinClientLevel
extends Level {
    @Shadow
    @NotNull
    protected abstract LevelEntityGetter<Entity> getEntities();

    protected MixinClientLevel(WritableLevelData writableLevelData, ResourceKey<Level> resourceKey, RegistryAccess registryAccess, Holder<DimensionType> holder, Supplier<ProfilerFiller> supplier, boolean bl, boolean bl2, long l, int i) {
        super(writableLevelData, resourceKey, registryAccess, holder, supplier, bl, bl2, l, i);
    }

    @Inject(method={"playSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZJ)V"}, at={@At(value="HEAD")})
    private void esf$discoverEntity(double x, double y, double z, SoundEvent soundEvent, SoundSource soundSource, float g, float h, boolean bl, long l, CallbackInfo ci) {
        ESFSoundContext.entitySource = null;
        if (ESFSoundContext.shouldCaptureEntity(soundEvent.getLocation())) {
            ESFSoundContext.searchForEntity(this.getEntities().getAll(), x, y, z);
            if (ESFSoundContext.entitySource == null) {
                ESFSoundContext.searchForBlockEntity(this, x, y, z);
            }
        }
        if (((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds.all()) {
            ESF.log("found entity at " + ESFSoundContext.entitySource.blockPos().toShortString() + ", for sound at " + x + ", " + y + ", " + z);
        }
    }

    @Inject(method={"playSound(DDDLnet/minecraft/sounds/SoundEvent;Lnet/minecraft/sounds/SoundSource;FFZJ)V"}, at={@At(value="TAIL")})
    private void esf$clearEntity(CallbackInfo ci) {
        ESFSoundContext.entitySource = null;
    }
}

