/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.MultipliedFloats;
import net.minecraft.util.valueproviders.SampledFloat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFSound;
import traben.entity_sound_features.ESFSoundContext;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.state.ETFEntityRenderState;

public class ESFVariantSupplier {
    private static final TypeToken<SoundEventRegistration> SOUND_EVENT_REGISTRATION_TYPE = new TypeToken<SoundEventRegistration>(){};
    private final RandomSource random = RandomSource.m_216327_();
    protected Int2ObjectArrayMap<WeighedSoundEvents> variantSounds;
    protected ETFApi.ETFVariantSuffixProvider variator;
    protected ResourceLocation location;

    protected ESFVariantSupplier(ResourceLocation location, ETFApi.ETFVariantSuffixProvider variator, Int2ObjectArrayMap<WeighedSoundEvents> variantSounds) {
        if (variantSounds.isEmpty()) {
            throw new IllegalArgumentException("ESFVariantSupplier: Variant sounds cannot be empty");
        }
        this.variantSounds = Objects.requireNonNull(variantSounds);
        this.variator = Objects.requireNonNull(variator);
        this.location = Objects.requireNonNull(location);
        if (variator instanceof PropertiesRandomProvider) {
            PropertiesRandomProvider propeties = (PropertiesRandomProvider)variator;
            propeties.setOnMeetsRuleHook((entity, rule) -> {
                if (rule == null) {
                    ESFSoundContext.lastRuleMet.removeInt((Object)entity.uuid());
                } else {
                    ESFSoundContext.lastRuleMet.put(entity.uuid(), rule.ruleNumber);
                }
            });
        }
        ESFSoundContext.addKnownESFSound(location);
    }

    @Nullable
    public static ESFVariantSupplier getOrNull(ResourceLocation soundEventResource) {
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        try {
            String propertiesPath = soundEventResource.m_135827_() + ":esf/" + soundEventResource.m_135815_().replaceAll("\\.", "/") + ".properties";
            if (ResourceLocation.m_135830_((String)propertiesPath)) {
                ResourceLocation properties = ESF.res(propertiesPath);
                ETFApi.ETFVariantSuffixProvider variator = ETFApi.getVariantSupplierOrNull((ResourceLocation)properties, (ResourceLocation)ESF.res(propertiesPath.replaceAll("\\.properties$", ".json")), (String[])new String[]{"sounds", "sound"});
                if (variator != null) {
                    if (log) {
                        ESF.log(propertiesPath + " ESF sound properties found for: " + soundEventResource);
                    }
                    if (log) {
                        ESF.log("suffixes: " + variator.getAllSuffixes());
                    }
                    IntOpenHashSet suffixes = variator.getAllSuffixes();
                    suffixes.removeIf(k -> k == 1);
                    suffixes.removeIf(k -> k == 0);
                    if (!suffixes.isEmpty()) {
                        Int2ObjectArrayMap variantSounds = new Int2ObjectArrayMap();
                        String soundPrefix = propertiesPath.replaceAll("\\.properties$", "");
                        IntIterator intIterator = suffixes.iterator();
                        while (intIterator.hasNext()) {
                            int suffix = (Integer)intIterator.next();
                            ResourceLocation soundLocation = ESF.res(soundPrefix + suffix + ".json");
                            Optional soundResource = Minecraft.m_91087_().m_91098_().m_213713_(soundLocation);
                            if (soundResource.isPresent()) {
                                if (log) {
                                    ESF.log(propertiesPath + " adding variants from json: " + soundLocation);
                                }
                                ESFVariantSupplier.parseSoundEventVariant(soundLocation, (Resource)soundResource.get(), (Int2ObjectArrayMap<WeighedSoundEvents>)variantSounds, suffix);
                                continue;
                            }
                            ResourceLocation ogg = ESF.res(soundLocation.m_135827_(), soundLocation.m_135815_().replaceAll("\\.json$", ".ogg"));
                            if (Minecraft.m_91087_().m_91098_().m_213713_(ogg).isPresent()) {
                                WeighedSoundEvents event = new WeighedSoundEvents(null, null);
                                event.m_120451_((Weighted)new ESFSound(ogg));
                                variantSounds.put(suffix, (Object)event);
                                if (!log) continue;
                                ESF.log(propertiesPath + " added variant: " + ogg);
                                continue;
                            }
                            if (!log) continue;
                            ESF.log(propertiesPath + " invalid variants: " + soundLocation + " or " + ogg);
                        }
                        if (!variantSounds.isEmpty()) {
                            return new ESFVariantSupplier(soundEventResource, variator, (Int2ObjectArrayMap<WeighedSoundEvents>)variantSounds);
                        }
                    }
                }
            } else {
                ESF.logWarn(propertiesPath + " was invalid sound properties id");
            }
        }
        catch (Exception e) {
            ESF.logError(e.getMessage());
        }
        return null;
    }

    private static void parseSoundEventVariant(ResourceLocation soundJson, Resource jsonResource, Int2ObjectArrayMap<WeighedSoundEvents> soundMap, int suffix) {
        try {
            SoundEventRegistration map = (SoundEventRegistration)GsonHelper.m_13767_((Gson)SoundManager.f_120346_, (Reader)jsonResource.m_215508_(), SOUND_EVENT_REGISTRATION_TYPE);
            WeighedSoundEvents weighedSoundEvents = new WeighedSoundEvents(null, map.m_119824_());
            for (final Sound sound : map.m_119822_()) {
                final ResourceLocation resourceLocation2 = sound.m_119787_();
                weighedSoundEvents.m_120451_((Weighted)(switch (sound.m_119795_()) {
                    case Sound.Type.FILE -> {
                        ResourceLocation ogg = ESF.res(soundJson.m_135827_(), "esf/" + sound.m_119787_().m_135815_() + ".ogg");
                        if (Minecraft.m_91087_().m_91098_().m_213713_(ogg).isPresent()) {
                            yield new ESFSound(ogg, sound);
                        }
                        if (Minecraft.m_91087_().m_91098_().m_213713_(sound.m_119790_()).isPresent()) {
                            yield sound;
                        }
                    }
                    case Sound.Type.SOUND_EVENT -> new Weighted<Sound>(){

                        public int m_7789_() {
                            WeighedSoundEvents weighedSoundEvents = Minecraft.m_91087_().m_91106_().m_120384_(resourceLocation2);
                            return weighedSoundEvents == null ? 0 : weighedSoundEvents.m_7789_();
                        }

                        @NotNull
                        public Sound getSound(RandomSource randomSource) {
                            WeighedSoundEvents weighedSoundEvents = Minecraft.m_91087_().m_91106_().m_120384_(resourceLocation2);
                            if (weighedSoundEvents == null) {
                                return SoundManager.f_120344_;
                            }
                            Sound soundx = weighedSoundEvents.m_213718_(randomSource);
                            return new Sound(soundx.m_119787_().toString(), (SampledFloat)new MultipliedFloats(new SampledFloat[]{soundx.m_235146_(), sound.m_235146_()}), (SampledFloat)new MultipliedFloats(new SampledFloat[]{soundx.m_235147_(), sound.m_235147_()}), sound.m_7789_(), Sound.Type.FILE, soundx.m_119796_() || sound.m_119796_(), soundx.m_119797_(), soundx.m_119798_());
                        }

                        public void m_8054_(SoundEngine soundEngine) {
                            WeighedSoundEvents weighedSoundEvents = Minecraft.m_91087_().m_91106_().m_120384_(resourceLocation2);
                            if (weighedSoundEvents != null) {
                                weighedSoundEvents.m_8054_(soundEngine);
                            }
                        }
                    };
                    default -> throw new IllegalStateException("Unknown SoundEventRegistration type: " + sound.m_119795_());
                }));
            }
            soundMap.put(suffix, (Object)weighedSoundEvents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preTestEntity(ETFEntityRenderState entity) {
        this.variator.getSuffixForETFEntity(entity);
    }

    public Sound getSoundVariantOrNull() {
        int vary = this.variator.getSuffixForETFEntity(ESFSoundContext.entitySource);
        if (ESFSoundContext.entitySource != null) {
            if (vary > 0) {
                ESFSoundContext.lastSuffix.put(ESFSoundContext.entitySource.uuid(), vary);
            } else {
                ESFSoundContext.lastSuffix.removeInt((Object)ESFSoundContext.entitySource.uuid());
            }
        }
        if (vary > 0 && this.variantSounds.containsKey(vary)) {
            return ((WeighedSoundEvents)this.variantSounds.get(vary)).m_213718_(this.random);
        }
        return null;
    }

    public String toString() {
        return this.location.toString() + " [variants: " + this.variantSounds.keySet() + "]";
    }
}

