/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.methods;

import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.resources.ResourceLocation;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;

public class ESFIsPlayingSoundMethodFactory
extends MathMethod {
    public ESFIsPlayingSoundMethodFactory(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        if (log) {
            ESF.log("creating sound EMF math function definition (no guaranteed failure log messages unless you enable EMF math logging):\n > " + args);
        }
        try {
            String soundId = args.get(0);
            if (soundId == null || soundId.isBlank()) {
                throw new EMFMathException("Sound event ID invalid");
            }
            ResourceLocation test = ESF.res(soundId);
            this.setSupplierAndOptimize(() -> {
                ResourceLocation res;
                SoundEngine engine = Minecraft.m_91087_().m_91106_().f_120349_;
                if (!engine.f_120219_) {
                    return Float.NEGATIVE_INFINITY;
                }
                boolean found = false;
                for (Map.Entry entry : engine.f_120230_.entrySet()) {
                    if ((Integer)entry.getValue() > engine.f_120225_ || !(res = ((SoundInstance)entry.getKey()).m_7904_()).equals((Object)test)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    for (SoundInstance soundInstance : engine.f_120226_.keySet()) {
                        res = soundInstance.m_7904_();
                        if (!res.equals((Object)test)) continue;
                        found = true;
                        break;
                    }
                }
                return MathValue.fromBoolean((boolean)found);
            });
            if (log) {
                ESF.log("sound EMF math function definition created successfully for " + test);
            }
        }
        catch (Exception e) {
            if (log) {
                ESF.log("Error creating sound EMF math function definition: " + e.getMessage());
            }
            throw new EMFMathException("Error in playingsound() function: " + e.getMessage());
        }
    }

    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 1;
    }
}

