/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.methods;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.animation.math.EMFMathException;
import traben.entity_model_features.models.animation.math.MathComponent;
import traben.entity_model_features.models.animation.math.MathExpressionParser;
import traben.entity_model_features.models.animation.math.MathMethod;
import traben.entity_model_features.models.animation.math.MathValue;
import traben.entity_model_features.utils.EMFEntity;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;

public class ESFPlaySoundMethodFactory
extends MathMethod {
    private long lastSoundTick = 0L;

    public ESFPlaySoundMethodFactory(List<String> args, boolean isNegative, EMFAnimation calculationInstance) throws EMFMathException {
        super(isNegative, calculationInstance, args.size());
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        if (log) {
            ESF.log("creating sound EMF math function definition (no guaranteed failure log messages unless you enable EMF math logging):\n > " + String.valueOf(args));
        }
        try {
            MathComponent range;
            MathComponent pitch;
            MathComponent volume;
            String soundId = args.get(0);
            if (soundId == null || soundId.isBlank()) {
                throw new EMFMathException("Sound event ID invalid");
            }
            ResourceLocation res = ESF.res(soundId);
            WeighedSoundEvents event = Minecraft.getInstance().getSoundManager().getSoundEvent(res);
            if (event == null) {
                throw new EMFMathException("Sound event not found: " + soundId);
            }
            MathComponent trueForSound = MathExpressionParser.getOptimizedExpression((String)args.get(1), (boolean)false, (EMFAnimation)calculationInstance);
            MathComponent delay = MathExpressionParser.getOptimizedExpression((String)args.get(2), (boolean)false, (EMFAnimation)calculationInstance);
            if (delay == MathExpressionParser.NULL_EXPRESSION || trueForSound == MathExpressionParser.NULL_EXPRESSION) {
                throw new EMFMathException("Invalid arguments");
            }
            if (args.size() == 6) {
                volume = MathExpressionParser.getOptimizedExpression((String)args.get(3), (boolean)false, (EMFAnimation)calculationInstance);
                pitch = MathExpressionParser.getOptimizedExpression((String)args.get(4), (boolean)false, (EMFAnimation)calculationInstance);
                range = MathExpressionParser.getOptimizedExpression((String)args.get(5), (boolean)false, (EMFAnimation)calculationInstance);
                if (volume == MathExpressionParser.NULL_EXPRESSION || pitch == MathExpressionParser.NULL_EXPRESSION) {
                    throw new EMFMathException("Invalid optional arguments");
                }
            } else {
                volume = () -> 1.0f;
                pitch = () -> 1.0f;
                range = () -> 16.0f;
            }
            this.supplier = () -> {
                if (!MathValue.toBoolean((float)trueForSound.getResult())) {
                    return Float.NEGATIVE_INFINITY;
                }
                EMFEntity emfEntity = EMFAnimationEntityContext.getEMFEntity();
                if (emfEntity == null || emfEntity.etf$getWorld() == null) {
                    return Float.NEGATIVE_INFINITY;
                }
                float delayVal = delay.getResult();
                long currentTick = emfEntity.etf$getWorld().getGameTime();
                float f = this.lastSoundTick;
                float f2 = delayVal < 1.0f ? 1.0f : delayVal;
                if (f + f2 > (float)currentTick) {
                    return Float.NEGATIVE_INFINITY;
                }
                this.lastSoundTick = currentTick;
                try {
                    SoundSource soundSource;
                    Level level = emfEntity.etf$getWorld();
                    LocalPlayer localPlayer = Minecraft.getInstance().player;
                    BlockPos blockPos = emfEntity.etf$getBlockPos();
                    SoundEvent soundEvent = SoundEvent.createFixedRangeEvent((ResourceLocation)res, (float)Mth.clamp((float)range.getResult(), (float)0.0f, (float)128.0f));
                    if (emfEntity instanceof Entity) {
                        Entity entity = (Entity)emfEntity;
                        soundSource = entity.getSoundSource();
                    } else {
                        soundSource = SoundSource.BLOCKS;
                    }
                    level.playSound((Player)localPlayer, blockPos, soundEvent, soundSource, Mth.clamp((float)volume.getResult(), (float)0.0f, (float)1.0f), Mth.clamp((float)pitch.getResult(), (float)0.5f, (float)2.0f));
                    return Float.POSITIVE_INFINITY;
                }
                catch (Exception e) {
                    return Float.NEGATIVE_INFINITY;
                }
            };
            if (log) {
                ESF.log("sound EMF math function definition created successfully for " + String.valueOf(res));
            }
        }
        catch (Exception e) {
            if (log) {
                ESF.log("Error creating sound EMF math function definition: " + e.getMessage());
            }
            throw new EMFMathException("Error in playsound() function: " + e.getMessage());
        }
    }

    protected boolean canOptimizeForConstantArgs() {
        return false;
    }

    protected boolean hasCorrectArgCount(int argCount) {
        return argCount == 3 || argCount == 6;
    }
}

