/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundEventRegistration;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.MultipliedFloats;
import net.minecraft.util.valueproviders.SampledFloat;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFSound;
import traben.entity_sound_features.ESFSoundContext;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.state.ETFEntityRenderState;

public class ESFVariantSupplier {
    private static final TypeToken<SoundEventRegistration> SOUND_EVENT_REGISTRATION_TYPE = new TypeToken<SoundEventRegistration>(){};
    private final RandomSource random = RandomSource.create();
    protected Int2ObjectArrayMap<WeighedSoundEvents> variantSounds;
    protected ETFApi.ETFVariantSuffixProvider variator;
    protected ResourceLocation location;

    protected ESFVariantSupplier(ResourceLocation location, ETFApi.ETFVariantSuffixProvider variator, Int2ObjectArrayMap<WeighedSoundEvents> variantSounds) {
        if (variantSounds.isEmpty()) {
            throw new IllegalArgumentException("ESFVariantSupplier: Variant sounds cannot be empty");
        }
        this.variantSounds = Objects.requireNonNull(variantSounds);
        this.variator = Objects.requireNonNull(variator);
        this.location = Objects.requireNonNull(location);
        if (variator instanceof PropertiesRandomProvider) {
            PropertiesRandomProvider propeties = (PropertiesRandomProvider)variator;
            propeties.setOnMeetsRuleHook((entity, rule) -> {
                if (rule == null) {
                    ESFSoundContext.lastRuleMet.removeInt((Object)entity.uuid());
                } else {
                    ESFSoundContext.lastRuleMet.put(entity.uuid(), rule.ruleNumber);
                }
            });
        }
        ESFSoundContext.addKnownESFSound(location);
    }

    @Nullable
    public static ESFVariantSupplier getOrNull(ResourceLocation soundEventResource) {
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        try {
            String propertiesPath = soundEventResource.getNamespace() + ":esf/" + soundEventResource.getPath().replaceAll("\\.", "/") + ".properties";
            if (ResourceLocation.tryParse((String)propertiesPath) != null) {
                ResourceLocation properties = ESF.res(propertiesPath);
                ETFApi.ETFVariantSuffixProvider variator = ETFApi.getVariantSupplierOrNull((ResourceLocation)properties, (ResourceLocation)ESF.res(propertiesPath.replaceAll("\\.properties$", ".json")), (String[])new String[]{"sounds", "sound"});
                if (variator != null) {
                    if (log) {
                        ESF.log(propertiesPath + " ESF sound properties found for: " + String.valueOf(soundEventResource));
                    }
                    if (log) {
                        ESF.log("suffixes: " + String.valueOf(variator.getAllSuffixes()));
                    }
                    IntOpenHashSet suffixes = variator.getAllSuffixes();
                    suffixes.removeIf(k -> k == 1);
                    suffixes.removeIf(k -> k == 0);
                    if (!suffixes.isEmpty()) {
                        Int2ObjectArrayMap variantSounds = new Int2ObjectArrayMap();
                        String soundPrefix = propertiesPath.replaceAll("\\.properties$", "");
                        IntIterator intIterator = suffixes.iterator();
                        while (intIterator.hasNext()) {
                            int suffix = (Integer)intIterator.next();
                            ResourceLocation soundLocation = ESF.res(soundPrefix + suffix + ".json");
                            Optional soundResource = Minecraft.getInstance().getResourceManager().getResource(soundLocation);
                            if (soundResource.isPresent()) {
                                if (log) {
                                    ESF.log(propertiesPath + " adding variants from json: " + String.valueOf(soundLocation));
                                }
                                ESFVariantSupplier.parseSoundEventVariant(soundLocation, (Resource)soundResource.get(), (Int2ObjectArrayMap<WeighedSoundEvents>)variantSounds, suffix);
                                continue;
                            }
                            ResourceLocation ogg = ESF.res(soundLocation.getNamespace(), soundLocation.getPath().replaceAll("\\.json$", ".ogg"));
                            if (Minecraft.getInstance().getResourceManager().getResource(ogg).isPresent()) {
                                WeighedSoundEvents event = new WeighedSoundEvents(null, null);
                                event.addSound((Weighted)new ESFSound(ogg));
                                variantSounds.put(suffix, (Object)event);
                                if (!log) continue;
                                ESF.log(propertiesPath + " added variant: " + String.valueOf(ogg));
                                continue;
                            }
                            if (!log) continue;
                            ESF.log(propertiesPath + " invalid variants: " + String.valueOf(soundLocation) + " or " + String.valueOf(ogg));
                        }
                        if (!variantSounds.isEmpty()) {
                            return new ESFVariantSupplier(soundEventResource, variator, (Int2ObjectArrayMap<WeighedSoundEvents>)variantSounds);
                        }
                    }
                }
            } else {
                ESF.logWarn(propertiesPath + " was invalid sound properties id");
            }
        }
        catch (Exception e) {
            ESF.logError(e.getMessage());
        }
        return null;
    }

    private static void parseSoundEventVariant(ResourceLocation soundJson, Resource jsonResource, Int2ObjectArrayMap<WeighedSoundEvents> soundMap, int suffix) {
        try {
            SoundEventRegistration map = (SoundEventRegistration)GsonHelper.fromJson((Gson)SoundManager.GSON, (Reader)jsonResource.openAsReader(), SOUND_EVENT_REGISTRATION_TYPE);
            WeighedSoundEvents weighedSoundEvents = new WeighedSoundEvents(null, map.getSubtitle());
            for (final Sound sound : map.getSounds()) {
                final ResourceLocation resourceLocation2 = sound.getLocation();
                weighedSoundEvents.addSound((Weighted)(switch (sound.getType()) {
                    case Sound.Type.FILE -> {
                        ResourceLocation ogg = ESF.res(soundJson.getNamespace(), "esf/" + sound.getLocation().getPath() + ".ogg");
                        if (Minecraft.getInstance().getResourceManager().getResource(ogg).isPresent()) {
                            yield new ESFSound(ogg, sound);
                        }
                        if (Minecraft.getInstance().getResourceManager().getResource(sound.getPath()).isPresent()) {
                            yield sound;
                        }
                    }
                    case Sound.Type.SOUND_EVENT -> new Weighted<Sound>(){

                        public int getWeight() {
                            WeighedSoundEvents weighedSoundEvents = Minecraft.getInstance().getSoundManager().getSoundEvent(resourceLocation2);
                            return weighedSoundEvents == null ? 0 : weighedSoundEvents.getWeight();
                        }

                        @NotNull
                        public Sound getSound(RandomSource randomSource) {
                            WeighedSoundEvents weighedSoundEvents = Minecraft.getInstance().getSoundManager().getSoundEvent(resourceLocation2);
                            if (weighedSoundEvents == null) {
                                return SoundManager.EMPTY_SOUND;
                            }
                            Sound soundx = weighedSoundEvents.getSound(randomSource);
                            return new Sound(soundx.getLocation(), (SampledFloat)new MultipliedFloats(new SampledFloat[]{soundx.getVolume(), sound.getVolume()}), (SampledFloat)new MultipliedFloats(new SampledFloat[]{soundx.getPitch(), sound.getPitch()}), sound.getWeight(), Sound.Type.FILE, soundx.shouldStream() || sound.shouldStream(), soundx.shouldPreload(), soundx.getAttenuationDistance());
                        }

                        public void preloadIfRequired(SoundEngine soundEngine) {
                            WeighedSoundEvents weighedSoundEvents = Minecraft.getInstance().getSoundManager().getSoundEvent(resourceLocation2);
                            if (weighedSoundEvents != null) {
                                weighedSoundEvents.preloadIfRequired(soundEngine);
                            }
                        }
                    };
                    default -> throw new IllegalStateException("Unknown SoundEventRegistration type: " + String.valueOf(sound.getType()));
                }));
            }
            soundMap.put(suffix, (Object)weighedSoundEvents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preTestEntity(ETFEntityRenderState entity) {
        this.variator.getSuffixForETFEntity(entity);
    }

    public Sound getSoundVariantOrNull() {
        int vary = this.variator.getSuffixForETFEntity(ESFSoundContext.entitySource);
        if (ESFSoundContext.entitySource != null) {
            if (vary > 0) {
                ESFSoundContext.lastSuffix.put(ESFSoundContext.entitySource.uuid(), vary);
            } else {
                ESFSoundContext.lastSuffix.removeInt((Object)ESFSoundContext.entitySource.uuid());
            }
        }
        if (vary > 0 && this.variantSounds.containsKey(vary)) {
            return ((WeighedSoundEvents)this.variantSounds.get(vary)).getSound(this.random);
        }
        return null;
    }

    public String toString() {
        return this.location.toString() + " [variants: " + String.valueOf(this.variantSounds.keySet()) + "]";
    }
}

