/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.properties;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_sound_features.ESF;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.features.state.ETFEntityRenderState;

public class PlayingSoundProperty
extends StringArrayOrRegexProperty {
    private final boolean doPrint;

    protected PlayingSoundProperty(String values, boolean printing) throws RandomProperty.RandomPropertyException {
        super(values);
        this.doPrint = printing;
    }

    public static PlayingSoundProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            String val = RandomProperty.readPropertiesOrThrow((Properties)properties, (int)propertyNum, (String[])new String[]{"playingSound", "playingSounds"});
            boolean printing = val.startsWith("print:");
            return new PlayingSoundProperty(printing ? val.replaceFirst("print:", "") : val, printing);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    public boolean testEntityInternal(ETFEntityRenderState entity) {
        Set<String> sounds = PlayingSoundProperty.getPlayingSounds();
        if (this.doPrint) {
            if (sounds == null) {
                ESF.log("Sounds property print: No sounds found, this could also be from an error.");
            } else {
                ESF.log("Sounds property print: Sounds found -> " + String.valueOf(sounds));
            }
        }
        if (sounds == null) {
            return false;
        }
        for (String sound : sounds) {
            if (!this.MATCHER.testString(sound)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Set<String> getPlayingSounds() {
        class_1140 engine = class_310.method_1551().method_1483().field_5590;
        if (!engine.field_5563) {
            return null;
        }
        ObjectOpenHashSet sounds = new ObjectOpenHashSet();
        for (Map.Entry entry : engine.field_18952.entrySet()) {
            if ((Integer)entry.getValue() > engine.field_5550) continue;
            sounds.add(((class_1113)entry.getKey()).method_4775().toString().replaceFirst("minecraft:", ""));
        }
        for (class_1113 class_11132 : engine.field_18950.keySet()) {
            sounds.add(class_11132.method_4775().toString().replaceFirst("minecraft:", ""));
        }
        return sounds.isEmpty() ? null : sounds;
    }

    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"playingSound", "playingSounds"};
    }

    protected boolean shouldForceLowerCaseCheck() {
        return false;
    }

    @Nullable
    protected String getValueFromEntity(ETFEntityRenderState etfEntity) {
        return null;
    }
}

