/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import traben.entity_sound_features.ESF;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.utils.ETFEntity;
import traben.tconfig.TConfig;
import traben.tconfig.gui.entries.TConfigEntry;
import traben.tconfig.gui.entries.TConfigEntryBoolean;
import traben.tconfig.gui.entries.TConfigEntryCategory;
import traben.tconfig.gui.entries.TConfigEntryEnumButton;
import traben.tconfig.gui.entries.TConfigEntryEnumSlider;

public class ESFConfig
extends TConfig {
    public boolean logSoundSetup = false;
    public EntitySearchMode entitySearchMode = EntitySearchMode.BLOCK;
    public AnnounceMode announceCompatibleSounds = AnnounceMode.NONE;
    public ObjectOpenHashSet<String> entityDisableSounds = new ObjectOpenHashSet();

    public boolean isEntityAllowedToModifySounds(ETFEntity entity) {
        if (this.entityDisableSounds.isEmpty()) {
            return true;
        }
        return !this.entityDisableSounds.contains((Object)entity.etf$getEntityKey());
    }

    public TConfigEntryCategory getGUIOptions() {
        return new TConfigEntryCategory.Empty().add(new TConfigEntry[]{new TConfigEntryCategory("config.entity_features.sounds_main").add(new TConfigEntry[]{new TConfigEntryBoolean("entity_sound_features.config.log_setup", "entity_sound_features.config.log_setup.tooltip", () -> this.logSoundSetup, value -> {
            this.logSoundSetup = value;
        }, false), new TConfigEntryEnumButton("entity_sound_features.config.announce", "entity_sound_features.config.announce.tooltip", () -> this.announceCompatibleSounds, value -> {
            this.announceCompatibleSounds = value;
        }, (Enum)AnnounceMode.NONE), new TConfigEntryEnumSlider("entity_sound_features.config.entity_search", "entity_sound_features.config.entity_search.tooltip", () -> this.entitySearchMode, value -> {
            this.entitySearchMode = value;
        }, (Enum)EntitySearchMode.BLOCK)}), this.getEntitySettings()});
    }

    private TConfigEntryCategory getEntitySettings() {
        TConfigEntryCategory category = new TConfigEntryCategory("config.entity_features.per_entity_settings");
        try {
            BuiltInRegistries.ENTITY_TYPE.forEach(entityType -> {
                if (entityType != EntityType.PLAYER) {
                    String translationKey = entityType.getDescriptionId();
                    TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                    this.addEntitySettings(entityCategory, translationKey);
                    category.add((TConfigEntry)entityCategory);
                }
            });
            BlockEntityRenderers.PROVIDERS.keySet().forEach(entityType -> {
                String translationKey = ETFApi.getBlockEntityTypeToTranslationKey((BlockEntityType)entityType);
                TConfigEntryCategory entityCategory = new TConfigEntryCategory(translationKey);
                this.addEntitySettings(entityCategory, translationKey);
                category.add((TConfigEntry)entityCategory);
            });
        }
        catch (Exception var4) {
            var4.printStackTrace();
        }
        return category;
    }

    private void addEntitySettings(TConfigEntryCategory entityCategory, String translationKey) {
        entityCategory.add((TConfigEntry)new TConfigEntryBoolean("entity_sound_features.config.allow_entity", "entity_sound_features.config.allow_entity.tooltip", () -> !this.entityDisableSounds.contains((Object)translationKey), value -> {
            if (value.booleanValue()) {
                this.entityDisableSounds.remove((Object)translationKey);
            } else {
                this.entityDisableSounds.add((Object)translationKey);
            }
        }, true));
    }

    public ResourceLocation getModIcon() {
        return ESF.res("entity_sound_features", "textures/gui/esf_mini.png");
    }

    public static enum EntitySearchMode {
        EXACT("entity_sound_features.config.entity_search.exact"),
        BLOCK("entity_sound_features.config.entity_search.block"),
        NEAREST("entity_sound_features.config.entity_search.nearest"),
        CLIENT("entity_sound_features.config.entity_search.client");

        private final String key;

        private EntitySearchMode(String key) {
            this.key = key;
        }

        public String toString() {
            return Component.translatable((String)this.key).getString();
        }
    }

    public static enum AnnounceMode {
        NONE(""){

            @Override
            public String toString() {
                return CommonComponents.OPTION_OFF.getString();
            }
        }
        ,
        ESF("entity_sound_features.config.announce.esf"),
        ALL("entity_sound_features.config.announce.all"),
        ALL_ONCE("entity_sound_features.config.announce.all_once");

        private final String key;

        public boolean all() {
            return this == ALL || this == ALL_ONCE;
        }

        private AnnounceMode(String key) {
            this.key = key;
        }

        public String toString() {
            return Component.translatable((String)this.key).getString();
        }
    }
}

