/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.io.Reader;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1110;
import net.minecraft.class_1111;
import net.minecraft.class_1140;
import net.minecraft.class_1144;
import net.minecraft.class_1146;
import net.minecraft.class_1148;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3518;
import net.minecraft.class_5819;
import net.minecraft.class_7372;
import net.minecraft.class_7373;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFSound;
import traben.entity_sound_features.ESFSoundContext;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.features.property_reading.PropertiesRandomProvider;
import traben.entity_texture_features.features.state.ETFEntityRenderState;

public class ESFVariantSupplier {
    private static final TypeToken<class_1110> SOUND_EVENT_REGISTRATION_TYPE = new TypeToken<class_1110>(){};
    private final class_5819 random = class_5819.method_43047();
    protected Int2ObjectArrayMap<class_1146> variantSounds;
    protected ETFApi.ETFVariantSuffixProvider variator;
    protected class_2960 location;

    protected ESFVariantSupplier(class_2960 location, ETFApi.ETFVariantSuffixProvider variator, Int2ObjectArrayMap<class_1146> variantSounds) {
        if (variantSounds.isEmpty()) {
            throw new IllegalArgumentException("ESFVariantSupplier: Variant sounds cannot be empty");
        }
        this.variantSounds = Objects.requireNonNull(variantSounds);
        this.variator = Objects.requireNonNull(variator);
        this.location = Objects.requireNonNull(location);
        if (variator instanceof PropertiesRandomProvider) {
            PropertiesRandomProvider propeties = (PropertiesRandomProvider)variator;
            propeties.setOnMeetsRuleHook((entity, rule) -> {
                if (rule == null) {
                    ESFSoundContext.lastRuleMet.removeInt((Object)entity.uuid());
                } else {
                    ESFSoundContext.lastRuleMet.put(entity.uuid(), rule.ruleNumber);
                }
            });
        }
        ESFSoundContext.addKnownESFSound(location);
    }

    @Nullable
    public static ESFVariantSupplier getOrNull(class_2960 soundEventResource) {
        boolean log = ((ESFConfig)ESF.config().getConfig()).logSoundSetup;
        try {
            String propertiesPath = soundEventResource.method_12836() + ":esf/" + soundEventResource.method_12832().replaceAll("\\.", "/") + ".properties";
            if (class_2960.method_20207((String)propertiesPath)) {
                class_2960 properties = ESF.res(propertiesPath);
                ETFApi.ETFVariantSuffixProvider variator = ETFApi.getVariantSupplierOrNull((class_2960)properties, (class_2960)ESF.res(propertiesPath.replaceAll("\\.properties$", ".json")), (String[])new String[]{"sounds", "sound"});
                if (variator != null) {
                    if (log) {
                        ESF.log(propertiesPath + " ESF sound properties found for: " + String.valueOf(soundEventResource));
                    }
                    if (log) {
                        ESF.log("suffixes: " + String.valueOf(variator.getAllSuffixes()));
                    }
                    IntOpenHashSet suffixes = variator.getAllSuffixes();
                    suffixes.removeIf(k -> k == 1);
                    suffixes.removeIf(k -> k == 0);
                    if (!suffixes.isEmpty()) {
                        Int2ObjectArrayMap variantSounds = new Int2ObjectArrayMap();
                        String soundPrefix = propertiesPath.replaceAll("\\.properties$", "");
                        IntIterator intIterator = suffixes.iterator();
                        while (intIterator.hasNext()) {
                            int suffix = (Integer)intIterator.next();
                            class_2960 soundLocation = ESF.res(soundPrefix + suffix + ".json");
                            Optional soundResource = class_310.method_1551().method_1478().method_14486(soundLocation);
                            if (soundResource.isPresent()) {
                                if (log) {
                                    ESF.log(propertiesPath + " adding variants from json: " + String.valueOf(soundLocation));
                                }
                                ESFVariantSupplier.parseSoundEventVariant(soundLocation, (class_3298)soundResource.get(), (Int2ObjectArrayMap<class_1146>)variantSounds, suffix);
                                continue;
                            }
                            class_2960 ogg = ESF.res(soundLocation.method_12836(), soundLocation.method_12832().replaceAll("\\.json$", ".ogg"));
                            if (class_310.method_1551().method_1478().method_14486(ogg).isPresent()) {
                                class_1146 event = new class_1146(null, null);
                                event.method_4885((class_1148)new ESFSound(ogg));
                                variantSounds.put(suffix, (Object)event);
                                if (!log) continue;
                                ESF.log(propertiesPath + " added variant: " + String.valueOf(ogg));
                                continue;
                            }
                            if (!log) continue;
                            ESF.log(propertiesPath + " invalid variants: " + String.valueOf(soundLocation) + " or " + String.valueOf(ogg));
                        }
                        if (!variantSounds.isEmpty()) {
                            return new ESFVariantSupplier(soundEventResource, variator, (Int2ObjectArrayMap<class_1146>)variantSounds);
                        }
                    }
                }
            } else {
                ESF.logWarn(propertiesPath + " was invalid sound properties id");
            }
        }
        catch (Exception e) {
            ESF.logError(e.getMessage());
        }
        return null;
    }

    private static void parseSoundEventVariant(class_2960 soundJson, class_3298 jsonResource, Int2ObjectArrayMap<class_1146> soundMap, int suffix) {
        try {
            class_1110 map = (class_1110)class_3518.method_15297((Gson)class_1144.field_5594, (Reader)jsonResource.method_43039(), SOUND_EVENT_REGISTRATION_TYPE);
            class_1146 weighedSoundEvents = new class_1146(null, map.method_4762());
            for (final class_1111 sound : map.method_4761()) {
                final class_2960 resourceLocation2 = sound.method_4767();
                weighedSoundEvents.method_4885((class_1148)(switch (sound.method_4768()) {
                    case class_1111.class_1112.field_5474 -> {
                        class_2960 ogg = ESF.res(soundJson.method_12836(), "esf/" + sound.method_4767().method_12832() + ".ogg");
                        if (class_310.method_1551().method_1478().method_14486(ogg).isPresent()) {
                            yield new ESFSound(ogg, sound);
                        }
                        if (class_310.method_1551().method_1478().method_14486(sound.method_4766()).isPresent()) {
                            yield sound;
                        }
                    }
                    case class_1111.class_1112.field_5473 -> new class_1148<class_1111>(){

                        public int method_4894() {
                            class_1146 weighedSoundEvents = class_310.method_1551().method_1483().method_4869(resourceLocation2);
                            return weighedSoundEvents == null ? 0 : weighedSoundEvents.method_4894();
                        }

                        @NotNull
                        public class_1111 getSound(class_5819 randomSource) {
                            class_1146 weighedSoundEvents = class_310.method_1551().method_1483().method_4869(resourceLocation2);
                            if (weighedSoundEvents == null) {
                                return class_1144.field_5592;
                            }
                            class_1111 soundx = weighedSoundEvents.method_4887(randomSource);
                            return new class_1111(soundx.method_4767().toString(), (class_7373)new class_7372(new class_7373[]{soundx.method_4771(), sound.method_4771()}), (class_7373)new class_7372(new class_7373[]{soundx.method_4772(), sound.method_4772()}), sound.method_4894(), class_1111.class_1112.field_5474, soundx.method_4769() || sound.method_4769(), soundx.method_4764(), soundx.method_4770());
                        }

                        public void method_18188(class_1140 soundEngine) {
                            class_1146 weighedSoundEvents = class_310.method_1551().method_1483().method_4869(resourceLocation2);
                            if (weighedSoundEvents != null) {
                                weighedSoundEvents.method_18188(soundEngine);
                            }
                        }
                    };
                    default -> throw new IllegalStateException("Unknown SoundEventRegistration type: " + String.valueOf(sound.method_4768()));
                }));
            }
            soundMap.put(suffix, (Object)weighedSoundEvents);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void preTestEntity(ETFEntityRenderState entity) {
        this.variator.getSuffixForETFEntity(entity);
    }

    public class_1111 getSoundVariantOrNull() {
        int vary = this.variator.getSuffixForETFEntity(ESFSoundContext.entitySource);
        if (ESFSoundContext.entitySource != null) {
            if (vary > 0) {
                ESFSoundContext.lastSuffix.put(ESFSoundContext.entitySource.uuid(), vary);
            } else {
                ESFSoundContext.lastSuffix.removeInt((Object)ESFSoundContext.entitySource.uuid());
            }
        }
        if (vary > 0 && this.variantSounds.containsKey(vary)) {
            return ((class_1146)this.variantSounds.get(vary)).method_4887(this.random);
        }
        return null;
    }

    public String toString() {
        return this.location.toString() + " [variants: " + String.valueOf(this.variantSounds.keySet()) + "]";
    }
}

