/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFVariantSupplier;
import traben.entity_texture_features.features.state.ETFEntityRenderState;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.EntityIntLRU;

public class ESFSoundContext {
    private static final List<ESFVariantSupplier> variantSuppliers = new ArrayList<ESFVariantSupplier>();
    private static final ObjectOpenHashSet<class_2960> announcedSounds = new ObjectOpenHashSet();
    private static final ObjectOpenHashSet<class_2960> knownESFSounds = new ObjectOpenHashSet();
    public static ETFEntityRenderState entitySource = null;
    public static final EntityIntLRU lastRuleMet = new EntityIntLRU();
    public static final EntityIntLRU lastSuffix = new EntityIntLRU();

    public static void addKnownESFSound(class_2960 sound) {
        knownESFSounds.add((Object)sound);
    }

    public static boolean shouldCaptureEntity(class_2960 sound) {
        if (((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds.all()) {
            return true;
        }
        return knownESFSounds.contains((Object)sound);
    }

    public static void setSource(ETFEntity entity) {
        entitySource = ETFEntityRenderState.forEntity((ETFEntity)entity);
    }

    public static void preTestEntity(ETFEntityRenderState entity) {
        for (ESFVariantSupplier variantSupplier : variantSuppliers) {
            variantSupplier.preTestEntity(entity);
        }
    }

    public static void announceSound(class_2960 sound, boolean wasESF) {
        if (entitySource == null || sound == null) {
            return;
        }
        switch (((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds) {
            case ESF: {
                if (!wasESF) break;
                ESFSoundContext.announceWithEntity(sound, true);
                break;
            }
            case ALL: {
                ESFSoundContext.announceWithEntity(sound, wasESF);
                break;
            }
            case ALL_ONCE: {
                if (announcedSounds.contains((Object)sound)) break;
                ESFSoundContext.announceWithEntity(sound, wasESF);
                announcedSounds.add((Object)sound);
            }
        }
    }

    private static void announceWithEntity(class_2960 sound, boolean wasESF) {
        String pre = wasESF ? "Modifiable sound event with ESF properties: " + String.valueOf(sound) : "Modifiable sound event: " + String.valueOf(sound);
        ESF.log(pre + ", played by: " + String.valueOf(entitySource.entityType()));
        if (!wasESF) {
            ESF.log("This sound event can be modified by ESF with a properties file at: assets/" + sound.method_12836() + "/esf/" + sound.method_12832().replaceAll("\\.", "/") + ".properties");
        }
    }

    public static void resetContext() {
        ESF.log("Resetting sound context");
        variantSuppliers.clear();
        announcedSounds.clear();
        lastRuleMet.clear();
        lastSuffix.clear();
    }

    public static void searchForEntity(Iterable<class_1297> entities, double x, double y, double z) {
        block0 : switch (((ESFConfig)ESF.config().getConfig()).entitySearchMode) {
            case EXACT: {
                for (class_1297 entity : entities) {
                    if (!entity.method_5829().method_1008(x, y, z)) continue;
                    ETFEntity etfEntity = (ETFEntity)entity;
                    if (!((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity)) continue;
                    ESFSoundContext.setSource(etfEntity);
                    break block0;
                }
                break;
            }
            case BLOCK: {
                class_243 start = new class_243(x - 0.5, y - 0.5, z - 0.5);
                class_243 end = new class_243(x + 0.5, y + 0.5, z + 0.5);
                for (class_1297 entity : entities) {
                    if (!entity.method_5829().method_993(start, end)) continue;
                    ETFEntity etfEntity = (ETFEntity)entity;
                    if (!((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity)) continue;
                    ESFSoundContext.setSource(etfEntity);
                    break block0;
                }
                break;
            }
            case NEAREST: {
                double distance = Double.MAX_VALUE;
                ETFEntity nearest = null;
                for (class_1297 entity : entities) {
                    double d;
                    ETFEntity etfEntity = (ETFEntity)entity;
                    if (!((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity) || !((d = entity.method_5649(x, y, z)) < distance)) continue;
                    distance = d;
                    nearest = etfEntity;
                }
                ESFSoundContext.setSource(nearest);
                break;
            }
            case CLIENT: {
                ESFSoundContext.setSource((ETFEntity)class_310.method_1551().field_1724);
            }
        }
    }

    public static void searchForBlockEntity(class_1937 level, double x, double y, double z) {
        class_2586 blockEntity;
        if (level == null || ((ESFConfig)ESF.config().getConfig()).entitySearchMode == ESFConfig.EntitySearchMode.CLIENT) {
            return;
        }
        class_2680 state = level.method_8320(new class_2338((int)x, (int)y, (int)z));
        if (state.method_31709() && (blockEntity = level.method_8321(new class_2338((int)x, (int)y, (int)z))) instanceof ETFEntity) {
            ETFEntity etfEntity = (ETFEntity)blockEntity;
            if (((ESFConfig)ESF.config().getConfig()).isEntityAllowedToModifySounds(etfEntity)) {
                ESFSoundContext.setSource(etfEntity);
            }
        }
    }
}

