/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_sound_features.mixin.mixins;

import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import traben.entity_sound_features.ESF;
import traben.entity_sound_features.ESFConfig;
import traben.entity_sound_features.ESFSoundContext;
import traben.entity_sound_features.ESFVariantSupplier;

@Mixin(value={WeighedSoundEvents.class})
public abstract class MixinWeighedSoundEvents {
    @Unique
    private ESFVariantSupplier esf$variator = null;
    @Unique
    private ResourceLocation esf$resourceLocation = null;

    @Inject(method={"<init>(Lnet/minecraft/resources/ResourceLocation;Ljava/lang/String;)V"}, at={@At(value="TAIL")})
    private void esf$init(ResourceLocation resourceLocation, String string, CallbackInfo ci) {
        this.esf$resourceLocation = resourceLocation;
        this.esf$variator = ESFVariantSupplier.getOrNull(resourceLocation);
    }

    @Inject(method={"getSound(Lnet/minecraft/util/RandomSource;)Lnet/minecraft/client/resources/sounds/Sound;"}, at={@At(value="RETURN")}, cancellable=true)
    private void esf$soundModify(RandomSource randomSource, CallbackInfoReturnable<Sound> cir) {
        if (this.esf$variator != null) {
            Sound sound;
            boolean announce;
            boolean bl = announce = ((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds != ESFConfig.AnnounceMode.NONE;
            if (announce) {
                ESFSoundContext.announceSound(this.esf$resourceLocation, true);
            }
            if ((sound = this.esf$variator.getSoundVariantOrNull()) != null) {
                if (announce) {
                    ESF.log("Sound modified to: " + String.valueOf(sound.getLocation()));
                }
                cir.setReturnValue((Object)sound);
            } else if (announce) {
                ESF.log("Sound not modified: " + String.valueOf(((Sound)cir.getReturnValue()).getLocation()));
            }
        } else if (((ESFConfig)ESF.config().getConfig()).announceCompatibleSounds != ESFConfig.AnnounceMode.NONE) {
            ESFSoundContext.announceSound(this.esf$resourceLocation, false);
        }
    }
}

