/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.MessageQueue;
import dev.the_fireplace.lib.api.multithreading.injectables.ExecutionManager;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;

@Singleton
@ThreadSafe
@Implementation
public final class MessageQueueImpl
implements MessageQueue {
    private final Map<CommandSource, TargetMessageQueue> messageQueues = new ConcurrentHashMap<CommandSource, TargetMessageQueue>();
    private final ExecutionManager executionManager;

    @Inject
    public MessageQueueImpl(ExecutionManager executionManager) {
        this.executionManager = executionManager;
    }

    private TargetMessageQueue getOrCreateQueue(CommandSource messageTarget) {
        return this.messageQueues.computeIfAbsent(messageTarget, x$0 -> new TargetMessageQueue((CommandSource)x$0));
    }

    @Override
    public void queueMessages(CommandSource messageTarget, Component ... messages) {
        this.getOrCreateQueue(messageTarget).queueMessages(messages);
    }

    @ThreadSafe
    private class TargetMessageQueue {
        private final Queue<Component> messages = new ArrayDeque<Component>();
        private final CommandSource messageTarget;
        private final AtomicBoolean sendingMessages = new AtomicBoolean(false);

        private TargetMessageQueue(CommandSource messageTarget) {
            this.messageTarget = messageTarget;
        }

        private synchronized void queueMessages(Component ... messages) {
            this.messages.addAll(Arrays.asList(messages));
            if (!this.sendingMessages.get()) {
                MessageQueueImpl.this.executionManager.runKillable(this::sendMessages);
            }
        }

        private synchronized void sendMessages() {
            this.sendingMessages.set(true);
            while (!this.messages.isEmpty()) {
                this.messageTarget.m_213846_(this.messages.remove());
            }
            this.sendingMessages.set(false);
        }
    }
}

