/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.injectables.MessageQueue;
import dev.the_fireplace.lib.api.chat.injectables.MultilineMessageBuffer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.ArrayUtils;

@Singleton
@ThreadSafe
@Implementation
public final class MultilineMessageBufferImpl
implements MultilineMessageBuffer {
    private final Map<Integer, Buffer> messageBuffers = new ConcurrentHashMap<Integer, Buffer>();
    private final AtomicInteger currentBufferId = new AtomicInteger(Integer.MIN_VALUE);
    private final MessageQueue messageQueue;

    @Inject
    public MultilineMessageBufferImpl(MessageQueue messageQueue) {
        this.messageQueue = messageQueue;
    }

    @Override
    public int create(byte expectedMessageCount, CommandSource target) {
        int bufferId = this.currentBufferId.getAndIncrement();
        this.messageBuffers.put(bufferId, new Buffer(bufferId, expectedMessageCount, target));
        return bufferId;
    }

    @Override
    public void put(int bufferId, byte position, Component value) {
        Buffer buffer = this.messageBuffers.get(bufferId);
        if (buffer != null) {
            buffer.put(position, value);
        } else {
            FireplaceLibConstants.getLogger().warn("Tried to add a message to nonexistent buffer " + bufferId + "!", (Throwable)new Exception("Stack trace"));
        }
    }

    private class Buffer {
        private final int bufferId;
        private final Component[] messages;
        private final CommandSource target;

        private Buffer(int bufferId, byte expectedMessageCount, CommandSource target) {
            this.bufferId = bufferId;
            this.messages = new Component[expectedMessageCount];
            this.target = target;
        }

        private void put(byte position, Component value) {
            this.messages[position] = value;
            if (this.isBufferFull()) {
                this.sendBufferedMessages();
                this.cleanup();
            }
        }

        private boolean isBufferFull() {
            return !ArrayUtils.contains((Object[])this.messages, null);
        }

        private void sendBufferedMessages() {
            MultilineMessageBufferImpl.this.messageQueue.queueMessages(this.target, this.messages);
        }

        private void cleanup() {
            MultilineMessageBufferImpl.this.messageBuffers.remove(this.bufferId);
        }
    }
}

