/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat;

import com.google.common.collect.Lists;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.chat.injectables.MessageQueue;
import dev.the_fireplace.lib.api.chat.injectables.TextPaginator;
import dev.the_fireplace.lib.api.chat.injectables.TextStyles;
import dev.the_fireplace.lib.api.chat.injectables.TranslatorFactory;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.Entity;

@Singleton
@ThreadSafe
@Implementation
public final class TextPaginatorImpl
implements TextPaginator {
    private static final int RESULTS_PER_PAGE = 7;
    private final MessageQueue messageQueue;
    private final Translator translator;
    private final TextStyles textStyles;

    @Inject
    public TextPaginatorImpl(MessageQueue messageQueue, TranslatorFactory translatorFactory, TextStyles textStyles) {
        this.messageQueue = messageQueue;
        this.translator = translatorFactory.getTranslator("fireplacelib");
        this.textStyles = textStyles;
    }

    @Override
    public void sendPaginatedChat(CommandSourceStack targetCommandSource, String switchPageCommand, List<? extends Component> allItems, int pageIndex) {
        Entity messageTarget = targetCommandSource.m_81373_() != null ? targetCommandSource.m_81373_() : targetCommandSource.m_81377_();
        this.messageQueue.queueMessages((CommandSource)messageTarget, this.getPaginatedContent((CommandSource)messageTarget, allItems, pageIndex, switchPageCommand));
    }

    private static int getPageCount(int itemCount) {
        int pageCount = itemCount / 7;
        if (itemCount % 7 > 0) {
            ++pageCount;
        }
        return pageCount;
    }

    private Component[] getPaginatedContent(CommandSource target, List<? extends Component> allContent, int page, String switchPageCommand) {
        int totalPageCount = TextPaginatorImpl.getPageCount(allContent.size());
        Component header = this.getPaginationHeader(target, page, totalPageCount);
        List<? extends Component> content = TextPaginatorImpl.getPageContents(allContent, page);
        Component footer = this.getPaginationFooter(target, switchPageCommand, page, totalPageCount);
        ArrayList outputTexts = Lists.newArrayList();
        outputTexts.add(header);
        outputTexts.addAll(content);
        outputTexts.add(footer);
        return outputTexts.toArray(new Component[0]);
    }

    private Component getPaginationHeader(CommandSource target, int currentPage, int totalPageCount) {
        MutableComponent pageNumber = this.translator.getTextForTarget(target, "fireplacelib.chat.page.num", currentPage, totalPageCount);
        return Component.m_237113_((String)"-----------------").m_6270_(this.textStyles.green()).m_7220_((Component)pageNumber).m_130946_("-------------------").m_6270_(this.textStyles.green());
    }

    private static List<? extends Component> getPageContents(List<? extends Component> allContents, int page) {
        return (List)Lists.partition(allContents, (int)7).get(page - 1);
    }

    private Component getPaginationFooter(CommandSource target, String switchPageCommand, int currentPage, int totalPageCount) {
        Component nextButton = this.getNextButton(target, switchPageCommand, currentPage, totalPageCount);
        Component prevButton = this.getPreviousButton(target, switchPageCommand, currentPage);
        return Component.m_237113_((String)"---------------").m_6270_(this.textStyles.green()).m_7220_(prevButton).m_130946_("---").m_6270_(this.textStyles.green()).m_7220_(nextButton).m_130946_("-------------").m_6270_(this.textStyles.green());
    }

    private Component getNextButton(CommandSource target, String switchPageCommand, int currentPage, int totalPageCount) {
        ClickEvent viewNextPage = new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(switchPageCommand, currentPage + 1));
        return currentPage < totalPageCount ? this.translator.getTextForTarget(target, "fireplacelib.chat.page.next", new Object[0]).m_6270_(Style.f_131099_.m_131142_(viewNextPage)) : Component.m_237113_((String)"-----");
    }

    private Component getPreviousButton(CommandSource target, String switchPageCommand, int currentPage) {
        ClickEvent viewPreviousPage = new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format(switchPageCommand, currentPage - 1));
        return currentPage > 1 ? this.translator.getTextForTarget(target, "fireplacelib.chat.page.prev", new Object[0]).m_6270_(Style.f_131099_.m_131142_(viewPreviousPage)) : Component.m_237113_((String)"------");
    }
}

