/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.chat.translation;

import dev.the_fireplace.lib.chat.translation.ModLanguageMaps;
import javax.inject.Singleton;

@Singleton
public final class I18n {
    public String translateToLocalFormatted(String modid, String key, Object ... format) {
        return this.hasPrimaryTranslation(modid, key) ? this.translateToPrimary(modid, key, format) : this.translateToFallback(modid, key, format);
    }

    private String translateToPrimary(String modid, String key, Object ... format) {
        return ModLanguageMaps.getPrimaryMap(modid).translateKeyFormat(key, format);
    }

    private String translateToFallback(String modid, String key, Object ... format) {
        return ModLanguageMaps.getFallbackMap(modid).translateKeyFormat(key, format);
    }

    private boolean hasPrimaryTranslation(String modid, String key) {
        return ModLanguageMaps.getPrimaryMap(modid).isKeyTranslated(key);
    }
}

