/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.command.helpers;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.command.injectables.ArgumentTypeFactory;
import dev.the_fireplace.lib.api.command.interfaces.PlayerSelector;
import dev.the_fireplace.lib.api.command.interfaces.PossiblyOfflinePlayer;
import dev.the_fireplace.lib.command.helpers.OfflinePlayerArgumentParser;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import javax.inject.Singleton;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;

@Singleton
@Implementation
public final class ArgumentTypeFactoryImpl
implements ArgumentTypeFactory {
    @Override
    public StringArgumentType possiblyOfflinePlayer() {
        return StringArgumentType.word();
    }

    @Override
    public PossiblyOfflinePlayer getPossiblyOfflinePlayer(CommandContext<CommandSourceStack> commandContext, String string) throws CommandSyntaxException {
        OfflinePlayerArgumentParser offlinePlayerArgumentParser = new OfflinePlayerArgumentParser();
        String inputString = StringArgumentType.getString(commandContext, (String)string);
        PlayerSelector selector = offlinePlayerArgumentParser.parse(new StringReader(inputString));
        return selector.get((CommandSourceStack)commandContext.getSource());
    }

    @Override
    public <S> CompletableFuture<Suggestions> listOfflinePlayerSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof SharedSuggestionProvider) {
            SharedSuggestionProvider commandSource = (SharedSuggestionProvider)object;
            StringReader reader = new StringReader(builder.getInput());
            reader.setCursor(builder.getStart());
            EntitySelectorParser entitySelectorReader = new EntitySelectorParser(reader);
            try {
                entitySelectorReader.m_121377_();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return entitySelectorReader.m_121249_(builder, suggestionsBuilder -> {
                Collection iterable = commandSource.m_5982_();
                SharedSuggestionProvider.m_82970_((Iterable)iterable, (SuggestionsBuilder)suggestionsBuilder);
            });
        }
        return Suggestions.empty();
    }
}

