/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.command.helpers;

import com.google.common.collect.Lists;
import com.google.inject.Injector;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.the_fireplace.lib.FireplaceLibConstants;
import dev.the_fireplace.lib.api.chat.injectables.TextPaginator;
import dev.the_fireplace.lib.api.chat.injectables.TextStyles;
import dev.the_fireplace.lib.api.chat.interfaces.Translator;
import dev.the_fireplace.lib.api.command.interfaces.HelpCommand;
import dev.the_fireplace.lib.chat.translation.TranslatorManager;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public final class HelpCommandImpl
implements HelpCommand {
    private static final Function<String, Collection<String>> NEW_CHILD_NODE_SET = unused -> new HashSet(2);
    private final TextStyles textStyles;
    private final TextPaginator textPaginator;
    private final Translator translator;
    private final String modId;
    private final LiteralArgumentBuilder<CommandSourceStack> helpCommandBase;
    private final Map<String, Collection<String>> commands = new HashMap<String, Collection<String>>();
    private final IntSet grandchildNodeHashes = new IntArraySet(3);

    HelpCommandImpl(String modId, LiteralArgumentBuilder<CommandSourceStack> helpCommandBase) {
        this.modId = modId;
        this.helpCommandBase = helpCommandBase;
        Injector injector = FireplaceLibConstants.getInjector();
        this.translator = ((TranslatorManager)injector.getInstance(TranslatorManager.class)).getTranslator(modId);
        this.textStyles = (TextStyles)injector.getInstance(TextStyles.class);
        this.textPaginator = (TextPaginator)injector.getInstance(TextPaginator.class);
    }

    @Override
    public HelpCommand addCommands(CommandNode<?> ... commands) {
        String[] commandNames = (String[])Arrays.stream(commands).map(CommandNode::getName).toArray(String[]::new);
        return this.addCommands(commandNames);
    }

    @Override
    public HelpCommand addCommands(String ... commands) {
        for (String command : commands) {
            this.commands.putIfAbsent(command, Collections.emptySet());
        }
        this.commands.putIfAbsent(this.helpCommandBase.getLiteral(), Collections.emptySet());
        return this;
    }

    @Override
    public HelpCommand addSubCommandsFromCommands(CommandNode<?> ... commands) {
        for (CommandNode<?> node : commands) {
            Iterator it = node.getChildren().stream().sorted().iterator();
            while (it.hasNext()) {
                int childPathHash;
                CommandNode child = (CommandNode)it.next();
                if (!this.isNewChild(child, childPathHash = this.buildChildPathHash(new StringBuilder(), child))) continue;
                this.commands.computeIfAbsent(node.getName(), NEW_CHILD_NODE_SET).add(child.getName());
                this.grandchildNodeHashes.add(childPathHash);
            }
        }
        this.commands.putIfAbsent(this.helpCommandBase.getLiteral(), Collections.emptySet());
        return this;
    }

    private boolean isNewChild(CommandNode<?> child, int childPathHash) {
        return child instanceof LiteralCommandNode && !this.grandchildNodeHashes.contains(childPathHash);
    }

    private int buildChildPathHash(StringBuilder stringBuilder, CommandNode<?> node) {
        if (stringBuilder.length() > 0) {
            stringBuilder.append(node.getName()).append("->");
        } else {
            stringBuilder.append("root->");
        }
        Optional firstGrandchild = node.getChildren().stream().sorted().findFirst();
        if (firstGrandchild.isEmpty()) {
            return stringBuilder.append(node.getCommand().toString()).toString().hashCode();
        }
        return this.buildChildPathHash(stringBuilder, (CommandNode)firstGrandchild.get());
    }

    @Override
    public CommandNode<CommandSourceStack> register(CommandDispatcher<CommandSourceStack> commandDispatcher) {
        return commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)this.helpCommandBase.executes(command -> this.runHelpCommand((CommandContext<CommandSourceStack>)command, 1))).then(Commands.m_82129_((String)"page", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(command -> this.runHelpCommand((CommandContext<CommandSourceStack>)command, (Integer)command.getArgument("page", Integer.class)))));
    }

    private int runHelpCommand(CommandContext<CommandSourceStack> command, int page) {
        this.textPaginator.sendPaginatedChat((CommandSourceStack)command.getSource(), "/" + this.helpCommandBase.getLiteral() + " %s", this.getHelpsList(command), page);
        return 1;
    }

    private List<? extends Component> getHelpsList(CommandContext<CommandSourceStack> command) {
        ArrayList helpComponents = Lists.newArrayList();
        for (Map.Entry<String, Collection<String>> commandName : this.commands.entrySet()) {
            if (commandName.getValue().isEmpty()) {
                MutableComponent commandHelp = this.buildCommandDescription(command, commandName.getKey());
                helpComponents.add(commandHelp);
                continue;
            }
            for (String subCommand : commandName.getValue()) {
                MutableComponent commandHelp = this.buildSubCommandDescription(command, commandName.getKey(), subCommand);
                helpComponents.add(commandHelp);
            }
        }
        helpComponents.sort(Comparator.comparing(Component::getString));
        int i = 0;
        for (MutableComponent helpComponent : helpComponents) {
            helpComponent.m_6270_(i++ % 2 == 0 ? this.textStyles.white() : this.textStyles.grey());
        }
        return helpComponents;
    }

    private MutableComponent buildCommandDescription(CommandContext<CommandSourceStack> command, String commandName) {
        return this.translator.getTextForTarget((CommandSourceStack)command.getSource(), "commands." + this.modId + "." + commandName + ".usage", new Object[0]).m_130946_(": ").m_7220_((Component)this.translator.getTextForTarget((CommandSourceStack)command.getSource(), "commands." + this.modId + "." + commandName + ".description", new Object[0]));
    }

    private MutableComponent buildSubCommandDescription(CommandContext<CommandSourceStack> command, String commandName, String subCommand) {
        return this.translator.getTextForTarget((CommandSourceStack)command.getSource(), "commands." + this.modId + "." + commandName + "." + subCommand + ".usage", new Object[0]).m_130946_(": ").m_7220_((Component)this.translator.getTextForTarget((CommandSourceStack)command.getSource(), "commands." + this.modId + "." + commandName + "." + subCommand + ".description", new Object[0]));
    }
}

