/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.command.helpers;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import dev.the_fireplace.lib.api.command.interfaces.PlayerSelector;
import dev.the_fireplace.lib.api.command.interfaces.PossiblyOfflinePlayer;
import dev.the_fireplace.lib.command.helpers.SelectedPlayerArgument;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.GameProfileCache;

final class OfflinePlayerSelector
implements PlayerSelector {
    private final EntitySelector entitySelector;
    private final String offlinePlayerName;

    OfflinePlayerSelector(EntitySelector entitySelector, String offlinePlayerName) {
        this.entitySelector = entitySelector;
        this.offlinePlayerName = offlinePlayerName;
    }

    @Override
    public PossiblyOfflinePlayer get(CommandSourceStack source) throws CommandSyntaxException {
        try {
            List list = this.entitySelector.m_121166_(source);
            if (list.size() != 1) {
                throw EntityArgument.f_91440_.create();
            }
            ServerPlayer player = (ServerPlayer)list.get(0);
            return new SelectedPlayerArgument(player.m_36316_(), player);
        }
        catch (CommandSyntaxException e) {
            MinecraftServer server = source.m_81377_();
            GameProfileCache.m_11004_((boolean)true);
            Optional offlinePlayerProfileByName = server.m_129927_().m_10996_(this.offlinePlayerName);
            if (offlinePlayerProfileByName.isPresent()) {
                return new SelectedPlayerArgument((GameProfile)offlinePlayerProfileByName.get());
            }
            try {
                Optional offlinePlayerProfileById = server.m_129927_().m_11002_(UUID.fromString(this.offlinePlayerName));
                if (offlinePlayerProfileById.isPresent()) {
                    return new SelectedPlayerArgument((GameProfile)offlinePlayerProfileById.get());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            throw EntityArgument.f_91440_.create();
        }
    }
}

