/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config;

import dev.the_fireplace.annotateddi.api.di.Implementation;
import dev.the_fireplace.lib.api.io.interfaces.access.SimpleBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageReadBuffer;
import dev.the_fireplace.lib.api.io.interfaces.access.StorageWriteBuffer;
import dev.the_fireplace.lib.api.lazyio.injectables.ConfigStateManager;
import dev.the_fireplace.lib.api.lazyio.interfaces.Config;
import dev.the_fireplace.lib.chat.translation.ModLanguageMaps;
import dev.the_fireplace.lib.domain.config.ConfigValues;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;

@Singleton
@Implementation(value={"dev.the_fireplace.lib.domain.config.ConfigValues"})
public final class FLConfig
implements Config,
ConfigValues {
    private final ConfigValues defaultConfig;
    private String locale;
    private short essentialThreadPoolSize;
    private short nonEssentialThreadPoolSize;

    @Inject
    public FLConfig(ConfigStateManager configStateManager, @Named(value="default") ConfigValues defaultConfig) {
        this.defaultConfig = defaultConfig;
        configStateManager.initialize(this);
    }

    @Override
    public void afterReload(SimpleBuffer changedValues) {
        if (changedValues.hasKey("locale")) {
            ModLanguageMaps.reloadLanguage();
        }
    }

    @Override
    public void readFrom(StorageReadBuffer buffer) {
        this.locale = buffer.readString("locale", this.defaultConfig.getLocale());
        this.essentialThreadPoolSize = buffer.readShort("essentialThreadPoolSize", this.defaultConfig.getEssentialThreadPoolSize());
        this.nonEssentialThreadPoolSize = buffer.readShort("nonEssentialThreadPoolSize", this.defaultConfig.getNonEssentialThreadPoolSize());
    }

    @Override
    public void writeTo(StorageWriteBuffer buffer) {
        buffer.writeString("locale", this.locale);
        buffer.writeShort("essentialThreadPoolSize", this.essentialThreadPoolSize);
        buffer.writeShort("nonEssentialThreadPoolSize", this.nonEssentialThreadPoolSize);
    }

    @Override
    public String getId() {
        return "fireplacelib";
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    @Override
    public short getEssentialThreadPoolSize() {
        return this.essentialThreadPoolSize;
    }

    @Override
    public short getNonEssentialThreadPoolSize() {
        return this.nonEssentialThreadPoolSize;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setEssentialThreadPoolSize(short essentialThreadPoolSize) {
        this.essentialThreadPoolSize = essentialThreadPoolSize;
    }

    public void setNonEssentialThreadPoolSize(short nonEssentialThreadPoolSize) {
        this.nonEssentialThreadPoolSize = nonEssentialThreadPoolSize;
    }
}

