/*
 * Decompiled with CFR 0.152.
 */
package dev.the_fireplace.lib.config.cloth;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.ClassUtils;

public final class ClothParameterTypeConverter {
    public static Iterator<Class<?>> getPotentialClasses(Class<?> parameterClass) {
        ArrayList potentialClasses = Lists.newArrayList((Object[])new Class[]{parameterClass});
        Class primitiveClass = ClassUtils.wrapperToPrimitive(parameterClass);
        if (primitiveClass != null) {
            potentialClasses.add(primitiveClass);
        }
        if (parameterClass.getName().contains("$$Lambda$")) {
            potentialClasses.add(Consumer.class);
            potentialClasses.add(Function.class);
        }
        if (List.class.isAssignableFrom(parameterClass)) {
            potentialClasses.add(List.class);
        }
        potentialClasses.add(Object.class);
        return potentialClasses.iterator();
    }
}

